/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.attachment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AttachmentService {
    private static final Log LOG = LogFactory.getLog(AttachmentService.class);
    private static final String ATTACHMENT_SOURCE = "filesource";
    private static final String ATTACHMENT_CACHE_PREFIX = "TampAttCache";
    private static final String PANEL_ATTACHMENTPANELAP = "attachmentpanelap";
    public static final String KEY_FFILEID = "ffileid";
    public static final String KEY_ATTACHMENTNAME = "attachmentname";
    private static final String DOWNLOAD_URL = "/attachment/download.do?path=";

    public void updateAttachmentSource(IFormView view, AttachmentSource attachmentSource) {
        if (view == null) {
            return;
        }
        if (attachmentSource == null) {
            return;
        }
        String attachmentCacheKey = ATTACHMENT_CACHE_PREFIX + view.getPageId();
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get(attachmentCacheKey);
        if (!StringUtils.isEmpty((String)cacheJsonString)) {
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            for (Map.Entry<String, List<Map<String, Object>>> entry : attachmentInfo.entrySet()) {
                this.putAttachmentSource(attachmentSource, entry);
            }
            cache.remove(attachmentCacheKey);
            cache.put(attachmentCacheKey, SerializationUtils.toJsonString((Object)attachmentInfo));
        }
    }

    public void saveAttachment(Object pkId, String fileName, String url, int fileSize, String formId, AttachmentSource attachmentSource) {
        ORM orm = ORM.create();
        Date today = DateUtils.nowDateTime();
        DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
        long id = orm.genLongId("bos_attachment");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("FNUMBER", (Object)id);
        dynamicObject.set("FBillType", (Object)formId);
        dynamicObject.set("FInterID", pkId);
        dynamicObject.set("FModifyTime", (Object)today);
        dynamicObject.set("fcreatetime", (Object)today);
        dynamicObject.set("FaliasFileName", (Object)fileName);
        dynamicObject.set("FAttachmentName", (Object)fileName);
        dynamicObject.set("FExtName", (Object)url.substring(url.lastIndexOf(46)));
        dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
        dynamicObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
        dynamicObject.set("fattachmentpanel", (Object)PANEL_ATTACHMENTPANELAP);
        dynamicObject.set("fdescription", (Object)fileName);
        dynamicObject.set(ATTACHMENT_SOURCE, (Object)attachmentSource.code);
        dynamicObject.set("FFileId", (Object)url);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        LOG.info("AttachmentService.uploadAttachment success: {}", (Object)save.length);
    }

    private void putAttachmentSource(AttachmentSource attachmentSource, Map.Entry<String, List<Map<String, Object>>> attachmentEntry) {
        for (Map<String, Object> attachmentMap : attachmentEntry.getValue()) {
            Object sourceValue = attachmentMap.get(ATTACHMENT_SOURCE);
            if (sourceValue != null) {
                attachmentMap.remove(ATTACHMENT_SOURCE);
            }
            attachmentMap.put(ATTACHMENT_SOURCE, attachmentSource.code);
        }
    }

    public void saveAttachment(Object pkId, String formId, AttachmentSource attachmentSource, DynamicObject[] attachments) {
        Date today = DateUtils.nowDateTime();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_attachment");
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)attachments.length);
        for (DynamicObject attachmentObj : attachments) {
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            Long attachId = ID.genLongId();
            String attachmentUrl = attachmentObj.getString(KEY_FFILEID);
            String downUrl = System.getProperty("domain.contextUrl") + DOWNLOAD_URL + attachmentUrl;
            LOG.error("CreateMkOfferServiceImpl.initAttachment downUrl {}:", (Object)downUrl);
            String attachmentName = attachmentObj.getString(KEY_ATTACHMENTNAME);
            Integer attachmentsize = attachmentObj.getInt("attachmentsize");
            String customfilename = attachmentObj.getString("customfilename");
            LOG.error("CreateMkOfferServiceImpl.initAttachment customfilename {} attachmentName {} attachmentsize {}", new Object[]{customfilename, attachmentName, attachmentsize});
            dynamicObject.set("id", (Object)attachId);
            dynamicObject.set("FNUMBER", (Object)attachId);
            dynamicObject.set("FBillType", (Object)formId);
            dynamicObject.set("FInterID", pkId);
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)attachmentName);
            dynamicObject.set("FAttachmentName", (Object)attachmentName);
            dynamicObject.set("FExtName", (Object)attachmentUrl.substring(attachmentUrl.lastIndexOf(46)));
            dynamicObject.set("FATTACHMENTSIZE", (Object)attachmentsize);
            dynamicObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
            dynamicObject.set("fattachmentpanel", (Object)PANEL_ATTACHMENTPANELAP);
            dynamicObject.set("fdescription", (Object)customfilename);
            dynamicObject.set(ATTACHMENT_SOURCE, (Object)attachmentSource.code);
            dynamicObject.set("FFileId", (Object)attachmentUrl);
            dynamicObjects.add(dynamicObject);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        LOG.info("AttachmentService.uploadAttachment success: {}", (Object)save.length);
    }

    public void saveAttachment(Object pkId, String formId, AttachmentSource attachmentSource, List<Map<String, Object>> attachments) {
        Date today = DateUtils.nowDateTime();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_attachment");
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)attachments.size());
        for (Map<String, Object> attachment : attachments) {
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            Long attachId = ID.genLongId();
            DynamicObject attachmentObj = AttachmentServiceHelper.getAttCreatorByUID((String)attachment.get("uid").toString());
            String fileName = attachmentObj.getString("fattachmentname");
            Integer fileSize = attachmentObj.getInt("fattachmentsize");
            String url = attachmentObj.getString(KEY_FFILEID);
            Object description = attachment.get("description");
            LOG.info("AttachmentService.saveAttachment description: {}", description);
            dynamicObject.set("id", (Object)attachId);
            dynamicObject.set("FNUMBER", (Object)attachId);
            dynamicObject.set("FBillType", (Object)formId);
            dynamicObject.set("FInterID", pkId);
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)fileName);
            dynamicObject.set("FAttachmentName", (Object)fileName);
            dynamicObject.set("FExtName", attachmentObj.get("fextname"));
            dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
            dynamicObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
            dynamicObject.set("fattachmentpanel", (Object)PANEL_ATTACHMENTPANELAP);
            dynamicObject.set("fdescription", description);
            dynamicObject.set(ATTACHMENT_SOURCE, (Object)attachmentSource.code);
            dynamicObject.set("FFileId", (Object)url);
            dynamicObjects.add(dynamicObject);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        LOG.info("AttachmentService.saveAttachment success: {}", (Object)save.length);
    }

    public void deleteAttachment(String formId, Object pkId, Object fileUid) {
        if (HRStringUtils.isEmpty((String)formId)) {
            return;
        }
        if (pkId == null) {
            return;
        }
        if (fileUid == null) {
            return;
        }
        AttachmentServiceHelper.remove((String)formId, (Object)pkId, (Object)fileUid);
    }

    public List<Map<String, Object>> getAttachmentList(String formId, Object pkId, String attachKey) {
        if (HRStringUtils.isEmpty((String)formId)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (pkId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (HRStringUtils.isEmpty((String)attachKey)) {
            return new ArrayList<Map<String, Object>>();
        }
        return AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey, (boolean)false);
    }

    public List<Map<String, Object>> getAttachmentList(String formId, Object pkId, String attachKey, AttachmentSource attachmentSource) {
        if (HRStringUtils.isEmpty((String)formId)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (pkId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (HRStringUtils.isEmpty((String)attachKey)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (attachmentSource == null) {
            return new ArrayList<Map<String, Object>>();
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey);
        LOG.info("AttachmentService.getAttachmentList attachments : {} by pkId : {}", (Object)attachments, pkId);
        if (attachments == null || attachments.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        attachments.removeIf(attachment -> attachmentSource.getCode() != Integer.parseInt(attachment.get("fileSource") + ""));
        LOG.info("AttachmentService.getAttachmentList attachments : {} by pkId : {}", (Object)attachments, pkId);
        return attachments;
    }

    public List<Object> getAttachmentUidList(String formId, Object pkId, String attachKey, AttachmentSource attachmentSource) {
        if (HRStringUtils.isEmpty((String)formId)) {
            return new ArrayList<Object>();
        }
        if (pkId == null) {
            return new ArrayList<Object>();
        }
        if (HRStringUtils.isEmpty((String)attachKey)) {
            return new ArrayList<Object>();
        }
        if (attachmentSource == null) {
            return new ArrayList<Object>();
        }
        List<Map<String, Object>> attachments = this.getAttachmentList(formId, pkId, attachKey);
        ArrayList<Object> attachmentUIDs = new ArrayList<Object>(attachments.size());
        for (Map<String, Object> attachment : attachments) {
            if (attachmentSource.getCode() == Integer.parseInt(attachment.get("fileSource") + "")) continue;
            attachmentUIDs.add(attachment.get("uid"));
        }
        return attachmentUIDs;
    }

    public static enum Singleton {
        INSTANCE;

        private final AttachmentService instance = new AttachmentService();

        public AttachmentService getInstance() {
            return this.instance;
        }
    }

    public static enum AttachmentSource {
        SCAPPREG(1000),
        OFFER(1001),
        MOKA(1002),
        HCF(1003);

        private int code;

        public int getCode() {
            return this.code;
        }

        private AttachmentSource(int code) {
            this.code = code;
        }

        public static AttachmentSource getCode(Integer code) {
            for (AttachmentSource value : AttachmentSource.values()) {
                if (value.getCode() != code.intValue()) continue;
                return value;
            }
            return null;
        }
    }
}

