/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class StandardItemEventServicePlugin
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(StandardItemEventServicePlugin.class);
    private static HRBaseServiceHelper OFFERFIELDHELPER = new HRBaseServiceHelper("tsrbd_offerfield");
    private static HRBaseServiceHelper PAGEMSGFIELDSCHEME = new HRBaseServiceHelper("tsrbd_msgtempfldscm");
    private static HRBaseServiceHelper FIELDPOOLSERVICEHELPER = new HRBaseServiceHelper("tsrbd_fieldpool");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            try (TXHandle tx = TX.required();){
                EntityEvent entityEvent = (EntityEvent)evt;
                String operation = entityEvent.getOperation();
                String entityNumber = entityEvent.getEntityNumber();
                List businessKeys = entityEvent.getBusinesskeys().stream().map(Long::new).collect(Collectors.toList());
                log.info("StandardItemEventServicePlugin.operation\uff1a{}\uff0centityNumber\uff1a{}\uff0cbusinessKeys\uff1a{}", new Object[]{operation, entityNumber, businessKeys});
                QFilter qFilter = new QFilter("id", "in", businessKeys).and("bizType", "like", (Object)"%3%");
                DynamicObject[] object = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,number,name,status,enable", (QFilter[])new QFilter[]{qFilter});
                if (HRObjectUtils.isEmpty((Object)object) && !"delete".equals(operation)) {
                    log.info("hsbs_standarditem data not found businessKeys\uff1a{}", businessKeys);
                    Object object2 = super.handleEvent(evt);
                    return object2;
                }
                DynamicObject[] offerField = OFFERFIELDHELPER.query("bizfield,enable,status", new QFilter[]{new QFilter("bizfield", "in", (Object)entityEvent.getBusinesskeys())});
                List<DynamicObjectCollection> entryEntity = null;
                DynamicObject[] msgTempFldScms = PAGEMSGFIELDSCHEME.query("entryentity.offerfield,entryentity.fieldstatus", null);
                if (null != msgTempFldScms) {
                    entryEntity = Arrays.stream(msgTempFldScms).map(msgTempFldScm -> msgTempFldScm.getDynamicObjectCollection("entryentity")).collect(Collectors.toList());
                }
                switch (operation) {
                    case "save": 
                    case "submit": {
                        offerField = this.saveOrSubmitOp(object, entryEntity, offerField);
                        break;
                    }
                    case "enable": 
                    case "audit": {
                        this.enableOp(object, entryEntity, offerField);
                        break;
                    }
                    case "disable": 
                    case "unaudit": 
                    case "unsubmit": {
                        this.disEnableOp(object, entryEntity, offerField);
                        break;
                    }
                    case "delete": {
                        this.deleteOp(entryEntity, offerField);
                        break;
                    }
                }
                OFFERFIELDHELPER.save(offerField);
                PAGEMSGFIELDSCHEME.save(msgTempFldScms);
            }
        }
        return super.handleEvent(evt);
    }

    private DynamicObject[] newOp(DynamicObject[] object) {
        ArrayList pools = Lists.newArrayListWithExpectedSize((int)object.length);
        ArrayList msgFields = Lists.newArrayListWithExpectedSize((int)object.length);
        for (DynamicObject obj : object) {
            DynamicObject pool = BusinessDataServiceHelper.newDynamicObject((String)"tsrbd_fieldpool");
            long id = ORM.create().genLongId(FIELDPOOLSERVICEHELPER.getEntityName());
            pool.set("id", (Object)id);
            pool.set("status", (Object)"C");
            pool.set("enable", (Object)"1");
            pool.set("number", obj.get("number"));
            pool.set("name", obj.get("name"));
            pool.set("fieldkey", obj.get("id"));
            pools.add(pool);
            DynamicObject msgField = BusinessDataServiceHelper.newDynamicObject((String)"tsrbd_offerfield");
            msgField.set("enable", obj.get("enable"));
            msgField.set("status", obj.get("status"));
            msgField.set("number", obj.get("number"));
            msgField.set("name", obj.get("name"));
            msgField.set("group", (Object)1564605693112209408L);
            msgField.set("fieldpool", (Object)id);
            msgField.set("bizfield", obj.get("id"));
            msgField.set("bizrange", (Object)",0,");
            msgFields.add(msgField);
        }
        FIELDPOOLSERVICEHELPER.save(pools.toArray(new DynamicObject[0]));
        return msgFields.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] saveOrSubmitOp(DynamicObject[] object, List<DynamicObjectCollection> entryEntity, DynamicObject[] offerField) {
        if (0 == offerField.length) {
            offerField = this.newOp(object);
        } else {
            this.setFieldStatus(object, offerField);
            this.setFieldSchemeStatus(entryEntity, offerField, "B");
        }
        return offerField;
    }

    private void enableOp(DynamicObject[] object, List<DynamicObjectCollection> entryEntity, DynamicObject[] offerField) {
        this.setFieldStatus(object, offerField);
        this.setFieldSchemeStatus(entryEntity, offerField, "A");
    }

    private void disEnableOp(DynamicObject[] object, List<DynamicObjectCollection> entryEntity, DynamicObject[] offerField) {
        this.setFieldStatus(object, offerField);
        this.setFieldSchemeStatus(entryEntity, offerField, "B");
    }

    private void deleteOp(List<DynamicObjectCollection> entryEntity, DynamicObject[] offerField) {
        for (DynamicObject dy : offerField) {
            dy.set("enable", (Object)"0");
        }
        this.setFieldSchemeStatus(entryEntity, offerField, "B");
    }

    private void setFieldSchemeStatus(List<DynamicObjectCollection> entryEntity, DynamicObject[] offerField, String fieldStatus) {
        for (DynamicObjectCollection collection : entryEntity) {
            for (DynamicObject entry : collection) {
                for (DynamicObject dy : offerField) {
                    if (HRObjectUtils.isEmpty((Object)entry.getDynamicObject("offerfield")) || dy.getLong("id") != entry.getDynamicObject("offerfield").getLong("id")) continue;
                    entry.set("fieldstatus", (Object)fieldStatus);
                }
            }
        }
    }

    private void setFieldStatus(DynamicObject[] object, DynamicObject[] offerField) {
        for (DynamicObject dy : offerField) {
            for (DynamicObject obj : object) {
                if (obj.getLong("id") != dy.getLong("bizfield")) continue;
                dy.set("number", obj.get("number"));
                dy.set("enable", obj.get("enable"));
                dy.set("status", obj.get("status"));
                dy.set("name", obj.get("name"));
            }
        }
    }
}

