/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;

public class InductionFieldEditSwitchHelper {
    private static final String FIELDENABLE_FIELDID = "displaycontrol";
    public static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tso_offerfieswit");

    public JSONObject queryFieldEnableJsonByOfferId(Long offerId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tso_offerfieswit");
        QFilter qFilter = new QFilter("offer", "=", (Object)offerId);
        DynamicObject fieldEnableObj = helper.queryOne(FIELDENABLE_FIELDID, qFilter.toArray());
        if (Objects.isNull(fieldEnableObj)) {
            return null;
        }
        String fieldSrcJson = fieldEnableObj.getString(FIELDENABLE_FIELDID);
        JSONObject fieldSrcJsonObj = JSONObject.parseObject((String)fieldSrcJson);
        return fieldSrcJsonObj;
    }

    public OfferFieldEnableEnum getInfoFormCache(IFormView formView, String key) {
        String str = formView.getPageCache().get("fieldSwitchCacheKey");
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        if (jsonObject == null) {
            return null;
        }
        String string = jsonObject.getString(key);
        if (string.equals("1")) {
            return OfferFieldEnableEnum.NOT_ENABLE;
        }
        if (string.equals("0")) {
            return OfferFieldEnableEnum.ENABLE;
        }
        return null;
    }

    public void updateFieldSwitch(IFormView inducBaseView) {
        Long inducInfoId = Long.parseLong(inducBaseView.getModel().getValue("id").toString());
        String fieldSwitchInfo = inducBaseView.getPageCache().get("fieldSwitchCacheKey");
        if (HRStringUtils.isEmpty((String)fieldSwitchInfo)) {
            return;
        }
        if (inducBaseView.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            HRBaseServiceHelper fieldSwitchServiceHelper = new HRBaseServiceHelper("tso_offerfieswit");
            DynamicObject fieldEditObj = fieldSwitchServiceHelper.generateEmptyDynamicObject();
            fieldEditObj.set("pagekey", (Object)"tso_inductioninfo");
            fieldEditObj.set(FIELDENABLE_FIELDID, (Object)fieldSwitchInfo);
            fieldEditObj.set("offer", (Object)inducInfoId);
            fieldSwitchServiceHelper.saveOne(fieldEditObj);
            return;
        }
        this.updateOfferFieldSrcByOfferId("tso_inductioninfo", inducInfoId, fieldSwitchInfo);
    }

    public void updateOfferFieldSrcByOfferId(String entityId, Long offerId, String fieldEnableJson) {
        String updateSql = "update T_TSO_OFFERFIESWIT set FDISPLAYCONT = ? where FOFFERID = ? and FPAGEKEY = ?";
        HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])new Object[]{fieldEnableJson, offerId, entityId});
    }

    public void updateFieldSrcToPageCache(OfferFieldEnableEnum enableEnum, IFormView formView, String ... controlIds) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        if (formShowParameter.getStatus() == OperationStatus.VIEW) {
            return;
        }
        IPageCache pageCache = formView.getPageCache();
        String fieldSrcObjStr = pageCache.get("fieldSwitchCacheKey");
        if (HRStringUtils.isEmpty((String)fieldSrcObjStr)) {
            return;
        }
        JSONObject fieldSrcObj = JSONObject.parseObject((String)fieldSrcObjStr);
        for (String controlId : controlIds) {
            if (!fieldSrcObj.containsKey((Object)controlId)) continue;
            fieldSrcObj.put(controlId, (Object)enableEnum.ordinal());
        }
        pageCache.put("fieldSwitchCacheKey", fieldSrcObj.toJSONString());
    }

    public static InductionFieldEditSwitchHelper getInstance() {
        return Instance.FIELDENABLEHELPER_INSTANCE;
    }

    private InductionFieldEditSwitchHelper() {
    }

    private static class Instance {
        private static InductionFieldEditSwitchHelper FIELDENABLEHELPER_INSTANCE = new InductionFieldEditSwitchHelper();

        private Instance() {
        }
    }
}

