/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tso.business.domain.AbstractService;
import kd.tsc.tso.business.domain.induction.helper.InductionFormHelper;
import kd.tsc.tso.business.domain.induction.service.InductionPermService;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.induction.InductionServiceHelper;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.collections4.CollectionUtils;

public class InductionFormService
extends AbstractService {
    private InductionFormHelper inductionFormHelper = InductionFormHelper.Singleton.INSTANCE.getInstance();
    private InductionServiceHelper inductionServiceHelper = InductionServiceHelper.Singleton.INSTANCE.getInstance();
    private OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
    private static final Log log = LogFactory.getLog(InductionFormService.class);

    @Override
    protected HRBaseServiceHelper getHelper() {
        return this.inductionFormHelper;
    }

    public DynamicObject selectInduction(QFilter qFilter) {
        return this.queryOne("id,inductionstatus,launchinderrdesc,launchindstatus,breakuptype,launchindtime,modifytime,breakupreason,breakupreasontext,offer,ploymenttime,inductionreasondesc,errorreasontype,atsstatus,atsreasondesc", qFilter.toArray());
    }

    public int countInduction(QFilter[] filters) {
        return this.inductionServiceHelper.count("tso_inductioninfo", filters);
    }

    public Map<String, Integer> getInductionStatisticInfo() {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)4);
        boolean verifyHas = InductionPermService.getInstance().verifyHasPerm("btn_view", "tso_inductioninfo", null, "tsrsc");
        log.info("InductionFormService.getInductionStatisticInfo verifyHas : {}", (Object)verifyHas);
        if (!verifyHas) {
            returnMap.put("PRE_INDUCTION", 0);
            returnMap.put("LAUNCH_ERROR", 0);
            return returnMap;
        }
        int preInductionNum = this.inductionFormHelper.getPreInductionNum();
        int launchErrorNum = this.inductionFormHelper.getLaunchErrorNum();
        returnMap.put("PRE_INDUCTION", preInductionNum);
        returnMap.put("LAUNCH_ERROR", launchErrorNum);
        log.info("InductionFormService.getInductionStatisticInfo returnMap : {}", (Object)returnMap);
        return returnMap;
    }

    public void successLaunchIdc(DynamicObject inductionDyn) {
        inductionDyn.set("inductionstatus", (Object)InductionStatus.INDUCTION_SUCCESS.getCode());
        inductionDyn.set("launchindtime", (Object)new Date());
        inductionDyn.set("modifytime", (Object)new Date());
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (offerObj == null) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
            offerById.set("inductionstatus", (Object)InductionStatus.INDUCTION_SUCCESS.getCode());
            offerById.set("launchindtime", (Object)new Date());
            offerById.set("modifytime", (Object)new Date());
            try (TXHandle tx = TX.required();){
                try {
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                }
                catch (Exception e) {
                    log.error("InductionFormService.successLaunchIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
    }

    public void errorLaunchIdc(DynamicObject inductionDyn, ResponseDTO<OnbrdRespVal> responseDTO) {
        inductionDyn.set("inductionstatus", (Object)InductionStatus.INDUCTION_ERROR.getCode());
        inductionDyn.set("launchinderrdesc", (Object)responseDTO.getMessage());
        inductionDyn.set("inductionreasondesc", (Object)responseDTO.getMessage());
        inductionDyn.set("errorreasontype", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollStatus());
        inductionDyn.set("launchindtime", (Object)new Date());
        inductionDyn.set("modifytime", (Object)new Date());
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (offerObj == null) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
            offerById.set("inductionstatus", (Object)InductionStatus.INDUCTION_ERROR.getCode());
            offerById.set("launchinderrdesc", (Object)responseDTO.getMessage());
            offerById.set("errorreasontype", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollStatus());
            offerById.set("launchindtime", (Object)new Date());
            offerById.set("modifytime", (Object)new Date());
            try (TXHandle tx = TX.required();){
                try {
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                }
                catch (Exception e) {
                    log.error("InductionFormService.errorLaunchIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
    }

    public DynamicObject confirmIdc(DynamicObject inductionDyn, ResponseDTO<OnbrdRespVal> responseDTO) {
        inductionDyn.set("inductionstatus", (Object)InductionStatus.ALR_INDUCTION.getCode());
        inductionDyn.set("ploymenttime", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollDate());
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (offerObj == null) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
            offerById.set("inductionstatus", (Object)InductionStatus.ALR_INDUCTION.getCode());
            offerById.set("modifytime", (Object)new Date());
            QFilter qFilter = new QFilter("offer", "=", (Object)offerById.getLong("id"));
            List offerLetterList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tso_somk_offerletter");
            DynamicObject offerLetter = null;
            if (CollectionUtils.isNotEmpty((Collection)offerLetterList)) {
                offerLetter = (DynamicObject)offerLetterList.get(0);
                offerLetter.set("ploymenttime", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollDate());
            }
            try (TXHandle tx = TX.required();){
                try {
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                    BaseHelper.update((DynamicObject)offerLetter, (String)"tso_somk_offerletter");
                }
                catch (Exception e) {
                    log.error("InductionFormService.confirmIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
        return inductionDyn;
    }

    public DynamicObject stopIdc(DynamicObject inductionDyn, Long breakuptype, Long breakupreason, String breakupreasontext) {
        inductionDyn.set("inductionstatus", (Object)InductionStatus.TERM_INDUCTION.getCode());
        inductionDyn.set("breakuptype", (Object)breakuptype);
        inductionDyn.set("breakupreason", (Object)breakupreason);
        inductionDyn.set("breakupreasontext", (Object)breakupreasontext);
        inductionDyn.set("inductionreasondesc", (Object)breakupreasontext);
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (offerObj == null) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
            offerById.set("inductionstatus", (Object)InductionStatus.TERM_INDUCTION.getCode());
            offerById.set("breakuptype", (Object)breakuptype);
            offerById.set("breakupreason", (Object)breakupreason);
            offerById.set("breakupreasontext", (Object)breakupreasontext);
            try (TXHandle tx = TX.required();){
                try {
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                }
                catch (Exception e) {
                    log.error("InductionFormService.stopIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
        return inductionDyn;
    }

    public DynamicObject posIdc(DynamicObject inductionDyn, ResponseDTO<OnbrdRespVal> responseDTO) {
        if ("F".equals(responseDTO.getOnboardType())) {
            inductionDyn.set("ploymenttime", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollDate());
            inductionDyn.set("inductionstatus", (Object)InductionStatus.ALR_INDUCTION.getCode());
        } else {
            inductionDyn.set("inductionstatus", (Object)InductionStatus.POS_INDUCTION.getCode());
        }
        inductionDyn.set("modifytime", (Object)new Date());
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (Objects.isNull(offerObj)) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
            if ("F".equals(responseDTO.getOnboardType())) {
                offerById.set("inductionstatus", (Object)InductionStatus.ALR_INDUCTION.getCode());
            } else {
                offerById.set("inductionstatus", (Object)InductionStatus.POS_INDUCTION.getCode());
            }
            offerById.set("modifytime", (Object)new Date());
            QFilter qFilter = new QFilter("offer", "=", (Object)offerById.getLong("id"));
            List offerLetterList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tso_somk_offerletter");
            DynamicObject offerLetter = null;
            if (CollectionUtils.isNotEmpty((Collection)offerLetterList)) {
                offerLetter = (DynamicObject)offerLetterList.get(0);
                if ("F".equals(responseDTO.getOnboardType())) {
                    offerLetter.set("ploymenttime", (Object)((OnbrdRespVal)responseDTO.getResult()).getEnrollDate());
                }
            }
            try (TXHandle tx = TX.required();){
                try {
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                    BaseHelper.update((DynamicObject)offerLetter, (String)"tso_somk_offerletter");
                }
                catch (Exception e) {
                    log.error("InductionFormService.posIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
        return inductionDyn;
    }

    public DynamicObject depIdc(DynamicObject inductionDyn) {
        inductionDyn.set("inductionstatus", (Object)InductionStatus.DEP_INDUCTION.getCode());
        inductionDyn.set("modifytime", (Object)new Date());
        DynamicObject offerObj = inductionDyn.getDynamicObject("offer");
        if (Objects.isNull(offerObj)) {
            this.inductionServiceHelper.updateOne(inductionDyn);
        } else {
            try (TXHandle tx = TX.required();){
                DynamicObject offerById = this.offerServiceHelper.getOfferById(offerObj.getLong("id"));
                offerById.set("inductionstatus", (Object)InductionStatus.DEP_INDUCTION.getCode());
                offerById.set("modifytime", (Object)new Date());
                try {
                    long appFileId = offerById.getLong("appfile.id");
                    DynamicObject appFileDyn = AppFileHelper.queryOne((long)appFileId, (String)"filestatus");
                    appFileDyn.set("filestatus", (Object)AppFileStatusEnum.INVALID.getValue());
                    this.inductionServiceHelper.updateOne(inductionDyn);
                    this.offerServiceHelper.updateOne(offerById);
                    AppFileHelper.update((DynamicObject[])new DynamicObject[]{appFileDyn});
                }
                catch (Exception e) {
                    log.error("InductionFormService.depIdc error :", (Throwable)e);
                    tx.markRollback();
                }
            }
        }
        return inductionDyn;
    }

    public void updateAtsStatus(DynamicObject induction, Map<String, Object> resultMap, Boolean isDep) {
        log.info("InductionFormService.updateAtsStatus.resultMap -> {}", (Object)JSONObject.toJSONString(resultMap));
        if (resultMap.containsKey("result")) {
            if (resultMap.get("result") instanceof String) {
                String result = resultMap.get("result").toString().replaceAll("\\\\", "");
                resultMap = (Map)JSONObject.parseObject((String)result, Map.class);
            } else {
                resultMap = (Map)resultMap.get("result");
            }
        }
        if (isDep.booleanValue()) {
            QFilter cFilter = new QFilter("id", "=", (Object)induction.getLong("id")).and("atsstatus", "=", (Object)"0").and("inductionstatus", "=", (Object)InductionStatus.DEP_INDUCTION.getCode());
            int count = this.inductionServiceHelper.count("tso_inductioninfo", new QFilter[]{cFilter});
            if (0 < count) {
                log.info("\u5019\u9009\u4eba\u5df2\u79bb\u804c\uff0cID\uff1a{}", (Object)induction.getString("id"));
                return;
            }
            String code = String.valueOf(resultMap.get("code"));
            if ("0".equals(code)) {
                induction.set("atsstatus", (Object)"0");
            } else {
                induction.set("atsstatus", (Object)"1");
                induction.set("atsreasondesc", resultMap.get("errorMessage"));
            }
        } else {
            Boolean isSuccess = (Boolean)resultMap.get("success");
            if (Objects.isNull(isSuccess)) {
                return;
            }
            if (isSuccess.booleanValue()) {
                induction.set("atsstatus", (Object)"0");
            } else {
                induction.set("atsstatus", (Object)"1");
                induction.set("atsreasondesc", resultMap.get("errorMessage"));
            }
        }
        this.inductionServiceHelper.updateOne(induction);
    }

    public int getCandidateAge(Long appfileId) {
        DynamicObject[] candidateInfos = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateAttachs", (Object[])new Object[]{appfileId, "hcf_canbaseinfo"});
        if (candidateInfos != null && candidateInfos.length > 0) {
            Date birthday = candidateInfos[0].getDate("birthday");
            int candidateAge = ResumeAnalysisHelper.calculateAge((Date)birthday);
            log.info("InductionFormService.getCandidateAge candidateAge : {}", (Object)candidateAge);
            return candidateAge;
        }
        return 0;
    }

    public static enum Singleton {
        INSTANCE;

        private final InductionFormService instance = new InductionFormService();

        public InductionFormService getInstance() {
            return this.instance;
        }
    }
}

