/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.service;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class InductionPermService {
    private static final Log logger = LogFactory.getLog(InductionPermService.class);
    private static final Map<String, String> PERM_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final String KEY_NEW_OFFER = "btn_new_offer";
    public static final String EDIT_PERM = "0AQ3YJ2LET+U";
    public static final String ABANDON_PERM = "0=KX5+R7YTRT";
    public static final String RESEND_PERM = "1IR6ID9X8/GP";
    public static final String SEND_PERM = "1IR6ID9X8/GP";
    public static final String DELAY_SEND_PERM = "2209ZWI4D5RL";
    public static final String VIEW_PERM = "47150e89000000ac";
    public static final String NEW_OFFER_PERM = "1IR6LQ/8AA+B";
    public static final String SAVE_PERM = "0=KX5+QVF5+R";
    public static final String DELETE_PERM = "4715e1f1000000ac";
    public static final String EXPORTLIST_PERM = "4730fc9f000004ae";
    public static final String SUBMIT_PERM = "804f6478000000ac";
    public static final String UNSUBMIT_PERM = "80513207000000ac";
    public static final String CHANGE_VALID_TIME_PERM = "220=3A=3P719";
    public static final String END_INDUCTION = "2NPTLZ+CG1+/";
    public static final String START_INDUCTION = "2NPTJV=VDLVR";
    public static final String GET_OFFER = "2OI4=1O5+Y7U";
    public static final String COPY_PERM = "4730fc9f000020ae";
    public static final String DELAY_REPLY = "2FTUW+B4TJZ2";

    public boolean verifyHasPerm(String operateCode, String entityId, Long useOrgId, String appId) {
        if (useOrgId == null) {
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)appId, (String)entityId, (String)PERM_MAP.get(operateCode));
            logger.info("verifyHasFunctionPerm,entity:{},operateCode:{},userOrgId:{};perm:{}", new Object[]{entityId, operateCode, useOrgId, hasPerm});
            return hasPerm;
        }
        int hasPerm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)useOrgId, (String)appId, (String)entityId, (String)PERM_MAP.get(operateCode));
        logger.info("verifyHasFunctionPerm,entity:{},operateCode:{},userOrgId:{};perm:{}", new Object[]{entityId, operateCode, useOrgId, hasPerm});
        return hasPerm == 1;
    }

    public static InductionPermService getInstance() {
        return Instance.OFFER_PERM_INSTANCE;
    }

    private InductionPermService() {
    }

    static {
        PERM_MAP.put("bar_modify", EDIT_PERM);
        PERM_MAP.put("bar_save", SAVE_PERM);
        PERM_MAP.put("bar_abandon", ABANDON_PERM);
        PERM_MAP.put("bar_resend", "1IR6ID9X8/GP");
        PERM_MAP.put("bar_send", "1IR6ID9X8/GP");
        PERM_MAP.put("bar_delete", DELETE_PERM);
        PERM_MAP.put("btn_view", VIEW_PERM);
        PERM_MAP.put(KEY_NEW_OFFER, NEW_OFFER_PERM);
        PERM_MAP.put("exportlist", EXPORTLIST_PERM);
        PERM_MAP.put("bar_submit", SUBMIT_PERM);
        PERM_MAP.put("bar_unsubmit", UNSUBMIT_PERM);
        PERM_MAP.put("bar_chgvalidtime", CHANGE_VALID_TIME_PERM);
        PERM_MAP.put("bar_delaysend", DELAY_SEND_PERM);
        PERM_MAP.put("bar_copy", COPY_PERM);
        PERM_MAP.put("bar_delayedreply", DELAY_REPLY);
        PERM_MAP.put("btn_startinduction", START_INDUCTION);
        PERM_MAP.put("btn_endinduction", END_INDUCTION);
        PERM_MAP.put("btn_getoffer", GET_OFFER);
    }

    private static class Instance {
        private static InductionPermService OFFER_PERM_INSTANCE = new InductionPermService();

        private Instance() {
        }
    }
}

