/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.service.endIdc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.induction.helper.InductionEditMutexHelper;
import kd.tsc.tso.business.domain.induction.service.endIdc.helper.InductionEndHelper;
import kd.tsc.tso.business.domain.moka.offer.CallbackMkInterfaceService;
import kd.tsc.tso.business.domain.moka.offer.base.helper.MkOfferServiceHelper;
import kd.tsc.tso.business.domain.mq.producer.InductionProducer;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.induction.InductionServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.dto.InductionEndResVo;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.status.OfferInductionStatus;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import kd.tsc.tspr.business.domain.offer.mq.model.StopInductionInfo;

public class InductionEndService {
    private static final Log logger = LogFactory.getLog(InductionEndService.class);
    private InductionEndHelper inductionEndHelper = InductionEndHelper.getInstance();
    private InductionServiceHelper inductionServiceHelper = InductionServiceHelper.Singleton.INSTANCE.getInstance();
    private MkOfferServiceHelper mkOfferServiceHelper = MkOfferServiceHelper.Singleton.INSTANCE.getInstance();
    private final ThreadPool asyncEndInductionPool = ThreadPools.newCachedThreadPool((String)"asyncEndInduction_pool", (int)10, (int)200);

    public boolean isVisible(DynamicObject offerBaseInfo, IFormView offerInfoView) {
        return this.verifyStatus(offerBaseInfo);
    }

    private boolean verifyStatus(DynamicObject offerBaseInfo) {
        String inductionStatus = offerBaseInfo.getString("inductionstatus");
        return InductionStatus.PRE_INDUCTION.getCode().equals(inductionStatus);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.inductionEndHelper.getOfferByIdListForEndIdc(offerIdList);
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList<Long> successIdList = new ArrayList<Long>(offerIdList.size());
        offerInfoList.forEach(offerInfo -> {
            String status = offerInfo.getString("inductionstatus");
            if (!Arrays.asList(InductionStatus.INDUCTION_SUCCESS.getCode(), InductionStatus.INDUCTION_ERROR.getCode()).contains(status)) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_END_ERR_001, InductionOpMultiLangConstants.offerNotInProcessErrEnd());
                return;
            }
            String msg = this.isEdit((DynamicObject)offerInfo);
            if (msg != null) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_END_ERR_002, msg);
                return;
            }
            successIdList.add(offerInfo.getLong("id"));
        });
        result.setPassIds(successIdList);
        result.setResultType(successIdList.size(), offerInfoList.size());
        return result;
    }

    public String isEdit(DynamicObject offerObj) {
        long offerId = Long.parseLong(offerObj.getPkValue().toString());
        String mesg = null;
        DynamicObject[] mutexDts = InductionEditMutexHelper.checkOfferIsEditing(Lists.newArrayList((Object[])new Long[]{offerId}));
        if (mutexDts == null || mutexDts.length == 0) {
            return mesg;
        }
        for (DynamicObject mutexDt : mutexDts) {
            mesg = MessageFormat.format(InductionOpMultiLangConstants.offerIsEditingErrEnd(), mutexDt.getString("user.name"));
        }
        return mesg;
    }

    public Boolean stopInduction(List<Long> offerIds, InductionEndResVo inductionEndResVo) {
        boolean isAllSuccess = true;
        HashMap syncEndInductionFutureMap = Maps.newHashMapWithExpectedSize((int)offerIds.size());
        offerIds.forEach(offerId -> syncEndInductionFutureMap.put(offerId, this.asyncEndInductionPool.submit(() -> this.stopInduction((Long)offerId, inductionEndResVo))));
        try {
            for (Map.Entry entry : syncEndInductionFutureMap.entrySet()) {
                if (((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                logger.info("InductionEndService.stopInduction sync fail offerId: {}", entry.getKey());
                isAllSuccess = false;
                break;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("InductionEndService.stopInduction error :", (Throwable)ex);
            isAllSuccess = false;
        }
        return isAllSuccess;
    }

    public Boolean stopInduction(Long offerId, InductionEndResVo inductionEndResVo) {
        DynamicObject inductionObj = this.inductionEndHelper.getOfferByIdForEndIdc(offerId);
        inductionObj.set("inductionstatus", (Object)OfferInductionStatus.TERM_INDUCTION.getCode());
        inductionObj.set("modifytime", (Object)new Date());
        inductionObj.set("breakupreasontext", (Object)inductionEndResVo.getEndIdcReasonStr());
        inductionObj.set("inductionreasondesc", (Object)inductionEndResVo.getEndIdcReasonStr());
        InductionCommModel inductionCommModel = new InductionCommModel();
        StopInductionInfo stopInductionInfo = new StopInductionInfo();
        stopInductionInfo.setAppfileId(inductionObj.getLong("appfile.id"));
        stopInductionInfo.setEndTypeId(inductionEndResVo.getEndTypeId());
        stopInductionInfo.setEndIdcReasonId(inductionEndResVo.getEndIdcReasonId());
        stopInductionInfo.setEndIdcReasonStr(inductionEndResVo.getEndIdcReasonStr());
        stopInductionInfo.setNumber(inductionObj.getString("number"));
        inductionCommModel.setMessageType(InductionCommModel.MessageType.TERMINATE_INDUCTION.getCode());
        inductionCommModel.setStopInductionInfo(stopInductionInfo);
        long mkOfferId = inductionObj.getLong("offer.id");
        DynamicObject offerDy = null;
        if (mkOfferId != 0L) {
            offerDy = this.mkOfferServiceHelper.queryOne(mkOfferId);
            offerDy.set("inductionstatus", (Object)OfferInductionStatus.TERM_INDUCTION.getCode());
            offerDy.set("modifytime", (Object)new Date());
            offerDy.set("breakupreasontext", (Object)inductionEndResVo.getEndIdcReasonStr());
        }
        try (TXHandle tx = TX.required();){
            try {
                this.inductionServiceHelper.updateOne(inductionObj);
                if (!HRObjectUtils.isEmpty((Object)offerDy)) {
                    this.mkOfferServiceHelper.updateOne(offerDy);
                }
                InductionProducer.sendLaunchOrStopIdcMessage(inductionCommModel);
            }
            catch (Exception e) {
                logger.error("\u3010InductionEndService\u3011\"stopInduction\" error :", (Throwable)e);
                tx.markRollback();
                Boolean bl = Boolean.FALSE;
                if (tx != null) {
                    if (var10_11 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var10_11.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return bl;
            }
        }
        try {
            long appfileId = inductionObj.getLong("appfile.id");
            CallbackMkInterfaceService.doTerminateInduction(appfileId, inductionEndResVo.getEndIdcReasonId());
            return Boolean.TRUE;
        }
        catch (Exception e) {
            logger.error("\u3010InductionEndService\u3011\"AppChannelServiceImpl\" error :", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public static InductionEndService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final InductionEndService INSTANCE = new InductionEndService();

        private Instance() {
        }
    }
}

