/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.service.info.btn;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.tsc.tso.business.domain.induction.service.InductionPermService;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferEditMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InductionEditBaseInfoService {
    public boolean isVisible(DynamicObject offerBaseDt) {
        return (Boolean)this.verifyPerm(offerBaseDt).getLeft() != false && this.verifyAppFileStatus(offerBaseDt) && (Boolean)this.verifyStatus(offerBaseDt).getLeft() != false;
    }

    public Pair<Boolean, String> canExecute(DynamicObject offerBaseInfoDt) {
        Pair<Boolean, String> permPair = this.verifyPerm(offerBaseInfoDt);
        if (!((Boolean)permPair.getLeft()).booleanValue()) {
            return permPair;
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public boolean execute(IFormView formView) {
        this.changePageToEdit(formView);
        return true;
    }

    private void changePageToEdit(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formView.setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
        formView.invokeOperation("refresh");
    }

    private Pair<Boolean, String> verifyPerm(DynamicObject offerBaseInfoDt) {
        long busUnitId = offerBaseInfoDt.getDynamicObject("busunit").getLong("id");
        if (!InductionPermService.getInstance().verifyHasPerm("bar_modify", "tso_inductioninfo", busUnitId, "tsrsc")) {
            return Pair.of((Object)Boolean.FALSE, (Object)InductionOpMultiLangConstants.noPermitEditOffer());
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    private boolean verifyAppFileStatus(DynamicObject offerBaseInfoDt) {
        DynamicObject appFile = offerBaseInfoDt.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    private Pair<Boolean, String> verifyStatus(DynamicObject offerBaseInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerBaseInfo);
        if (offerStatus == OfferStatus.PRE_APPLY) {
            return Pair.of((Object)Boolean.TRUE, (Object)"");
        }
        return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.offerStatusIsNotPreApplyError());
    }

    public static InductionEditBaseInfoService getInstance() {
        return Instance.EDIT_BASE_INFO;
    }

    private InductionEditBaseInfoService() {
    }

    private static class Instance {
        private static final InductionEditBaseInfoService EDIT_BASE_INFO = new InductionEditBaseInfoService();

        private Instance() {
        }
    }
}

