/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.service.startIdc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.induction.helper.InductionEditMutexHelper;
import kd.tsc.tso.business.domain.induction.service.startIdc.InductionReqVerifiService;
import kd.tsc.tso.business.domain.induction.service.startIdc.helper.InductionStartHelper;
import kd.tsc.tso.business.domain.moka.offer.base.helper.MkOfferServiceHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.induction.InductionServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tspr.business.domain.offer.HomOnBrdService;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionOfferDataBo;
import kd.tsc.tspr.business.domain.offer.mq.model.LaunchInductionInfo;
import kd.tsc.tspr.business.domain.util.ValidateUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class InductionStartService {
    private static final Log logger = LogFactory.getLog(InductionStartService.class);
    private InductionStartHelper inductionStartHelper = InductionStartHelper.getInstance();
    private InductionServiceHelper inductionServiceHelper = InductionServiceHelper.Singleton.INSTANCE.getInstance();
    private final HomOnBrdService homOnBrdService = new HomOnBrdService();
    private final ThreadPool asyncCandidatePool = ThreadPools.newCachedThreadPool((String)"asyncCandidateInfo_pool", (int)10, (int)200);
    private final ThreadPool asyncInductionPool = ThreadPools.newCachedThreadPool((String)"asyncInduction_pool", (int)10, (int)200);

    public boolean isVisible(DynamicObject offerBaseInfo, IFormView offerInfoView) {
        return this.verifyStatus(offerBaseInfo);
    }

    private boolean verifyStatus(DynamicObject offerBaseInfo) {
        String inductionStatus = offerBaseInfo.getString("inductionstatus");
        Long statusId = offerBaseInfo.getLong("status.id");
        return InductionStatus.PRE_INDUCTION.getCode().equals(inductionStatus) && !OfferStatus.ALR_DISCARD.getCode().equals(statusId);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList, DynamicObject dataEntity) {
        List<DynamicObject> offerInfoList = HRObjectUtils.isEmpty((Object)dataEntity) ? this.inductionStartHelper.getOfferByIdListForStartIdc(offerIdList) : Collections.singletonList(dataEntity);
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList<Long> successIdList = new ArrayList<Long>(offerIdList.size());
        offerInfoList.forEach(offerInfo -> {
            String msg;
            DynamicObject offerLetterInfo;
            String credentialsTypeNumber;
            String credentialsNumber = offerInfo.getString("credentialsnumber");
            DynamicObject credentialsType = offerInfo.getDynamicObject("credentialstype");
            if (!HRObjectUtils.isEmpty((Object)credentialsType) && HRStringUtils.isNotEmpty((String)credentialsNumber) && !ValidateUtils.validateCardNo((String)(credentialsTypeNumber = credentialsType.getString("number")), (String)credentialsNumber).booleanValue()) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_013, InductionOpMultiLangConstants.credentialsNumberFormatError());
                return;
            }
            if (HRStringUtils.isEmpty((String)offerInfo.getString("candidatephone")) && HRStringUtils.isEmpty((String)offerInfo.getString("candidateemail"))) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_006, InductionOpMultiLangConstants.phoneOrEmailMustInputOne());
                return;
            }
            Date pemploymentTime = offerInfo.getDate("pemploymenttime");
            if (Boolean.TRUE.equals(DateUtils.isBefore((Date)pemploymentTime))) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_016, InductionOpMultiLangConstants.employmentTimeError());
                return;
            }
            DynamicObject offerDy = offerInfo.getDynamicObject("offer");
            if (!HRObjectUtils.isEmpty((Object)offerDy) && !HRObjectUtils.isEmpty((Object)(offerLetterInfo = offerDy.getDynamicObject("offerletter")))) {
                long offerLetterId = offerLetterInfo.getLong("id");
                DynamicObject offerLetterDy = OfferLetterServiceHelper.getInstance().queryOne(offerLetterId);
                long letterDataId = offerLetterDy.getLong("datastatus.id");
                if (letterDataId == OfferLetterDataStatus.INVALID.getCode()) {
                    result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_014, InductionOpMultiLangConstants.offerLetterDataStatusFail());
                    return;
                }
            }
            if ((msg = this.isEdit((DynamicObject)offerInfo)) != null) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_003, msg);
                return;
            }
            if (null != InductionReqVerifiService.verifyIntegrate(offerInfo)) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.INDUCTION_START_ERR_004, InductionReqVerifiService.verifyIntegrate(offerInfo));
                return;
            }
            successIdList.add(offerInfo.getLong("id"));
        });
        result.setPassIds(successIdList);
        result.setResultType(successIdList.size(), offerInfoList.size());
        return result;
    }

    public String isEdit(DynamicObject offerObj) {
        long offerId = Long.parseLong(offerObj.getPkValue().toString());
        String mesg = null;
        DynamicObject[] mutexDts = InductionEditMutexHelper.checkOfferIsEditing(Lists.newArrayList((Object[])new Long[]{offerId}));
        if (mutexDts == null || mutexDts.length == 0) {
            return mesg;
        }
        for (DynamicObject mutexDt : mutexDts) {
            mesg = MessageFormat.format(InductionOpMultiLangConstants.offerIsEditingErrSta(), mutexDt.getString("user.name"));
        }
        return mesg;
    }

    public Boolean launchInduction(List<Long> offerIds) {
        boolean isAllSuccess = true;
        HashMap syncInductionFutureMap = Maps.newHashMapWithExpectedSize((int)offerIds.size());
        offerIds.forEach(offerId -> syncInductionFutureMap.put(offerId, this.asyncInductionPool.submit(() -> this.launchInduction((Long)offerId))));
        try {
            for (Map.Entry entry : syncInductionFutureMap.entrySet()) {
                if (((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                logger.info("InductionStartService.launchInduction sync fail offerId: {}", entry.getKey());
                isAllSuccess = false;
                break;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("InductionStartService.launchInduction error :", (Throwable)ex);
            isAllSuccess = false;
        }
        return isAllSuccess;
    }

    public boolean launchInduction(Long inductionId) {
        InductionCommModel inductionCommModel = new InductionCommModel();
        DynamicObject inductionObj = this.inductionServiceHelper.queryOne(inductionId);
        LaunchInductionInfo launchInductionInfo = new LaunchInductionInfo();
        launchInductionInfo.setAppfileId(Long.valueOf(inductionObj.getLong("appfile.id")));
        launchInductionInfo.setInductionOfferDataBo(this.getInductionOfferDataObj(inductionObj));
        inductionCommModel.setMessageType(InductionCommModel.MessageType.LAUNCH_INDUCTION.getCode());
        inductionCommModel.setLaunchInductionInfo(launchInductionInfo);
        MkOfferServiceHelper mkOfferServiceHelper = MkOfferServiceHelper.Singleton.INSTANCE.getInstance();
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            inductionObj.set("inductionstatus", (Object)InductionStatus.INDUCTION_PROCESS.getCode());
            inductionObj.set("inductionreasondesc", null);
            inductionObj.set("applicant", (Object)TSCRequestContext.getUserId());
            inductionObj.set("applytime", (Object)DateUtils.nowDateTime());
            if (inductionObj.get("pperiodterm") == null) {
                inductionObj.set("pperiodterm", (Object)0);
            }
            this.inductionServiceHelper.updateOne(inductionObj);
            long offerId = inductionObj.getLong("offer.id");
            if (offerId != 0L) {
                DynamicObject offerDy = mkOfferServiceHelper.queryOne(offerId);
                offerDy.set("inductionstatus", (Object)InductionStatus.INDUCTION_PROCESS.getCode());
                offerDy.set("launchinderrdesc", null);
                mkOfferServiceHelper.updateOne(offerDy);
            }
            this.homOnBrdService.createOnBrd(launchInductionInfo);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u3010InductionStartService\u3011\"LaunchInduction\" error :", (Throwable)e);
            tx.markRollback();
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private InductionOfferDataBo getInductionOfferDataObj(DynamicObject inductionObj) {
        DynamicObject dynamicObject;
        InductionOfferDataBo inductionOfferDataBo = new InductionOfferDataBo();
        inductionOfferDataBo.setRecrutyp(inductionObj.getDynamicObject("recrutyp"));
        inductionOfferDataBo.setPeadminorg(inductionObj.getDynamicObject("peadminorg"));
        inductionOfferDataBo.setPlacework(inductionObj.getDynamicObject("placework"));
        inductionOfferDataBo.setAgreePlacework(inductionObj.getDynamicObject("placework"));
        inductionOfferDataBo.setPostassignmode(inductionObj.getString("postassignmode"));
        inductionOfferDataBo.setPeposition(inductionObj.getDynamicObject("peposition"));
        inductionOfferDataBo.setPestdposition(inductionObj.getDynamicObject("pestdposition"));
        inductionOfferDataBo.setPejob(inductionObj.getDynamicObject("pejob"));
        inductionOfferDataBo.setJobgrade(inductionObj.getDynamicObject("jobgrade"));
        inductionOfferDataBo.setJoblevel(inductionObj.getDynamicObject("joblevel"));
        inductionOfferDataBo.setEmprelationtype(inductionObj.getDynamicObject("emprelationtype"));
        inductionOfferDataBo.setPemploymenttime(inductionObj.getDate("pemploymenttime"));
        DynamicObject offer = inductionObj.getDynamicObject("offer");
        if (!HRObjectUtils.isEmpty((Object)offer) && !HRObjectUtils.isEmpty((Object)(dynamicObject = OfferServiceHelper.getInstance().queryOne("number,id", new QFilter[]{new QFilter("id", "=", (Object)offer.getLong("id"))})))) {
            inductionOfferDataBo.setNumber(dynamicObject.getString("number"));
            inductionOfferDataBo.setOfferId(Long.valueOf(dynamicObject.getLong("id")));
        }
        inductionOfferDataBo.setLaborRelTypeCls(Long.valueOf(inductionObj.getLong("laborreltypecls.id")));
        if (inductionObj.getLong("laborreltypecls.id") != TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId().longValue() || inductionObj.getDynamicObject("emprelationtype").getLong("id") != TSOPreDataEnum.LABORREL_TYPE_INTERN.getId().longValue()) {
            inductionOfferDataBo.setIsHavePeriodTerm(inductionObj.getString("ishaveperiodterm"));
            inductionOfferDataBo.setPperiodterm(inductionObj.getInt("pperiodterm"));
            inductionOfferDataBo.setPperiodtermunit(inductionObj.getString("pperiodtermunit"));
        }
        List pkArray = inductionObj.getDynamicObjectCollection("supervisor").stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        logger.info("InductionStartService.getInductionOfferDataObj pkArray : {}", pkArray);
        inductionOfferDataBo.setSupervisorIdList(pkArray);
        return inductionOfferDataBo;
    }

    public boolean synchronizeCandidate(List<Long> inducInfoIds) {
        boolean isAllSuccess = true;
        HashMap syncCandidateFutureMap = Maps.newHashMapWithExpectedSize((int)inducInfoIds.size());
        inducInfoIds.forEach(inducInfoId -> syncCandidateFutureMap.put(inducInfoId, this.asyncCandidatePool.submit(() -> this.sendCandidateInfo((Long)inducInfoId))));
        try {
            for (Map.Entry entry : syncCandidateFutureMap.entrySet()) {
                if (((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                logger.info("InductionStartService.synchronizeCandidate sync fail offerId: {}", entry.getKey());
                isAllSuccess = false;
                break;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("InductionStartService.synchronizeCandidate error :", (Throwable)ex);
            isAllSuccess = false;
        }
        return isAllSuccess;
    }

    private boolean sendCandidateInfo(Long inducInfoId) {
        DynamicObject candidateDy = InductionStartHelper.getInstance().queryOne(inducInfoId);
        if (HRObjectUtils.isEmpty((Object)candidateDy)) {
            return false;
        }
        try {
            HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"updateCancontactInfo", (Object[])new Object[]{candidateDy.getLong("appfile.id"), candidateDy.getString("candidatephone"), candidateDy.getString("candidateemail")});
            HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"updateCancreInfo", (Object[])new Object[]{candidateDy.getLong("appfile.id"), candidateDy.getLong("credentialstype.id"), candidateDy.getString("credentialsnumber")});
            List attachments = AttachmentServiceHelper.getAttachments((String)"tso_inductioninfo", (Object)candidateDy.getLong("id"), (String)"attachmentpanelap");
            logger.info("InductionStartService.sendCandidateInfo attachments : {} pk : {}", (Object)attachments, (Object)candidateDy.getLong("id"));
            HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"updateAttachmentToHcf", (Object[])new Object[]{candidateDy.getLong("appfile.id"), attachments});
            return true;
        }
        catch (Exception e) {
            logger.error("sendCandidateInfo error :", (Throwable)e);
            return false;
        }
    }

    public static InductionStartService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final InductionStartService INSTANCE = new InductionStartService();

        private Instance() {
        }
    }
}

