/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.induction.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;
import kd.tsc.tso.business.domain.induction.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public abstract class AbstractSecondValidator
implements SecondValidatorInterface {
    @Override
    public void doValidator(IFormView formView, BeforeDoOperationEventArgs clickEvent, String opKey) {
        if (StringUtils.isEmpty((String)opKey)) {
            return;
        }
        EntityOperate entityOperate = (EntityOperate)clickEvent.getSource();
        if (!opKey.equals(entityOperate.getOperateKey())) {
            return;
        }
        this.doValidator(formView, clickEvent);
    }

    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult, IFormView formView) {
        List<VerifyOfferFailedInfo> verifyOfferFailedInfos = offerVerifyResult.getFailInfos();
        Map<String, List<VerifyOfferFailedInfo>> groupByInfo = verifyOfferFailedInfos.stream().collect(Collectors.groupingBy(VerifyOfferFailedInfo::getFailedReason));
        if (groupByInfo.size() > 1) {
            this.showBosOperateResultForm(verifyOfferFailedInfos, formView);
        } else {
            VerifyOfferFailedInfo verifyOfferFailedInfo = verifyOfferFailedInfos.get(0);
            formView.showTipNotification(verifyOfferFailedInfo.getFailedMsg());
        }
    }

    protected List<Long> getSelectedOfferIdList(IFormView formView) {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        FormShowParameter formShowParameter = formView.getParentView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter offerParameter = (BillShowParameter)formShowParameter;
            Object pkId = offerParameter.getPkId();
            if (Objects.nonNull(pkId)) {
                offerIds.add(Long.valueOf(pkId.toString()));
            }
        } else if (formShowParameter instanceof ListShowParameter) {
            IListView view = (IListView)formView.getParentView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            selectedRows.forEach(row -> offerIds.add((Long)row.getPrimaryKeyValue()));
        } else {
            Optional.ofNullable(formView.getParentView().getModel().getValue("offerid")).ifPresent(offerId -> offerIds.add(Long.parseLong(offerId.toString())));
        }
        return offerIds;
    }

    protected void showBosOperateResultForm(List<VerifyOfferFailedInfo> verifyOfferFailedInfos, IFormView formView) {
        int allOfferNum = this.getSelectedOfferIdList(formView).size();
        int failOfferNum = verifyOfferFailedInfos.size();
        int succOfferNum = allOfferNum - failOfferNum;
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u6761\u6570\u636e\uff0c\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761\u3002", (String)"OfferAbstractButtonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), allOfferNum, succOfferNum, failOfferNum);
        ArrayList errorMsgs = new ArrayList(verifyOfferFailedInfos.size());
        verifyOfferFailedInfos.parallelStream().forEach(verifyOfferFailedInfo -> errorMsgs.add(verifyOfferFailedInfo.getBillNo() + ":" + verifyOfferFailedInfo.getFailedMsg()));
        FormShowParameter bosOperationResultParam = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, errorMsgs, (boolean)true);
        formView.showForm(bosOperationResultParam);
    }
}

