/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.tso.extpoint.IMkProcessService;
import kd.tsc.tso.business.domain.process.eip.EipProcessInstanceInfo;
import kd.tsc.tso.business.domain.process.eip.EipProcessService;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;

public class CallbackMkInterfaceService {
    private static final Log LOG = LogFactory.getLog(CallbackMkInterfaceService.class);

    public static Map<String, Object> doAlrInduction(Long appfileId, String hiredAt, int probation) {
        ArrayList params = Lists.newArrayListWithExpectedSize((int)8);
        params.add(appfileId);
        params.add(hiredAt);
        params.add(probation);
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute("tsrsc_mk_putAcceptInduction", params);
        return eipProcessInstanceInfo.getOutput();
    }

    public static Map<String, Object> doPosInduction(Long appfileId, int status, String correctedAt) {
        ArrayList params = Lists.newArrayListWithExpectedSize((int)8);
        params.add(appfileId);
        params.add(status);
        params.add(correctedAt);
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute("tsrsc_mk_putPositiveInduction", params);
        return eipProcessInstanceInfo.getOutput();
    }

    public static Map<String, Object> doDepInduction(Long appfileId, String detail, String depTime, Long depReasonId) {
        LOG.info("MkAlrInductionServiceImpl.doDepInduction param appfileId : {} depReasonId : {}", (Object)appfileId, (Object)depReasonId);
        ArrayList params = Lists.newArrayListWithExpectedSize((int)8);
        params.add(appfileId);
        params.add(detail);
        params.add(depTime);
        params.add(depReasonId);
        String processNumber = "tsrsc_mk_putDepartureInduction";
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IMkProcessService.class, (String)"kd.sdk.tsc.tso.extpoint.IMkProcessService#doDepInduction", null);
        List callBackList = proxy.callReplace(service -> {
            if (service != null) {
                String proNum = service.doDepInduction(params);
                return proNum;
            }
            return null;
        });
        processNumber = callBackList != null && callBackList.size() > 0 ? (String)callBackList.get(0) : processNumber;
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute(processNumber, params);
        return eipProcessInstanceInfo.getOutput();
    }

    public static Map<String, Object> doTerminateInduction(Long appfileId, long breakupReasonId) {
        LOG.info("MkAlrInductionServiceImpl.doTerminateInduction param appfileId : {} breakupReasonId : {}", (Object)appfileId, (Object)breakupReasonId);
        ArrayList params = Lists.newArrayListWithExpectedSize((int)4);
        params.add(appfileId);
        params.add(breakupReasonId);
        String processNumber = "tsrsc_mk_putRejectedInduction";
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IMkProcessService.class, (String)"kd.sdk.tsc.tso.extpoint.IMkProcessService#doTerminateInduction", null);
        List callBackList = proxy.callReplace(service -> {
            if (service != null) {
                String proNum = service.doTerminateInduction(params);
                return proNum;
            }
            return null;
        });
        processNumber = callBackList != null && callBackList.size() > 0 ? (String)callBackList.get(0) : processNumber;
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute(processNumber, params);
        return eipProcessInstanceInfo.getOutput();
    }

    public static Map<String, Object> doSendOffer(Long appfileId, long joblevel, String[] emailCC) {
        DynamicObject appfileDy = AppFileDataHelper.queryAppFileById((Object)appfileId);
        String email = "";
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_atsmsgrecord");
            String tpdataId = appfileDy.getString("tpdataid");
            DynamicObject atsMsgRecordDy = serviceHelper.queryOne("id,tpdataid,operatormail", new QFilter("tpdataid", "=", (Object)tpdataId));
            if (HRObjectUtils.isEmpty((Object)atsMsgRecordDy)) {
                return new HashMap<String, Object>();
            }
            String operatormail = atsMsgRecordDy.getString("operatormail");
            if (HRStringUtils.isNotEmpty((String)operatormail)) {
                email = operatormail;
                if (CallbackMkInterfaceService.checkEmailCCIsAllEmpty(emailCC)) {
                    emailCC = new String[]{operatormail};
                }
            }
        }
        if (HRStringUtils.isEmpty((String)email)) {
            return new HashMap<String, Object>();
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)4);
        params.add(appfileId);
        params.add(email);
        params.add(joblevel);
        params.add(emailCC);
        String processNumber = "tsrsc_mk_sendoffer";
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IMkProcessService.class, (String)"kd.sdk.tsc.tso.extpoint.IMkProcessService#doSendOffer", null);
        List callBackList = proxy.callReplace(service -> {
            if (service != null) {
                String proNum = service.doSendOffer(params);
                return proNum;
            }
            return null;
        });
        processNumber = callBackList != null && callBackList.size() > 0 ? (String)callBackList.get(0) : processNumber;
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute(processNumber, params);
        return eipProcessInstanceInfo.getOutput();
    }

    private static boolean checkEmailCCIsAllEmpty(String[] emailCC) {
        if (HRArrayUtils.isEmpty((Object[])emailCC)) {
            return true;
        }
        boolean result = true;
        for (String email : emailCC) {
            if (!HRStringUtils.isNotEmpty((String)email)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Map<String, Object> doSendOffer(Long appfileId, long joblevel) {
        Map userInfoMap = UserServiceHelper.getUserInfoByID((long)RequestContext.get().getCurrUserId());
        String email = (String)userInfoMap.get("email");
        if (StringUtils.isEmpty((String)email)) {
            return new HashMap<String, Object>();
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)4);
        params.add(appfileId);
        params.add(email);
        params.add(joblevel);
        String processNumber = "tsrsc_mk_sendoffer";
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IMkProcessService.class, (String)"kd.sdk.tsc.tso.extpoint.IMkProcessService#doSendOffer", null);
        List callBackList = proxy.callReplace(service -> {
            if (service != null) {
                String proNum = service.doSendOffer(params);
                return proNum;
            }
            return null;
        });
        processNumber = callBackList != null && callBackList.size() > 0 ? (String)callBackList.get(0) : processNumber;
        EipProcessInstanceInfo eipProcessInstanceInfo = EipProcessService.synExecute(processNumber, params);
        return eipProcessInstanceInfo.getOutput();
    }
}

