/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.create;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.enums.offer.OfferPPeriodTermEnum;
import kd.tsc.tso.common.util.OfferFieldEditSwitch;
import kd.tsc.tspr.business.domain.appfile.service.AppFileService;
import kd.tsc.tsrbd.common.constants.deserializer.DefaultDeserializer;
import kd.tsc.tsrbd.common.constants.deserializer.impl.BaseDeserializer;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractCreateOfferCommonService {
    private static final Log LOG = LogFactory.getLog(AbstractCreateOfferCommonService.class);
    private static final String REGX = "[\\w|\\W]+\":(\"[(\\w|\\W)]+\",|[(\\w|\\W)]+,)";
    private static final Pattern PATTERN = Pattern.compile("[\\w|\\W]+\":(\"[(\\w|\\W)]+\",|[(\\w|\\W)]+,)");
    public static final String OFFERID = "offerId";
    private final AppFileService appFileService = AppFileService.getInstance();

    public static void removeParam(Map<String, Object> requestParam, String ... keys) {
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            Optional.of(requestParam.containsKey(key)).ifPresent(bool -> requestParam.remove(key));
        }
    }

    public void setValue(Map<String, Object> param, DynamicObject dynObj, String elementKey, String suffix) {
        DataEntityPropertyCollection properties = dynObj.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!property.getName().equals(elementKey) || !param.containsKey(elementKey)) continue;
            String className = property.getPropertyType().getSimpleName();
            BaseDeserializer deserializer = DefaultDeserializer.getDeserializer((String)className);
            deserializer.parserValue(dynObj, elementKey, param.get(elementKey), new String[]{suffix});
            AbstractCreateOfferCommonService.removeParam(param, elementKey);
        }
    }

    public void setValues(Map<String, Object> param, DynamicObject dynObj, String ... elementKeys) {
        if (elementKeys == null) {
            return;
        }
        DataEntityPropertyCollection properties = dynObj.getDataEntityType().getProperties();
        for (String elementKey : elementKeys) {
            Optional.ofNullable(properties.get((Object)elementKey)).ifPresent(element -> {
                if (param.containsKey(elementKey)) {
                    String className = element.getPropertyType().getSimpleName();
                    BaseDeserializer deserializer = DefaultDeserializer.getDeserializer((String)className);
                    deserializer.parserValue(dynObj, elementKey, param.get(elementKey), null);
                }
            });
            AbstractCreateOfferCommonService.removeParam(param, elementKey);
        }
    }

    public DynamicObject initBaseInfo(Map<String, Object> param, OfferFieldEditSwitch fieldEditSetting, DynamicObject offerObj) {
        if (offerObj == null) {
            offerObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase");
            CodeRuleUtils.generateOneCodeRule((String)"number", (String)"tso_somk_offerbase", (DynamicObject)offerObj);
            offerObj.set("currentregpaycu", (Object)1);
            String salaryType = OfferParamConfigService.getInstance().getSalaryDetType();
            offerObj.set("salarytype", (Object)salaryType);
            offerObj.set("salarystatus", (Object)"A");
            offerObj.set("pperiodtermunit", (Object)OfferPPeriodTermEnum.MONTH.getCode());
            this.initRegsaObject(offerObj);
            this.initWelfareObject(offerObj);
            this.initPrpesaObject(offerObj);
            this.initOfferIncentInfo(offerObj);
        }
        this.setValues(param, offerObj, "busunit", "recrutyp", "currentsalary", "expectedsalary", "regbwages");
        this.setValue(param, offerObj, "name", OfferMultilingualConstants.getOfferNameSuffix());
        if (param.get("pemploymenttime") != null) {
            offerObj.set("pemploymenttime", null);
        }
        return offerObj;
    }

    public void initRegsaObject(DynamicObject offerDynamic) {
        offerDynamic.set("regpaycu", (Object)1);
    }

    public void initWelfareObject(DynamicObject offerDynamic) {
        offerDynamic.set("welpaycu", (Object)1);
        offerDynamic.set("trafaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("tietaryaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("municataowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("rentalaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("housaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
    }

    public void initPrpesaObject(DynamicObject offerDynamic) {
        offerDynamic.set("prpepaycu", (Object)1);
    }

    private void initOfferIncentInfo(DynamicObject offerDynamic) {
        long currency = 1L;
        offerDynamic.set("rsunit", (Object)OfferMultilingualConstants.getSharesUnit());
        offerDynamic.set("rsyearcu", (Object)currency);
        offerDynamic.set("optionunit", (Object)OfferMultilingualConstants.getSharesUnit());
        offerDynamic.set("optioncu", (Object)currency);
        offerDynamic.set("rsnum", (Object)0);
        offerDynamic.set("rsyearvalue", (Object)0);
        offerDynamic.set("optionnum", (Object)0);
        offerDynamic.set("optionyearvalue", (Object)0);
    }

    public static void initAdminOrgInfo(DynamicObject adminOrgObj, DynamicObject offerObj) {
        offerObj.set("peadminorg", (Object)adminOrgObj);
        offerObj.set("supervisor", null);
        DynamicObject peCompany = adminOrgObj.getDynamicObject("company");
        offerObj.set("pecompany", (Object)peCompany);
    }

    public static void initJobInfo(DynamicObject offerObj, OfferFieldEditSwitch fieldEditSetting) {
        Object jobId = offerObj.get("pejob");
        OfferFieldEnableEnum enableEnum = jobId == null ? OfferFieldEnableEnum.NOT_ENABLE : OfferFieldEnableEnum.ENABLE;
        fieldEditSetting.addFieldEditSettings(enableEnum, new String[]{"jobgrade", "joblevel"});
    }

    public static void initJobScmInfo(DynamicObject offerObj, OfferFieldEditSwitch fieldEditSetting) {
        Object jobScmId = offerObj.get("jobscm");
        AbstractCreateOfferCommonService.initJobInfo(offerObj, fieldEditSetting);
        OfferFieldEnableEnum enableEnum = Objects.isNull(jobScmId) ? OfferFieldEnableEnum.NOT_ENABLE : OfferFieldEnableEnum.ENABLE;
        fieldEditSetting.addFieldEditSetting("pejob", enableEnum);
    }

    public static void initSurplusParam(Map<String, Object> param, DynamicObject offerObj) {
        if (param.isEmpty()) {
            return;
        }
        offerObj.set("tpsysfield", (Object)AbstractCreateOfferCommonService.getSurplusParam(param));
    }

    public static String getSurplusParam(Map<String, Object> param) {
        if (param.isEmpty()) {
            return "{}";
        }
        String fieldJsonStr = JSON.toJSONString(param);
        if (fieldJsonStr.length() > 2000) {
            LOG.info("AbstractCreateOfferCommonService.getTpFieldInfo exceeding length [0,2000] value : {}", (Object)"");
            String substring = fieldJsonStr.substring(1, 1998) + ",";
            Matcher matcher = PATTERN.matcher(substring);
            StringBuilder sBuilder = new StringBuilder();
            String returnStr = "";
            while (matcher.find()) {
                sBuilder.append(matcher.group());
            }
            if (sBuilder.length() > 0) {
                returnStr = "{" + sBuilder.substring(0, sBuilder.length() - 1) + "}";
            }
            LOG.info("AbstractCreateOfferCommonService.getTpFieldInfo exceeding length [0,2000] substring value : {}", (Object)returnStr);
            return returnStr.length() > 0 ? returnStr : "{}";
        }
        return fieldJsonStr;
    }

    public void initUserInfo(DynamicObject offerObj, OfferFieldEditSwitch fieldEditSetting, Object appId) {
        Map resumeObjMap = this.appFileService.getResumeInfoByAppFileId(Long.valueOf(Long.parseLong(appId.toString())));
        DynamicObject resumeObj = (DynamicObject)resumeObjMap.get("tstpm_rsm");
        DynamicObject eduObj = (DynamicObject)resumeObjMap.get("tstpm_rsmeduexp");
        if (resumeObj != null) {
            offerObj.set("candidatename", (Object)resumeObj.getString("fullname"));
            offerObj.set("candidategender", (Object)resumeObj.getLong("gender.id"));
            offerObj.set("candidateage", (Object)resumeObj.getInt("age"));
            offerObj.set("candidatenation", (Object)resumeObj.getLong("natreg.id"));
            offerObj.set("candidateworkage", resumeObj.get("workingyears"));
            offerObj.set("highesteducation", (Object)resumeObj.getLong("highesteducation.id"));
            offerObj.set("schoolname", (Object)resumeObj.getLong("highesteduschool.id"));
            offerObj.set("specialtycategory", (Object)resumeObj.getString("highestspecialty"));
            offerObj.set("candidatephone", (Object)resumeObj.getString("phone"));
            offerObj.set("candidateemail", (Object)resumeObj.getString("email"));
        }
        if (eduObj != null) {
            String schoolName = "";
            DynamicObject schoolNameObj = eduObj.getDynamicObject("schoolname");
            if (ObjectUtils.isNotEmpty((Object)schoolNameObj)) {
                long schoolNameId = schoolNameObj.getLong("id");
                schoolName = 1386848073895945216L == schoolNameId ? eduObj.getString("othschname") : schoolNameObj.getString("name");
                offerObj.set("schoolnametext", (Object)schoolName);
            }
        }
    }
}

