/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.create;

import com.alibaba.fastjson.JSON;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.create.AbstractCreateOfferCommonService;
import kd.tsc.tso.business.domain.moka.offer.create.postassignmode.impl.BaseHoldMode;
import kd.tsc.tso.business.domain.moka.offer.create.postassignmode.impl.DefaultHoldMode;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferFieldEditSwitch;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.constants.deserializer.DefaultDeserializer;
import kd.tsc.tsrbd.common.constants.deserializer.impl.BaseDeserializer;
import kd.tsc.tsrbd.common.enums.ThirdPartSystemEnum;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public final class CreateMkOfferServiceImpl
extends AbstractCreateOfferCommonService {
    private static final Log LOG = LogFactory.getLog(CreateMkOfferServiceImpl.class);
    private final OfferServiceHelper offerService = OfferServiceHelper.getInstance();

    public Object create(Map<String, Object> param) {
        LOG.info("CreateMkOfferServiceImpl.create.param: {}", param);
        Object appfileId = param.get("appfileId");
        if (this.validateEffectiveOffer(appfileId)) {
            LOG.info("CreateMkOfferServiceImpl.create.stop: the candidate has a valid offer and entry documents.");
            return ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"CreateMkOfferServiceImpl_0", (String)"tsc-tso-business", (Object[])new Object[0]);
        }
        Object offerId = param.get("offerId");
        DynamicObject offerObj = null;
        if (offerId != null) {
            offerObj = this.offerService.loadSingle(offerId);
            this.removeNullParam(param, offerObj);
        }
        OfferFieldEditSwitch fieldEditSetting = OfferFieldEditSwitch.init();
        offerObj = this.initOfferObj(param, fieldEditSetting, offerObj);
        CreateMkOfferServiceImpl.removeParam(param, "positionId", "appfileId");
        CreateMkOfferServiceImpl.initSurplusParam(param, offerObj);
        DynamicObject fieldEditObj = this.initDynamicFieldEdit(param, fieldEditSetting);
        return this.endTransaction(offerObj, fieldEditObj, appfileId);
    }

    private boolean validateEffectiveOffer(Object appfileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne(appfileId);
        long offerStatusId = appfileDy.getLong("offer.status.id");
        if (offerStatusId != 0L && offerStatusId != 1010040L && offerStatusId != 1010050L) {
            return true;
        }
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return !HRStringUtils.isEmpty((String)inductionStatus);
    }

    private void removeNullParam(Map<String, Object> param, DynamicObject offerObj) {
        LOG.info("CreateMkOfferServiceImpl.removeNullParam before param {}", param);
        if (param.isEmpty() || offerObj == null) {
            return;
        }
        DataEntityPropertyCollection properties = offerObj.getDataEntityType().getProperties();
        Iterator<Map.Entry<String, Object>> iterator = param.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)entry.getKey());
            Optional.ofNullable(iDataEntityProperty).ifPresent(entityProperty -> {
                Object targetObj = offerObj.get((String)entry.getKey());
                if (targetObj != null && (entry.getValue() == null || "0".equals(entry.getValue().toString()))) {
                    iterator.remove();
                }
            });
        }
        LOG.info("CreateMkOfferServiceImpl.removeNullParam after param {}", param);
    }

    private Object endTransaction(DynamicObject offerObj, DynamicObject fieldEditObj, Object appfileId) {
        try (TXHandle tx = TX.required();){
            try {
                this.offerService.saveOne(offerObj);
                Object offerId = offerObj.getPkValue();
                fieldEditObj.set("offer", offerId);
                OfferFieldEditSwitchHelper.HELPER.saveOne(fieldEditObj);
                this.updateAppFile(offerObj, appfileId);
            }
            catch (Exception e) {
                LOG.error("CreateMkOfferServiceImpl.endCreate error :", (Throwable)e);
                tx.markRollback();
                String string = "create offer error";
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return string;
            }
        }
        return offerObj.getPkValue();
    }

    private void updateAppFile(DynamicObject offerObj, Object appfileId) {
        LOG.info("CreateMkOfferServiceImpl.updateAppFile.appfileId:{}", appfileId);
        if (appfileId == null) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne(appfileId);
        LOG.info("CreateMkOfferServiceImpl.updateAppFile.appfileDy:{}", (Object)appfileDy);
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            appfileDy.set("offer_id", (Object)offerObj.getLong("id"));
            appfileDy.set("offerletter_id", (Object)0L);
            serviceHelper.updateOne(appfileDy);
        }
    }

    private DynamicObject initDynamicFieldEdit(Map<String, Object> param, OfferFieldEditSwitch fieldEditSetting) {
        DynamicObject fieldEditObj;
        Object offerId = param.get("offerId");
        if (offerId != null) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tso_offerfieswit");
            QFilter qFilter = new QFilter("offer", "=", (Object)Long.parseLong(offerId.toString()));
            fieldEditObj = helper.loadDynamicObject(qFilter.toArray());
        } else {
            fieldEditObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_offerfieswit");
            fieldEditObj.set("pagekey", (Object)"tso_somk_offerbase");
            fieldEditObj.set("displaycontrol", JSON.toJSON((Object)fieldEditSetting.getFieldEditSetting()));
        }
        return fieldEditObj;
    }

    private DynamicObject initOfferObj(Map<String, Object> param, OfferFieldEditSwitch fieldEditSetting, DynamicObject offerObj) {
        offerObj = this.initBaseInfo(param, fieldEditSetting, offerObj);
        this.initUserInfo(offerObj, fieldEditSetting, param.get("appfileId"));
        this.setDefaultInitStatus(param, offerObj);
        this.initJobInfo(param, offerObj, fieldEditSetting);
        this.initParamToObj(offerObj, param);
        return offerObj;
    }

    private void initParamToObj(DynamicObject offerObj, Map<String, Object> param) {
        if (param.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection properties = offerObj.getDataEntityType().getProperties();
        Iterator<Map.Entry<String, Object>> iterator = param.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)entry.getKey());
            Optional.ofNullable(iDataEntityProperty).ifPresent(entityProperty -> {
                String className = entityProperty.getPropertyType().getSimpleName();
                BaseDeserializer deserializer = DefaultDeserializer.getDeserializer((String)className);
                deserializer.parserValue(offerObj, (String)entry.getKey(), entry.getValue(), null);
                iterator.remove();
            });
        }
    }

    private void initJobInfo(Map<String, Object> param, DynamicObject offerObj, OfferFieldEditSwitch fieldEditSetting) {
        if (param.get("laborreltypecls") == null && offerObj.get("laborreltypecls") == null) {
            fieldEditSetting.addFieldEditSetting("flex_haveperiodterm", OfferFieldEnableEnum.NOT_ENABLE);
        }
        if (StringUtils.isNotEmpty((String)offerObj.getString("postassignmode"))) {
            AbstractCreateOfferCommonService.removeParam(param, "peposition", "postassignmode");
            return;
        }
        Object postassignMode = param.get("postassignmode");
        if (postassignMode == null) {
            offerObj.set("postassignmode", (Object)"1");
        } else {
            if (StringUtils.isEmpty((String)offerObj.getString("postassignmode"))) {
                offerObj.set("postassignmode", param.get("postassignmode"));
            }
            this.initPostassignInfo(param, offerObj, fieldEditSetting);
        }
    }

    private void initPostassignInfo(Map<String, Object> param, DynamicObject offerObj, OfferFieldEditSwitch fieldEditSetting) {
        String postassignMode = offerObj.getString("postassignmode");
        BaseHoldMode holdMode = DefaultHoldMode.getHoldMode(postassignMode);
        holdMode.setPostassignInfo(param, offerObj, fieldEditSetting);
    }

    private void setDefaultInitStatus(Map<String, Object> param, DynamicObject offerObj) {
        offerObj.set("appfile", param.get("appfileId"));
        if (param.get("positionId") != null && !param.get("positionId").equals("0")) {
            offerObj.set("recruposi", param.get("positionId"));
        }
        offerObj.set("inductionstatus", (Object)InductionStatus.DEFAULT.getCode());
        offerObj.set("status", (Object)OfferStatus.PRE_APPLY.getCode());
        offerObj.set("isdelete", (Object)DeleteEnum.NO_DELETE.getCode());
        offerObj.set("tpsys", (Object)ThirdPartSystemEnum.MK.getTpSys());
        OfferUtils.updateOperateInfo((DynamicObject)offerObj);
        String primaryIndex = OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)offerObj, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT);
        offerObj.set("pindexes", (Object)primaryIndex);
    }
}

