/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.induction;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.attachment.AttachmentService;
import kd.tsc.tso.business.domain.induction.helper.InductionFormHelper;
import kd.tsc.tso.business.domain.moka.offer.base.helper.MkOfferServiceHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.BusinessEventHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferStartInductionMultiLangConstants;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.InductionFieldEditSwitch;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.hcf.SyncHcfHelper;
import kd.tsc.tspr.business.domain.offer.HomOnBrdService;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionOfferDataBo;
import kd.tsc.tspr.business.domain.offer.mq.model.LaunchInductionInfo;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;

public class MkOfferStartInductionService {
    private static final Log LOG = LogFactory.getLog(MkOfferStartInductionService.class);
    private InductionFormHelper inductionFormHelper = InductionFormHelper.Singleton.INSTANCE.getInstance();
    private MkOfferServiceHelper mkOfferServiceHelper = MkOfferServiceHelper.Singleton.INSTANCE.getInstance();
    private final AttachmentService attachmentService = AttachmentService.Singleton.INSTANCE.getInstance();
    private BusinessEventHelper businessEventHelper = BusinessEventHelper.getInstance();
    private final HomOnBrdService homOnBrdService = new HomOnBrdService();

    public boolean isVisible(DynamicObject offerBaseInfo, IFormView offerInfoView) {
        return this.verifyPerm(offerBaseInfo, offerInfoView) && this.verifyStatus(offerBaseInfo);
    }

    private boolean verifyPerm(DynamicObject offerObj, IFormView view) {
        long busUnitId = offerObj.getDynamicObject("busunit").getLong("id");
        return OfferPermService.verifyHasPerm("btn_startinduction", "tso_somk_offerbase", busUnitId, view.getFormShowParameter().getAppId());
    }

    private boolean verifyStatus(DynamicObject offerObj) {
        String inductionStatus = offerObj.getString("inductionstatus");
        return InductionStatus.PRE_INDUCTION.getCode().equals(inductionStatus);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        QFilter offerQFilter = new QFilter("id", "in", offerIdList);
        DynamicObject[] offerInfoArr = this.mkOfferServiceHelper.loadDynamicObjectArray(offerQFilter.toArray());
        OfferVerifyResult verifyResult = new OfferVerifyResult();
        ArrayList<Long> successIdList = new ArrayList<Long>(offerIdList.size());
        for (DynamicObject offerInfo : offerInfoArr) {
            String editMsg = this.checkIsEdit(offerInfo);
            if (editMsg != null) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_003, editMsg);
                continue;
            }
            long letterReplaceStatusId = offerInfo.getLong("offerletter.replystatus.id");
            if (letterReplaceStatusId != OfferLetterReplyStatus.ALR_ACCEPT.getCode()) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_012, InductionOpMultiLangConstants.canInductionForEntryError());
                continue;
            }
            long letterStatusId = offerInfo.getLong("offerletter.letterstatus.id");
            if (letterStatusId == OfferLetterStatus.ALR_DISCARD.getCode()) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_009, InductionOpMultiLangConstants.notInductionForAbandonOfferError());
                continue;
            }
            if (!offerInfo.getString("inductionstatus").equals(InductionStatus.PRE_INDUCTION.getCode()) && !offerInfo.getString("inductionstatus").equals(InductionStatus.INDUCTION_ERROR.getCode())) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_010, InductionOpMultiLangConstants.preCanInductionError());
                continue;
            }
            if (offerInfo.getString("inductionstatus").equals(InductionStatus.INDUCTION_ERROR.getCode()) && "1".equals(offerInfo.getString("errorreasontype"))) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_011, InductionOpMultiLangConstants.normalFormatCanInductionError());
                continue;
            }
            long letterDataId = offerInfo.getLong("offerletter.datastatus.id");
            if (letterDataId == OfferLetterDataStatus.INVALID.getCode()) {
                verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_008, OfferMultilingualConstants.startInductionError());
                continue;
            }
            DynamicObject appFile = offerInfo.getDynamicObject("appfile");
            boolean isExistCandidate = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"isExistCandidateByAppFileId", (Object[])new Object[]{appFile.getLong("id")});
            if (!isExistCandidate) {
                SyncHcfHelper.updateArfToCandidate((Long)appFile.getLong("id"), (Boolean)true);
                isExistCandidate = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"isExistCandidateByAppFileId", (Object[])new Object[]{appFile.getLong("id")});
                if (!isExistCandidate) {
                    verifyResult.recordFailInfoForBase(offerInfo, OfferErrorEnum.INDUCTION_START_ERR_015, InductionOpMultiLangConstants.noCandidateExist());
                    continue;
                }
            }
            successIdList.add(offerInfo.getLong("id"));
        }
        verifyResult.setPassIds(successIdList);
        verifyResult.setResultType(successIdList.size(), offerInfoArr.length);
        return verifyResult;
    }

    public String checkIsEdit(DynamicObject offerObj) {
        long offerId = offerObj.getLong("id");
        DynamicObject[] mutexDts = TscMutexHelper.checkHasMutex((String)"tso_somk_offerbase", Collections.singletonList(offerId), (String)"edit");
        if (mutexDts == null || mutexDts.length == 0) {
            return null;
        }
        return MessageFormat.format(InductionOpMultiLangConstants.offerIsEditingErrSta(), mutexDts[0].getString("user.name"));
    }

    private InductionOfferDataBo getInductionOfferDataObj(DynamicObject offerObj) {
        InductionOfferDataBo inductionOfferDataBo = new InductionOfferDataBo();
        inductionOfferDataBo.setRecrutyp(offerObj.getDynamicObject("recrutyp"));
        inductionOfferDataBo.setPeadminorg(offerObj.getDynamicObject("peadminorg"));
        inductionOfferDataBo.setPlacework(offerObj.getDynamicObject("placework"));
        inductionOfferDataBo.setAgreePlacework(offerObj.getDynamicObject("placework"));
        inductionOfferDataBo.setPostassignmode(offerObj.getString("postassignmode"));
        inductionOfferDataBo.setPeposition(offerObj.getDynamicObject("peposition"));
        inductionOfferDataBo.setPestdposition(offerObj.getDynamicObject("pestdposition"));
        inductionOfferDataBo.setPejob(offerObj.getDynamicObject("pejob"));
        inductionOfferDataBo.setJobgrade(offerObj.getDynamicObject("jobgrade"));
        inductionOfferDataBo.setJoblevel(offerObj.getDynamicObject("joblevel"));
        inductionOfferDataBo.setEmprelationtype(offerObj.getDynamicObject("emprelationtype"));
        inductionOfferDataBo.setPemploymenttime(offerObj.getDate("pemploymenttime"));
        inductionOfferDataBo.setNumber(offerObj.getString("number"));
        inductionOfferDataBo.setOfferId(Long.valueOf(offerObj.getLong("id")));
        inductionOfferDataBo.setLaborRelTypeCls(Long.valueOf(offerObj.getLong("laborreltypecls.id")));
        if (offerObj.getLong("laborreltypecls.id") != TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId().longValue() || offerObj.getDynamicObject("emprelationtype").getLong("id") != TSOPreDataEnum.LABORREL_TYPE_INTERN.getId().longValue()) {
            inductionOfferDataBo.setIsHavePeriodTerm(offerObj.getString("ishaveperiodterm"));
            inductionOfferDataBo.setPperiodterm(offerObj.getInt("pperiodterm"));
            inductionOfferDataBo.setPperiodtermunit(offerObj.getString("pperiodtermunit"));
        }
        List pkArray = offerObj.getDynamicObjectCollection("supervisor").stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        LOG.info("MkOfferStartInductionService.getInductionOfferDataObj pkArray : {}", pkArray);
        inductionOfferDataBo.setSupervisorIdList(pkArray);
        return inductionOfferDataBo;
    }

    public void endStartInduction(OfferVerifyResult offerVerifyResult) {
        List<Long> passIds = offerVerifyResult.getPassIds();
        QFilter offerQFilter = new QFilter("id", "in", passIds).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject[] offerObjs = this.mkOfferServiceHelper.loadDynamicObjectArray(offerQFilter.toArray());
        QFilter inductionQFilter = new QFilter("offer", "in", passIds).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject[] inductionObjs = this.inductionFormHelper.loadDynamicObjectArray(inductionQFilter.toArray());
        HashMap inductionMap = Maps.newHashMapWithExpectedSize((int)inductionObjs.length);
        for (DynamicObject inductionObj : inductionObjs) {
            long offerId = inductionObj.getLong("offer.id");
            inductionMap.put(offerId, inductionObj);
        }
        for (DynamicObject offerObj : offerObjs) {
            this.pushInductionMsg(offerVerifyResult, inductionMap, offerObj);
        }
    }

    private void pushInductionMsg(OfferVerifyResult offerVerifyResult, Map<Long, DynamicObject> inductionMap, DynamicObject offerObj) {
        DynamicObject inductionObj = this.updateDynamicObj(inductionMap, offerObj);
        InductionCommModel inductionCommModel = this.getInductionCommModel(offerObj);
        boolean isNewInduction = false;
        InductionFieldEditSwitch fieldEditSetting = InductionFieldEditSwitch.init();
        DynamicObject fieldEditObj = null;
        if (inductionObj == null) {
            inductionObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_inductioninfo");
            HRDynamicObjectUtils.copy((DynamicObject)offerObj, (DynamicObject)inductionObj);
            CodeRuleUtils.generateOneCodeRule((String)"number", (String)"tso_inductioninfo", (DynamicObject)inductionObj);
            this.setHcfUserInfoAndAttachment(inductionObj);
            OfferUtils.updateOperateInfo((DynamicObject)inductionObj);
            inductionObj.set("offer", offerObj.getPkValue());
            isNewInduction = true;
            if (inductionObj.get("recruscene") != null) {
                fieldEditSetting.addFieldEditSetting("recruscene", OfferFieldEnableEnum.NOT_ENABLE);
            }
            fieldEditObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_offerfieswit");
            fieldEditObj.set("pagekey", (Object)"tso_inductioninfo");
            fieldEditObj.set("displaycontrol", JSON.toJSON((Object)fieldEditSetting.getFieldEditSetting()));
        }
        inductionObj.set("creator", (Object)TSCRequestContext.getUserId());
        boolean hasBusinessEvenObj = this.businessEventHelper.isExists(offerObj.getLong("appfile.id"));
        DynamicObject businessEvenObj = null;
        if (!hasBusinessEvenObj) {
            businessEvenObj = this.setBusinessEventObj(offerObj);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!hasBusinessEvenObj) {
                    this.businessEventHelper.save(new DynamicObject[]{businessEvenObj});
                }
                this.mkOfferServiceHelper.updateOne(offerObj);
                this.inductionFormHelper.updateOne(inductionObj);
                if (isNewInduction) {
                    Object inductionId = inductionObj.getPkValue();
                    fieldEditObj.set("offer", inductionId);
                    OfferFieldEditSwitchHelper.HELPER.saveOne(fieldEditObj);
                }
                this.homOnBrdService.createOnBrd(inductionCommModel.getLaunchInductionInfo());
            }
            catch (Exception ex) {
                LOG.error("MkOfferStartInductionService.endStartInduction error :", (Throwable)ex);
                offerVerifyResult.recordFailInfoForBase(offerObj, OfferErrorEnum.INDUCTION_START_ERR_007, OfferStartInductionMultiLangConstants.sendInductionError());
                tx.markRollback();
            }
        }
        if (isNewInduction && !HRObjectUtils.isEmpty((Object)inductionObj.getDynamicObject("appfile"))) {
            this.setAttachmentInfo(inductionObj, inductionObj.getLong("appfile.id"));
        }
    }

    private DynamicObject setBusinessEventObj(DynamicObject offerObj) {
        DynamicObject businessEvenObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_businessevent");
        businessEvenObj.set("id", (Object)offerObj.getLong("appfile.id"));
        businessEvenObj.set("number", (Object)offerObj.getLong("appfile.id"));
        businessEvenObj.set("name", (Object)"start induction");
        businessEvenObj.set("appid", (Object)"tsrsc");
        businessEvenObj.set("bustype", (Object)"tsrsc");
        businessEvenObj.set("servicename", (Object)"kd.tsc.tso.business.domain.moka.offer.induction.MkOfferInductionService");
        businessEvenObj.set("method", (Object)"inductionCallback");
        businessEvenObj.set("busid", (Object)offerObj.getLong("appfile.id"));
        businessEvenObj.set("servicetype", (Object)"1");
        businessEvenObj.set("createtime", (Object)DateUtils.nowDateTime());
        businessEvenObj.set("modifytime", (Object)DateUtils.nowDateTime());
        return businessEvenObj;
    }

    public void setHcfUserInfoAndAttachment(DynamicObject inductionObj) {
        long appfileId = inductionObj.getLong("appfile.id");
        this.setCandidateInfo(inductionObj, appfileId);
        this.setCandidateContactInfo(inductionObj, appfileId);
        this.setCancresInfo(inductionObj, appfileId);
        this.setCaneduexpsInfo(inductionObj, appfileId);
    }

    private void setAttachmentInfo(DynamicObject inductionObj, long appfileId) {
        List attachments = (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getHcfAttachs", (Object[])new Object[]{appfileId});
        LOG.info("MkOfferStartInductionService.setAttachmentInfo getHcfAttachs : {}", (Object)attachments);
        if (attachments == null || attachments.size() == 0) {
            return;
        }
        try {
            this.attachmentService.saveAttachment((Object)inductionObj.getLong("id"), "tso_inductioninfo", AttachmentService.AttachmentSource.HCF, attachments);
        }
        catch (Exception ex) {
            LOG.error("MkOfferStartInductionService.setAttachmentInfo error :", (Throwable)ex);
        }
    }

    private void setCaneduexpsInfo(DynamicObject inductionObj, long appfileId) {
        Object[] caneduexps = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateAttachs", (Object[])new Object[]{appfileId, "hcf_caneduexp"});
        LOG.info("MkOfferStartInductionService.setCaneduexpsInfo caneduexps : {}", caneduexps);
        if (caneduexps != null && caneduexps.length > 0) {
            for (Object caneduexp : caneduexps) {
                if (!caneduexp.getBoolean("ishighestdegree")) continue;
                inductionObj.set("highesteducation", caneduexp.get("educationid.id"));
                inductionObj.set("schoolname", caneduexp.get("graduateschool.id"));
                inductionObj.set("specialtycategory", caneduexp.get("major"));
            }
        }
    }

    private void setCancresInfo(DynamicObject inductionObj, long appfileId) {
        Object[] cancres = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateAttachs", (Object[])new Object[]{appfileId, "hcf_cancre"});
        LOG.info("MkOfferStartInductionService.setCancresInfo cancres : {}", cancres);
        boolean hasCre = false;
        if (cancres != null) {
            for (Object cancre : cancres) {
                if (hasCre) break;
                if (!cancre.getBoolean("ismajor")) continue;
                inductionObj.set("credentialstype", cancre.get("credentialstype.id"));
                inductionObj.set("credentialsnumber", cancre.get("number"));
                hasCre = true;
            }
        }
    }

    private void setCandidateContactInfo(DynamicObject inductionObj, long appfileId) {
        DynamicObject[] cancontactinfos = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateAttachs", (Object[])new Object[]{appfileId, "hcf_cancontactinfo"});
        if (cancontactinfos != null && cancontactinfos.length > 0) {
            inductionObj.set("candidateemail", cancontactinfos[0].get("peremail"));
            inductionObj.set("candidatephone", cancontactinfos[0].get("phone"));
        }
    }

    private void setCandidateInfo(DynamicObject inductionObj, long appfileId) {
        Object[] candidateInfos = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateAttachs", (Object[])new Object[]{appfileId, "hcf_canbaseinfo"});
        LOG.info("MkOfferStartInductionService.setCandidateInfo candidateInfos : {}", candidateInfos);
        if (candidateInfos != null && candidateInfos.length > 0) {
            inductionObj.set("candidatename", (Object)candidateInfos[0].getString("name"));
            inductionObj.set("candidategender", (Object)candidateInfos[0].getLong("gender.id"));
            inductionObj.set("candidateage", (Object)candidateInfos[0].getInt("agetwo"));
            inductionObj.set("candidatenation", (Object)candidateInfos[0].getLong("nationality.id"));
            inductionObj.set("candidateworkage", candidateInfos[0].get("workseniority"));
        }
    }

    private DynamicObject updateDynamicObj(Map<Long, DynamicObject> inductionMap, DynamicObject offerObj) {
        offerObj.set("inductionstatus", (Object)InductionStatus.INDUCTION_PROCESS.getCode());
        offerObj.set("launchinderrdesc", (Object)"");
        offerObj.set("launchindtime", (Object)new Date());
        offerObj.set("modifytime", (Object)new Date());
        DynamicObject inductionObj = inductionMap.get(offerObj.getLong("id"));
        if (inductionObj != null) {
            inductionObj.set("inductionstatus", (Object)InductionStatus.INDUCTION_PROCESS.getCode());
            inductionObj.set("launchinderrdesc", (Object)"");
            inductionObj.set("launchindtime", (Object)DateUtils.nowDateTime());
            inductionObj.set("modifytime", (Object)DateUtils.nowDateTime());
        }
        return inductionObj;
    }

    private InductionCommModel getInductionCommModel(DynamicObject offerObj) {
        LaunchInductionInfo launchInductionInfo = new LaunchInductionInfo();
        launchInductionInfo.setAppfileId(Long.valueOf(offerObj.getLong("appfile.id")));
        launchInductionInfo.setInductionOfferDataBo(this.getInductionOfferDataObj(offerObj));
        InductionCommModel inductionCommModel = new InductionCommModel();
        inductionCommModel.setMessageType(InductionCommModel.MessageType.LAUNCH_INDUCTION.getCode());
        inductionCommModel.setLaunchInductionInfo(launchInductionInfo);
        return inductionCommModel;
    }

    public static MkOfferStartInductionService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final MkOfferStartInductionService INSTANCE = new MkOfferStartInductionService();

        private Instance() {
        }
    }
}

