/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.validator;

import java.text.MessageFormat;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.moka.offer.validator.AbstractSecondValidator;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.OfferIntegrateService;
import kd.tsc.tso.business.domain.offer.service.approve.OfferApproveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferBaseSubmitSecondValidator
extends AbstractSecondValidator {
    private static final OfferBaseSubmitService service = OfferBaseSubmitService.getInstance();

    @Override
    public void doValidator(IFormView formView, BeforeDoOperationEventArgs clickEvent) {
        DynamicObject offerInfo = formView.getParentView().getModel().getDataEntity();
        IFormView parentView = formView.getParentView();
        String entityId = "";
        entityId = parentView.getFormShowParameter() instanceof ListShowParameter ? ((ListShowParameter)parentView.getFormShowParameter()).getBillFormId() : parentView.getFormShowParameter().getFormId();
        if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrsc", (String)entityId, (String)"804f6478000000ac")) {
            clickEvent.setCancel(true);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
            DynamicObject dynamicObject = helper.queryOne(new QFilter("number", "=", (Object)entityId).toArray());
            String format = MessageFormat.format(OfferSubmitMultiLangConstants.noSubmitPermError(), dynamicObject.getString("name"));
            formView.showErrorNotification(format);
            return;
        }
        if (!OfferBaseSubmitService.getInstance().isVisible(offerInfo)) {
            clickEvent.setCancel(true);
            formView.showTipNotification(OfferSubmitMultiLangConstants.checkOfferStatus());
            return;
        }
        if (!OfferIntegrateService.verifyIntegrate(offerInfo, formView)) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyPhoneAndEmail(offerInfo, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifySalaryStatus(offerInfo, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyDate(offerInfo, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        boolean needApprove = OfferApproveService.Singleton.INSTANCE.getInstance().isNeedApprove();
        if (!needApprove) {
            formView.showTipNotification(OfferSubmitMultiLangConstants.noApproveTip());
            clickEvent.setCancel(true);
            return;
        }
        DynamicObject templateDy = offerInfo.getDynamicObject("template");
        if (((Boolean)formView.getModel().getValue("offer_letter")).booleanValue() && HRObjectUtils.isEmpty((Object)templateDy)) {
            formView.showErrorNotification(OfferSubmitMultiLangConstants.templateIsEmpty());
            clickEvent.setCancel(true);
            return;
        }
        OfferVerifyResult offerVerifyResult = service.canExecute(offerInfo, OfferBaseSubmitSecondValidator.needSave(formView));
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        if (resultEnum == OfferVerifyResultEnum.ALL_FAIL) {
            clickEvent.setCancel(true);
            this.handleverifyresultAllfail(offerVerifyResult, formView);
        }
    }

    @Override
    public void initInstance() {
        super.initInstance(this.getClass().getName(), new OfferBaseSubmitSecondValidator());
    }

    public static boolean needSave(IFormView formView) {
        return formView.getParentView().getFormShowParameter().getStatus() == OperationStatus.EDIT;
    }
}

