/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.mvc.SessionManager;
import kd.tsc.tso.business.domain.moka.offer.validator.AbstractSecondValidator;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.OfferIntegrateService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBillSubmitService;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;

public class OfferBillSubmitSecondValidator
extends AbstractSecondValidator {
    private final OfferBillSubmitService submitService = OfferBillSubmitService.getInstance();

    @Override
    public void doValidator(IFormView formView, BeforeDoOperationEventArgs clickEvent) {
        DynamicObject offerObj = this.getOffer(formView);
        if (!OfferIntegrateService.verifyIntegrate(offerObj, formView)) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyPhoneAndEmail(offerObj, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifySalaryStatus(offerObj, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyDate(offerObj, formView).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        OfferVerifyResult offerVerifyResult = this.submitService.canExecute(formView.getModel().getDataEntity(true), this.getOffer(formView));
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        if (resultEnum == OfferVerifyResultEnum.ALL_FAIL) {
            clickEvent.setCancel(true);
            this.handleverifyresultAllfail(offerVerifyResult, formView);
        }
    }

    @Override
    public void initInstance() {
        super.initInstance(this.getClass().getName(), new OfferBillSubmitSecondValidator());
    }

    private IFormView getOfferInfoView(IFormView formView) {
        String offerViewPageId = formView.getParentView().getPageCache().get("offerInfoPageId");
        return SessionManager.getCurrent().getView(offerViewPageId);
    }

    private DynamicObject getOffer(IFormView formView) {
        IFormView offerView = this.getOfferInfoView(formView);
        return offerView.getModel().getDataEntity(true);
    }
}

