/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.validator;

import com.google.common.collect.Lists;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.tsc.tso.business.domain.moka.offer.validator.AbstractSecondValidator;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBillAbandonService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferLetterBillAbandonSecondValidator
extends AbstractSecondValidator {
    private static OfferBillAbandonService abandonService = OfferBillAbandonService.getInstance();

    @Override
    public void doValidator(IFormView formView, BeforeDoOperationEventArgs clickEvent) {
        StringBuilder stringBuilder;
        if (!OfferPermService.getInstance().verifyHasPerm("bar_abandon", "tso_changeletterbill", (Long)TSCRequestContext.getOrgId())) {
            clickEvent.setCancel(true);
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u7684\u201c\u5e9f\u5f03\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = formView.getParentView().getModel().getDataEntity(true);
        DynamicObject offer = dataEntity.getDynamicObject("offer");
        if (this.isEidt(offer, stringBuilder = new StringBuilder(ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_9", (String)"tsc-tso-formplugin", (Object[])new Object[0])), formView)) {
            clickEvent.setCancel(true);
            return;
        }
        DynamicObject offerBillInfo = ChangeLetterBillHelper.getInstance().queryOne(formView.getParentView().getModel().getDataEntity(true).getPkValue());
        if (abandonService.isAlrAbandon(offerBillInfo)) {
            clickEvent.setCancel(true);
            formView.showTipNotification(ResManager.loadKDString((String)"Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u5df2\u5e9f\u5f03\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBillBtnAbandonPlugin_6", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!abandonService.isWaitResubmit(offerBillInfo)) {
            clickEvent.setCancel(true);
            formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u8fdb\u884c\u5e9f\u5f03\u3002", (String)"OfferBillBtnAbandonPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isEidt(DynamicObject offer, StringBuilder stringBuilder, IFormView formView) {
        long offerId;
        DynamicObject[] editObjs;
        if (offer != null && (editObjs = OfferEditMutexHelper.checkOfferIsEditing(Lists.newArrayList((Object[])new Long[]{offerId = offer.getLong("id")}))) != null && editObjs.length > 0) {
            String newStr = stringBuilder.toString().replace("{0}", editObjs[0].getString("user.name"));
            formView.showTipNotification(newStr);
            return true;
        }
        return false;
    }

    @Override
    public void initInstance() {
        super.initInstance(this.getClass().getName(), new OfferLetterBillAbandonSecondValidator());
    }
}

