/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.moka.offer.validator;

import com.google.common.collect.Maps;
import java.lang.ref.SoftReference;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;

public class OfferSecondValidatorFactory {
    static final Log LOG = LogFactory.getLog(OfferSecondValidatorFactory.class);
    static Map<String, SoftReference<Object>> OBJECT_CACHE = Maps.newConcurrentMap();

    public static SecondValidatorInterface getSecondValidatorInterface(String cls) {
        Object validatorObj;
        if (StringUtils.isEmpty((String)cls)) {
            return null;
        }
        SoftReference<Object> objectSoftReference = OBJECT_CACHE.get(cls);
        try {
            Class<?> clz = Class.forName(cls);
            if (objectSoftReference != null) {
                validatorObj = objectSoftReference.get();
                if (validatorObj == null) {
                    validatorObj = clz.newInstance();
                    OBJECT_CACHE.put(cls, new SoftReference<Object>(validatorObj));
                }
            } else {
                validatorObj = clz.newInstance();
                OBJECT_CACHE.put(cls, new SoftReference<Object>(validatorObj));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error("OfferSecondValidatorFactory.getSecondValidatorInterface error ", (Throwable)ex);
            return null;
        }
        LOG.info("OfferSecondValidatorFactory.getSecondValidatorInterface cls : {} validatorObj : {}", (Object)cls, validatorObj);
        return (SecondValidatorInterface)validatorObj;
    }

    public static void addValidatorCache(String cls, Object instanceObj) {
        if (StringUtils.isEmpty((String)cls) || instanceObj == null) {
            return;
        }
        OBJECT_CACHE.put(cls, new SoftReference<Object>(instanceObj));
    }
}

