/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.tsc.tso.business.domain.induction.service.InductionFormService;
import kd.tsc.tso.business.domain.moka.offer.CallbackMkInterfaceService;
import kd.tsc.tso.common.enums.offer.OfferPPeriodTermEnum;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class InductionMqConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(InductionMqConsumer.class);
    private InductionFormService inductionFormService = InductionFormService.Singleton.INSTANCE.getInstance();
    private static final String DAY_OF_MONTH = "30";
    private static final String DAY_OF_WEEK = "7";

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        logger.info("\u3010InductionMqConsumer\u3011 accepter message {}", (Object)JSONObject.toJSONString((Object)body));
        try {
            ResponseDTO responseDTO = (ResponseDTO)body;
            OnbrdRespVal result = (OnbrdRespVal)responseDTO.getResult();
            QFilter qFilter = new QFilter("appfile", "=", (Object)result.getAppFileId()).and("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
            switch (responseDTO.getOnboardType()) {
                case "A": {
                    this.induction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
                case "B": {
                    this.alrInduction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
                case "C": {
                    this.breakUpInduction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
                case "D": {
                    this.posInduction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
                case "E": {
                    this.depInduction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
                case "F": {
                    this.alrAndPosInduction((ResponseDTO<OnbrdRespVal>)responseDTO, qFilter);
                    break;
                }
            }
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.deny(messageId);
            logger.error("\u3010InductionMqConsumer\u3011do message -> \"{}\" error -> \"{}\" ", (Object)body.toString(), (Object)e);
        }
    }

    public String getRouteKey() {
        return super.getRouteKey();
    }

    private void alrAndPosInduction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        DynamicObject newInduction = this.inductionFormService.posIdc(inductionDyn, responseDTO);
        OnbrdRespVal result = (OnbrdRespVal)responseDTO.getResult();
        String date = DateUtils.formatDate((Date)result.getEnrollDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Integer monthOfDayOrWeek = this.getMonthOfDayOrWeek(result.getProbationTime(), result.getProbationTimeUnit());
        logger.info("InductionMqConsumer.alrAndPosInduction.monthOfDayOrWeek -> {}", (Object)monthOfDayOrWeek);
        Map<String, Object> resultMap = CallbackMkInterfaceService.doAlrInduction(result.getAppFileId(), date, monthOfDayOrWeek);
        this.inductionFormService.updateAtsStatus(newInduction, resultMap, Boolean.FALSE);
    }

    private void depInduction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        DynamicObject newInduction = this.inductionFormService.depIdc(inductionDyn);
        OnbrdRespVal result = (OnbrdRespVal)responseDTO.getResult();
        String date = DateUtils.formatDate((Date)result.getEnrollDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Map<String, Object> resultMap = CallbackMkInterfaceService.doDepInduction(result.getAppFileId(), "", date, result.getDepReasonId());
        this.inductionFormService.updateAtsStatus(newInduction, resultMap, Boolean.TRUE);
    }

    private void posInduction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        DynamicObject newInduction = this.inductionFormService.posIdc(inductionDyn, responseDTO);
        OnbrdRespVal result = (OnbrdRespVal)responseDTO.getResult();
        String date = DateUtils.formatDate((Date)result.getEnrollDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Map<String, Object> resultMap = CallbackMkInterfaceService.doPosInduction(result.getAppFileId(), 1, date);
        this.inductionFormService.updateAtsStatus(newInduction, resultMap, Boolean.FALSE);
    }

    private void breakUpInduction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        DynamicObject newInduction = this.inductionFormService.stopIdc(inductionDyn, ((OnbrdRespVal)responseDTO.getResult()).getBreakupTypeId(), ((OnbrdRespVal)responseDTO.getResult()).getBreakupReasonId(), ((OnbrdRespVal)responseDTO.getResult()).getBreakupRemarks());
        Map<String, Object> resultMap = CallbackMkInterfaceService.doTerminateInduction(((OnbrdRespVal)responseDTO.getResult()).getAppFileId(), ((OnbrdRespVal)responseDTO.getResult()).getBreakupReasonId());
        this.inductionFormService.updateAtsStatus(newInduction, resultMap, Boolean.FALSE);
    }

    private void alrInduction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        DynamicObject newInduction = this.inductionFormService.confirmIdc(inductionDyn, responseDTO);
        OnbrdRespVal result = (OnbrdRespVal)responseDTO.getResult();
        String hiredAt = DateUtils.formatDate((Date)result.getEnrollDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Integer monthOfDayOrWeek = this.getMonthOfDayOrWeek(result.getProbationTime(), result.getProbationTimeUnit());
        Map<String, Object> resultMap = CallbackMkInterfaceService.doAlrInduction(result.getAppFileId(), hiredAt, monthOfDayOrWeek);
        this.inductionFormService.updateAtsStatus(newInduction, resultMap, Boolean.FALSE);
    }

    private void induction(ResponseDTO<OnbrdRespVal> responseDTO, QFilter qFilter) {
        DynamicObject inductionDyn = this.inductionFormService.selectInduction(qFilter);
        if (responseDTO.getSuccess().booleanValue()) {
            this.inductionFormService.successLaunchIdc(inductionDyn);
        } else {
            this.inductionFormService.errorLaunchIdc(inductionDyn, responseDTO);
        }
    }

    private Integer getMonthOfDayOrWeek(Integer probationTime, String probationTimeUnit) {
        if (Objects.isNull(probationTime) || 0 == probationTime) {
            return 0;
        }
        BigDecimal probationTimeDecimal = new BigDecimal(probationTime);
        if (OfferPPeriodTermEnum.DAY.getCode().equals(probationTimeUnit)) {
            return probationTimeDecimal.divide(new BigDecimal(DAY_OF_MONTH), 0, RoundingMode.HALF_UP).intValue();
        }
        if (OfferPPeriodTermEnum.WEEK.getCode().equals(probationTimeUnit)) {
            return probationTimeDecimal.multiply(new BigDecimal(DAY_OF_WEEK)).divide(new BigDecimal(DAY_OF_MONTH), 0, RoundingMode.HALF_UP).intValue();
        }
        return probationTime;
    }
}

