/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.mq.producer;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.tsc.tso.business.domain.mq.model.induction.InductionModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import org.apache.commons.collections.CollectionUtils;

public class InductionProducer {
    private static final Log logger = LogFactory.getLog(OfferChangeProducer.class);
    private static final String QUEUE = "kd.hr.service.message.tsc.tso.induction_queue";
    private static final String QUEUE_IDC = "kd.hr.service.message.tsc.tso.idcmanage_queue";

    public static void sendAbandonInductionMessage(List<InductionModel> modelList) {
        logger.info("\u3010InductionProducer\u3011\"sendAbandonInductionMessage\" send message body {}:", modelList);
        try (MessagePublisher mqServer = null;){
            mqServer = MQFactory.get().createSimplePublisher("tsc", QUEUE);
            if (CollectionUtils.isEmpty(modelList)) {
                logger.error("send body is empty");
                return;
            }
            mqServer.publish(SerializationUtils.toJsonString(modelList));
        }
    }

    public static void sendLaunchOrStopIdcMessage(InductionCommModel model) throws KDBizException {
        logger.info("\u3010InductionProducer\u3011\"sendAcceptorInductionMessage\" send message body : {}", (Object)model);
        try (MessagePublisher mqServer = null;){
            mqServer = MQFactory.get().createSimplePublisher("tsc", QUEUE_IDC);
            if (model == null) {
                logger.error("send body is empty");
                return;
            }
            mqServer.publish((Object)model);
        }
    }
}

