/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.mq.producer;

import java.util.Collections;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import org.apache.commons.collections.CollectionUtils;

public class OfferChangeProducer {
    private static final Log logger = LogFactory.getLog(OfferChangeProducer.class);
    private static final String OFFER_CHANGE_QUEUE = "kd.hr.service.message.tsc.tspr.offer_change";

    public static void sendOfferChangeMessage(OfferChangeModel model) throws KDBizException {
        logger.info("send offer change message body : {}", (Object)model);
        try (MessagePublisher mqServer = MQFactory.get().createSimplePublisher("tsc", OFFER_CHANGE_QUEUE);){
            if (model == null) {
                logger.error("send body is empty");
                return;
            }
            mqServer.publish(SerializationUtils.toJsonString(Collections.singletonList(model)));
        }
    }

    public static void sendOfferChangeBatch(List<OfferChangeModel> modelList) {
        logger.info("send batch offer change message body : {}", modelList);
        try (MessagePublisher mqServer = MQFactory.get().createSimplePublisher("tsc", OFFER_CHANGE_QUEUE);){
            if (CollectionUtils.isEmpty(modelList)) {
                logger.error("send body is empty");
                return;
            }
            mqServer.publish(SerializationUtils.toJsonString(modelList));
        }
    }
}

