/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;

public class OfferVerifyResult {
    private static final long serialVersionUID = 1L;
    private Integer resultType;
    private List<VerifyOfferFailedInfo> failInfos;
    private List<Long> passIds;

    public OfferVerifyResult() {
        this.resultType = OfferVerifyResultEnum.ALL_PASS.getCode();
    }

    public OfferVerifyResult(Integer resultType) {
        this.resultType = resultType;
    }

    public Integer getResultType() {
        return this.resultType;
    }

    public void setResultType(int passDtSize, int allDtSize) {
        this.resultType = passDtSize == 0 ? OfferVerifyResultEnum.ALL_FAIL.getCode() : (passDtSize < allDtSize ? OfferVerifyResultEnum.PART_PASS.getCode() : OfferVerifyResultEnum.ALL_PASS.getCode());
    }

    public void setResultType(Integer resultType) {
        this.resultType = resultType;
    }

    public List<VerifyOfferFailedInfo> getFailInfos() {
        if (Objects.isNull(this.failInfos)) {
            this.failInfos = new ArrayList<VerifyOfferFailedInfo>();
        }
        return this.failInfos;
    }

    public void setFailInfos(List<VerifyOfferFailedInfo> failInfos) {
        this.failInfos = failInfos;
    }

    public List<Long> getPassIds() {
        if (Objects.isNull(this.passIds)) {
            this.passIds = new ArrayList<Long>();
        }
        return this.passIds;
    }

    public void setPassIds(List<Long> passIds) {
        this.passIds = passIds;
    }

    public OfferVerifyResult recordFailInfoForBase(DynamicObject offerInfo, OfferErrorEnum errorEnum, String errorMsg) {
        this.setResultType(OfferVerifyResultEnum.ALL_FAIL.getCode());
        this.getFailInfos().add(new VerifyOfferFailedInfo(offerInfo.getString("number"), errorEnum.getCode(), errorMsg));
        return this;
    }

    public OfferVerifyResult recordFailInfoForBill(DynamicObject dynamicObject, OfferErrorEnum errorEnum, String errorMsg) {
        this.setResultType(OfferVerifyResultEnum.ALL_FAIL.getCode());
        this.getFailInfos().add(new VerifyOfferFailedInfo(dynamicObject.getString("billno"), errorEnum.getCode(), errorMsg));
        return this;
    }
}

