/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferUtils;

public class ChangeLetterBillHelper
extends HRBaseServiceHelper {
    private final OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
    private final OfferGenOpRecordService genOpRecordService = OfferGenOpRecordService.getInstance();

    public ChangeLetterBillHelper(String entityName) {
        super(entityName);
    }

    public static ChangeLetterBillHelper getInstance() {
        return Instance.LETTER_INSTANCE;
    }

    public DynamicObject[] getWaitResubmitBill(List<DynamicObject> offerIdList) {
        List offerWithBillList = offerIdList.stream().filter(offer -> OfferAuditStatus.getStatusByCode((String)offer.getString("letterauditstatus")) == OfferAuditStatus.WAIT_RESUBMIT).collect(Collectors.toList());
        if (offerWithBillList.isEmpty()) {
            return null;
        }
        List letterAuditNos = offerWithBillList.stream().map(offerObj -> offerObj.getString("letterauditno")).collect(Collectors.toList());
        QFilter filter = new QFilter("billno", "in", letterAuditNos);
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"billstatus", "changelettervalid", "modifytime", "modifier", "billno"});
        return this.query(selectProperties, filter.toArray());
    }

    public void updateBillInfo(DynamicObject[] letterChangeBills) {
        LinkedList chgLtrValidObjs = Lists.newLinkedList();
        Arrays.stream(letterChangeBills).forEach(offerBill -> {
            offerBill.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
            OfferUtils.updateModifyInfo((DynamicObject)offerBill);
            DynamicObject chgLtrVlidObj = offerBill.getDynamicObject("changelettervalid");
            chgLtrVlidObj.set("lettervalidstatus", (Object)"E");
            chgLtrValidObjs.add(chgLtrVlidObj);
        });
        OfferBillServiceHelper.getInstance().update(letterChangeBills);
        ChangeLetterValidHelper.getInstance().update(chgLtrValidObjs.toArray(new DynamicObject[0]));
        this.cancelWorkFlow(letterChangeBills);
    }

    public OperationResult cancelWorkFlow(DynamicObject[] letterChangeBills) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        Object[] ids = Arrays.stream(letterChangeBills).map(bill -> bill.getLong("id")).toArray();
        OperationResult result = opImpl.localInvokeOperation("abandon", "tso_changeletterbill", ids, OperateOption.create());
        return result;
    }

    public OperationResult saveChangeLetterBill(IFormView ltrChgView, DynamicObject dbBill) {
        OperationResult ltrOptResult = new OperationResult();
        ltrOptResult = ltrChgView.invokeOperation("save");
        if (!ltrOptResult.isSuccess()) {
            return ltrOptResult;
        }
        try (TXHandle tx = TX.required();){
            try {
                this.genOpRecordService.genEditOfferLetterBillOpRecord(dbBill);
                DynamicObject changeValidObj = ltrChgView.getModel().getDataEntity(true);
                long letterObjId = dbBill.getLong("offerletter.id");
                DynamicObject letterObj = this.letterServiceHelper.queryOne(letterObjId);
                letterObj.set("validtime", changeValidObj.get("newvalidtime"));
                letterObj.set("changevaliddesc", changeValidObj.get("changereason"));
                this.letterServiceHelper.updateOne(letterObj);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException("save offer letter change fail");
            }
        }
        return ltrOptResult;
    }

    public OperationResult submitChangeLetterBill(IFormView ltrChgView, DynamicObject dbBill, boolean editStatus, boolean isFlow) {
        DynamicObject changeValidObj;
        OperationResult ltrOptResult = new OperationResult();
        if (editStatus) {
            changeValidObj = ltrChgView.getModel().getDataEntity(true);
            ltrOptResult = ltrChgView.invokeOperation("save");
            if (!ltrOptResult.isSuccess()) {
                return ltrOptResult;
            }
        } else {
            changeValidObj = dbBill.getDynamicObject("changelettervalid");
        }
        try (TXHandle tx = TX.required();){
            try {
                ltrOptResult.setSuccess(true);
                if (isFlow) {
                    OperationServiceImpl opImpl = new OperationServiceImpl();
                    opImpl.localInvokeOperation("submit", new DynamicObject[]{dbBill}, null);
                }
                if (editStatus) {
                    this.genOpRecordService.genEditOfferLetterBillOpRecord(dbBill);
                }
                this.genOpRecordService.genSubmitOfferLetterBillOpRecord(dbBill, "\u63d0\u4ea4");
                long letterObjId = dbBill.getLong("offerletter.id");
                DynamicObject letterObj = this.letterServiceHelper.queryOne(letterObjId);
                letterObj.set("validtime", changeValidObj.get("newvalidtime"));
                letterObj.set("changevaliddesc", changeValidObj.get("changereason"));
                this.letterServiceHelper.updateOne(letterObj);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException("submit offer letter change fail");
            }
        }
        return ltrOptResult;
    }

    public DynamicObject queryOneByAuditNo(String auditNo) {
        QFilter qFilter = new QFilter("billno", "=", (Object)auditNo);
        return this.loadDynamicObject(qFilter);
    }

    private static class Instance {
        private static final ChangeLetterBillHelper LETTER_INSTANCE = new ChangeLetterBillHelper("tso_changeletterbill");

        private Instance() {
        }
    }
}

