/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.ChangeOfferLetterHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.helper.OfferAbandonHelper;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ChangeLetterValidHelper
extends HRBaseServiceHelper {
    private final OfferServiceHelper offerHelper = OfferServiceHelper.getInstance();
    private final OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
    private final ChangeOfferLetterHelper changeOfferLetterHelper = ChangeOfferLetterHelper.getInstance();
    private final OfferGenOpRecordService genOpRecordService = OfferGenOpRecordService.getInstance();
    private static final Log logger = LogFactory.getLog(LabelTagObjServiceHelper.class);

    public ChangeLetterValidHelper(String entityName) {
        super(entityName);
    }

    public static ChangeLetterValidHelper getInstance() {
        return Instance.LETTER_INSTANCE;
    }

    public void submit(DynamicObject dataEntity) {
        DynamicObject changeBill = this.getChangeBill(dataEntity);
        this.executeOperate(changeBill);
    }

    public void billStatusConvert(DynamicObject dataEntity, String operationKey) {
        if ("submit".equals(operationKey)) {
            dataEntity.set("billstatus", (Object)"B");
            this.updateOfferLetterVaild(dataEntity);
            this.updateOfferApprovalBillToOffer(dataEntity);
        }
    }

    private void updateOfferLetterVaild(DynamicObject changeBill) {
        DynamicObject changeLetterValid = changeBill.getDynamicObject("changelettervalid");
        DynamicObject change = this.queryOne("id,lettervalidstatus", changeLetterValid.getLong("id"));
        change.set("lettervalidstatus", (Object)"B");
        this.updateDataOne(change);
    }

    private void updateOfferApprovalBillToOffer(DynamicObject changeBill) {
        DynamicObject offerObj = changeBill.getDynamicObject("offer");
        DynamicObject offerDbObj = OfferServiceHelper.getInstance().queryOne("letterauditno,letterauditstatus", offerObj.getLong("id"));
        offerDbObj.set("letterauditno", (Object)changeBill.getString("billno"));
        offerDbObj.set("letterauditstatus", (Object)changeBill.getString("billstatus"));
        OfferServiceHelper.getInstance().saveOne(offerDbObj);
    }

    private void updateOfferApprovalBillToOfferStatus(DynamicObject changeBill, String status) {
        DynamicObject offerObj = changeBill.getDynamicObject("offer");
        DynamicObject offerDbObj = OfferServiceHelper.getInstance().queryOne("letterauditno,letterauditstatus", offerObj.getLong("id"));
        offerDbObj.set("letterauditstatus", (Object)status);
        OfferServiceHelper.getInstance().saveOne(offerDbObj);
    }

    public void approveStatusConvert(DynamicObject dataEntity, String operationKey, String commitSource) {
        DynamicObject dbBill = ChangeLetterBillHelper.getInstance().loadSingle(dataEntity.getLong("id"));
        DynamicObject change = this.queryOne("id,lettervalidstatus", dbBill.getDynamicObject("changelettervalid").getLong("id"));
        if ("inaudit".equals(operationKey)) {
            change.set("lettervalidstatus", (Object)"B");
            dbBill.set("billstatus", (Object)"D");
            this.updateOfferApprovalBillToOfferStatus(dbBill, "D");
        } else if ("approve_success".equals(operationKey)) {
            change.set("lettervalidstatus", (Object)"C");
            dbBill.set("applycompletetime", (Object)KDDateUtils.now());
            dbBill.set("billstatus", (Object)"C");
            long letterId = dbBill.getDynamicObject("offerletter").getLong("id");
            OfferLetterServiceHelper.getInstance().updateOfferLetterWhenSuccess(letterId, true);
            this.updateOfferApprovalBillToOfferStatus(dbBill, "C");
            OfferLetterService.Singleton.INSTANCE.getInstance().sendOfferChangeMessage(letterId, OfferLetterStatus.PRE_SEND.getCode());
            this.addApproveUser(dbBill);
            this.genOpRecordService.genAgreeApproveOfferLetterBillOpRecord(dbBill, true);
        } else if ("approve_fail".equals(operationKey)) {
            change.set("lettervalidstatus", (Object)"D");
            dbBill.set("applycompletetime", (Object)KDDateUtils.now());
            dbBill.set("billstatus", (Object)"E");
            this.updateOfferApprovalBillToOfferStatus(dbBill, "E");
            this.addApproveUser(dbBill);
            this.genOpRecordService.genDisagreeApproveOfferLetterBillOpRecord(dbBill);
        } else if ("revoke".equals(operationKey)) {
            this.updateUnSubmitStatus(dbBill);
            this.genOpRecordService.genUnSubmitOfferLetterBillOpRecord(dbBill, "\u64a4\u9500");
        } else if ("reject_to_commit".equals(operationKey)) {
            this.updateStatusToRejectComNode(dbBill);
        } else if ("reject_to_oneauditnode".equals(operationKey)) {
            dbBill.set("billstatus", (Object)OfferAuditStatus.ALR_SUBMIT.getCode());
            OfferUtils.updateModifyInfo((DynamicObject)dbBill);
            this.updateOne(dbBill);
            DynamicObject offerObj = dbBill.getDynamicObject("offer");
            offerObj.set("letterauditstatus", (Object)OfferAuditStatus.ALR_SUBMIT.getCode());
            OfferUtils.updateModifyInfo((DynamicObject)offerObj);
            this.offerHelper.updateOne(offerObj);
        } else if ("submit".equals(operationKey) && "tso_changelettervalid".equals(commitSource)) {
            OfferGenOpRecordService.getInstance().genNewOfferLetterBillOpRecord(dataEntity);
        } else {
            return;
        }
        ChangeLetterBillHelper.getInstance().updateDataOne(dbBill);
        this.updateDataOne(change);
    }

    private void updateStatusToRejectComNode(DynamicObject changeLetterBillObj) {
        changeLetterBillObj.set("billstatus", (Object)OfferAuditStatus.WAIT_RESUBMIT.getCode());
        OfferUtils.updateModifyInfo((DynamicObject)changeLetterBillObj);
        this.updateOne(changeLetterBillObj);
        long offerObjId = changeLetterBillObj.getLong("offer.id");
        DynamicObject offerObj = this.offerHelper.queryOne(offerObjId);
        offerObj.set("letterauditstatus", (Object)OfferAuditStatus.WAIT_RESUBMIT.getCode());
        OfferUtils.updateModifyInfo((DynamicObject)offerObj);
        this.offerHelper.updateOne(offerObj);
        long changLetterId = changeLetterBillObj.getLong("changelettervalid.id");
        DynamicObject letterChangeObj = this.changeOfferLetterHelper.queryOne("lettervalidstatus", changLetterId);
        letterChangeObj.set("lettervalidstatus", (Object)"A");
        this.changeOfferLetterHelper.updateOne(letterChangeObj);
    }

    public void updateUnSubmitStatus(DynamicObject changeLetterBillObj) {
        changeLetterBillObj.set("billstatus", (Object)OfferAuditStatus.TEMPORARY.getCode());
        OfferUtils.updateModifyInfo((DynamicObject)changeLetterBillObj);
        this.updateOne(changeLetterBillObj);
        long offerObjId = changeLetterBillObj.getLong("offer.id");
        DynamicObject offerObj = this.offerHelper.queryOne(offerObjId);
        offerObj.set("letterauditstatus", (Object)OfferAuditStatus.TEMPORARY.getCode());
        OfferUtils.updateModifyInfo((DynamicObject)offerObj);
        this.offerHelper.updateOne(offerObj);
        long changLetterId = changeLetterBillObj.getLong("changelettervalid.id");
        DynamicObject letterChangeObj = this.changeOfferLetterHelper.queryOne("lettervalidstatus", changLetterId);
        letterChangeObj.set("lettervalidstatus", (Object)"A");
        this.changeOfferLetterHelper.updateOne(letterChangeObj);
    }

    private void addApproveUser(DynamicObject letterAuditObj) {
        DynamicObjectCollection dynamicObjectCollection = letterAuditObj.getDynamicObjectCollection("auditusers");
        DynamicObject approveUserObj = dynamicObjectCollection.addNew();
        approveUserObj.set("fbasedataid", (Object)TSCRequestContext.getUserId());
    }

    private DynamicObject getChangeBill(DynamicObject changeLetterValid) {
        DynamicObject changeBill = ChangeLetterBillHelper.getInstance().generateEmptyDynamicObject();
        changeBill.set("changelettervalid", (Object)changeLetterValid);
        long offerId = changeLetterValid.getDynamicObject("offerletter").getDynamicObject("offer").getLong("id");
        DynamicObject offerObj = OfferServiceHelper.getInstance().queryOne(offerId);
        DynamicObject offerLetter = offerObj.getDynamicObject("offerletter");
        changeBill.set("offerletter", (Object)offerLetter);
        changeBill.set("offer", (Object)changeLetterValid.getDynamicObject("offerletter").getDynamicObject("offer"));
        changeBill.set("applyname", (Object)(changeLetterValid.getDynamicObject("offerletter").getDynamicObject("appfile").getString("name") + OfferMultilingualConstants.getChangeLetterNameSuffix()));
        changeBill.set("applyuser", (Object)TSCRequestContext.getUserId());
        changeBill.set("applydatetime", (Object)new Date());
        Date now = new Date();
        changeBill.set("applydatetime", (Object)now);
        changeBill.set("billstatus", (Object)"A");
        changeBill.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"tso_changeletterbill", (DynamicObject)changeBill, null));
        changeBill.set("creator", (Object)TSCRequestContext.getUserId());
        changeBill.set("createtime", (Object)now);
        changeBill.set("modifier", (Object)TSCRequestContext.getUserId());
        changeBill.set("modifytime", (Object)now);
        changeBill.set("billstatus", (Object)"A");
        long oldLetterId = changeLetterValid.getLong("offerletter.id");
        DynamicObject oldLetterDy = this.letterServiceHelper.queryOne(oldLetterId);
        changeBill.set("sendlettercontent_tag", oldLetterDy.get("sendlettercontent_tag"));
        return changeBill;
    }

    private void executeOperate(DynamicObject offerLetterChangeBill) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        options.setVariableValue("commitSource", "tso_changelettervalid");
        options.setVariableValue("appnumber", "tsrsc");
        OperationServiceHelper.executeOperate((String)"submit", (String)"tso_changeletterbill", (DynamicObject[])new DynamicObject[]{offerLetterChangeBill}, (OperateOption)options);
    }

    public long abandonedOldAndGenerateNewLetter(DynamicObject dataEntity) {
        Long offerLetterId = dataEntity.getLong("offerletter.id");
        DynamicObject offerLetterObj = this.letterServiceHelper.queryOne(offerLetterId);
        long offerId = offerLetterObj.getLong("offer.id");
        DynamicObject offerObj = this.offerHelper.loadSingle(offerId);
        Date validTime = dataEntity.getDate("newvalidtime");
        OfferAbandonHelper.getInstance().updateLetterInfo(Lists.newArrayList((Object[])new DynamicObject[]{offerLetterObj}), null, null);
        OfferGenOpRecordService.getInstance().genAbandonOfferLetterOpRecord(Collections.singletonList(offerObj), null, dataEntity.getString("changereason"), ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"ChangeLetterValidHelper_0", (String)"tsc-tso-business", (Object[])new Object[0]));
        DynamicObject newLetter = OfferLetterService.Singleton.INSTANCE.getInstance().generateValidOfferLetter(offerId, validTime, null, dataEntity.getString("changereason"), dataEntity.getInt("letteraudit") == 1);
        newLetter.set("sendlettercontent_tag", offerLetterObj.get("sendlettercontent_tag"));
        OfferLetterServiceHelper.getInstance().saveOne(newLetter);
        OfferGenOpRecordService.getInstance().genNewOfferLetterOpRecord(Collections.singletonList(offerObj), 0);
        OfferGenOpRecordService.getInstance().changValidTimeAndLastReplyDate(Collections.singletonList(offerObj), validTime, dataEntity.getString("changereason"), null);
        DynamicObject offerDbObj = OfferServiceHelper.getInstance().queryOne("offerletter,letterauditstatus,inductionstatus,launchindstatus,launchindtime,launchinderrdesc", offerId);
        offerDbObj.set("offerletter", (Object)newLetter);
        offerDbObj.set("inductionstatus", (Object)"");
        offerDbObj.set("launchindstatus", (Object)"");
        offerDbObj.set("launchindtime", null);
        offerDbObj.set("launchinderrdesc", (Object)"");
        OfferServiceHelper.getInstance().saveOne(offerDbObj);
        this.updateAppfile(offerObj, newLetter);
        return newLetter.getLong("id");
    }

    private void updateAppfile(DynamicObject offerDy, DynamicObject newLetterDy) {
        long appfileId = offerDy.getLong("appfile.id");
        if (appfileId == 0L) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter qFilter = new QFilter("id", "=", (Object)appfileId);
        DynamicObject appfileDy = serviceHelper.queryOne("id,offerletter", new QFilter[]{qFilter});
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            appfileDy.set("offerletter_id", (Object)newLetterDy.getLong("id"));
            serviceHelper.update(new DynamicObject[]{appfileDy});
        }
    }

    private static class Instance {
        private static final ChangeLetterValidHelper LETTER_INSTANCE = new ChangeLetterValidHelper("tso_changelettervalid");

        private Instance() {
        }
    }
}

