/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.CallbackMkInterfaceService;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferContHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tso.common.constants.offer.notice.OfferAdviceConstants;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tso.common.util.OfferVerifyCodeUtils;
import kd.tsc.tso.common.util.Sha256Utils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferAdviceBizHelper
implements OfferAdviceConstants {
    private static Log log = LogFactory.getLog(OfferAdviceBizHelper.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"offerAdvice_pool", (int)10, (int)200);
    private static final String SCENE_NUMBER = "T_008";
    private static final String TYPE_NUMBER = "T_003";
    private static final Long TYPE_REPORT_PERSON_ID = 1011L;

    public static FormShowParameter getInContainerForm(String formId, String targetKey, Map<String, Object> param) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setCustomParams(param);
        parameter.getOpenStyle().setTargetKey(targetKey);
        return parameter;
    }

    public static Map<String, Object> getCustomParam(Map<String, Object> paramMap, Set<String> allFields) {
        HashMap customMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            customMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        Set hadFields = customMap.keySet();
        Sets.SetView difference = Sets.difference(allFields, hadFields);
        difference.forEach(field -> customMap.put(field, ""));
        return customMap;
    }

    public static IFormView getFormViewByCacheKey(String pageCacheId) {
        return SessionManager.getCurrent().getView(pageCacheId);
    }

    public static Set<String> getMsgFieldVariableByScene() {
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgFieldVariableByScene((String)SCENE_NUMBER, (String)TYPE_NUMBER);
        return Arrays.stream(dynamicObjects).map(dy -> dy.getString("fieldname")).collect(Collectors.toSet());
    }

    public static void sendOfferAdvice(DynamicObject dataEntity) {
        try {
            OfferAttachmentService.getInstance().generateLetterAttachment(dataEntity);
        }
        catch (Exception ex) {
            log.error("sendOfferAcvice error -> ", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("", OfferSendMultiLangConstants.sendOfferFail());
            throw new KDBizException(errorCode, new Object[]{ex});
        }
    }

    public static void mokaSendOfferAdvice(DynamicObject dataEntity, String verifyCode) {
        try {
            DynamicObject adviceObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offernotice");
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)adviceObj);
            adviceObj.set("verifycode", (Object)verifyCode);
            THREAD_POOL.execute(() -> OfferAttachmentService.getInstance().mokaGenerateLetterAttachment(adviceObj));
        }
        catch (Exception ex) {
            log.error("sendOfferAcvice error -> ", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("", OfferSendMultiLangConstants.generateAttachmentError());
            throw new KDBizException(errorCode, new Object[]{ex});
        }
    }

    public static String addVerifyCode(DynamicObject dataEntity) {
        String verifyCode = dataEntity.getString("verifycode");
        if (HRStringUtils.isEmpty((String)verifyCode)) {
            verifyCode = OfferVerifyCodeUtils.init().generateVerifyCode();
        }
        return verifyCode;
    }

    public static void putParentCache(IPageCache cache, String key, String value) {
        if (HRStringUtils.isEmpty((String)value)) {
            cache.remove(key);
        } else {
            cache.put(key, value);
        }
    }

    public static String getParentCache(IPageCache cache, String key) {
        return cache.get(key);
    }

    public static void updateConnInfo(DynamicObject dynamicObject) {
        long letterId = dynamicObject.getLong("letterid");
        long offerId = dynamicObject.getLong("offerid");
        DynamicObject connect = OfferContHelper.getConnect(letterId);
        if (connect == null) {
            connect = OfferContHelper.generateDynamicObj();
            connect.set("offer", (Object)offerId);
            connect.set("offerletter", (Object)letterId);
        }
        connect.set("contact", dynamicObject.get("contact"));
        connect.set("contactemail", dynamicObject.get("contactemail"));
        connect.set("contactphone", dynamicObject.get("contactphone"));
        OfferUtils.updateModifyInfo((DynamicObject)connect);
        OfferContHelper.updateConnect(connect);
    }

    public static String getOfferLetterLink(String letterNo, String candidatePhone) {
        String loginTypeCode = OfferParamConfigService.getInstance().getLoginType();
        String key = Joiner.on((String)"_").join(new Object[]{letterNo, candidatePhone, loginTypeCode});
        String sign = Sha256Utils.getSha256((String)key);
        Object[] linkParam = new Object[]{UrlService.getDomainContextUrl(), "tso", "tso_offerloginmain", sign, letterNo, loginTypeCode, RequestContext.get().getAccountId()};
        String url = "{0}/?userId=Guest&appNumber={1}&formId={2}&key={3}&letterNumber={4}&type={5}&accountId={6}";
        String loginUrl = MessageFormat.format(url, linkParam);
        log.info("OfferLetterLink\uff1a{}", (Object)loginUrl);
        return loginUrl;
    }

    public static void cacheMsgFormShowParameter(IFormView msgFormView, DynamicObject dataEntity) {
        Map customParams = msgFormView.getFormShowParameter().getCustomParams();
        Date lastReplyTime = dataEntity.getDate("lastreplytime");
        String formatDate = "";
        if (Objects.nonNull(lastReplyTime)) {
            formatDate = HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"lastreplytime", (Date)lastReplyTime);
        }
        customParams.put("lastreplytime", formatDate);
        customParams.put("contactphone", dataEntity.get("contactphone"));
        DynamicObject contact = dataEntity.getDynamicObject("contact");
        String contactName = Optional.ofNullable(contact).map(dy -> dy.getString("name")).orElse("");
        customParams.put("contact", contactName);
        customParams.put("verifycode", dataEntity.getString("verifycode"));
        DynamicObject address = dataEntity.getDynamicObject("reportaddress");
        String addressName = Optional.ofNullable(address).map(dy -> dy.getString("name")).orElse("");
        customParams.put("reportaddress", addressName);
        customParams.put("contactemail", dataEntity.getString("contactemail"));
        msgFormView.cacheFormShowParameter();
    }

    public static String getOperateResultMessage(OperationResult operationResult) {
        String message = null;
        ValidateResultCollection resultCollection = operationResult.getValidateResult();
        List validateErrors = resultCollection.getValidateErrors();
        if (validateErrors.isEmpty()) {
            message = operationResult.getMessage();
        } else {
            for (ValidateResult validateError : validateErrors) {
                List errorInfo = validateError.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : errorInfo) {
                    message = operateErrorInfo.getMessage();
                }
            }
        }
        return message;
    }

    public static void sendOfferLetter(DynamicObject dynamicObject, String operateName, OperateOption option) {
        long offerId = dynamicObject.getLong("offerid");
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(offerId);
        long letterId = dynamicObject.getLong("letterid");
        DynamicObject letter = OfferLetterServiceHelper.getInstance().queryOne(letterId);
        OfferAdviceBizHelper.setEmailNoticeInfo(dynamicObject, letter, option);
        String letterContent = OfferAttachmentService.getInstance().generateLetterContent(Boolean.TRUE, offer, letter, dynamicObject);
        letter.set("sendtype", (Object)option.getVariableValue("sendtype"));
        OfferAdviceBizHelper.updateOfferLetter(letter, dynamicObject, letterContent);
        OfferAdviceBizHelper.syncStatusToAppFile(offer);
        OfferGenOpRecordService.getInstance().genSendOfferLetterOpRecord(Collections.singletonList(offer), operateName);
    }

    private static void setEmailNoticeInfo(DynamicObject noticeObj, DynamicObject letter, OperateOption option) {
        List bccUsers;
        List mkUsers;
        letter.set("candidatenoticeopen", (Object)noticeObj.getBoolean("candidatenoticeopen"));
        letter.set("rcpersonopen", (Object)noticeObj.getBoolean("rcpersonopen"));
        if (noticeObj.getBoolean("candidatenoticeopen")) {
            if (option.containsVariable("candidatenoticecr")) {
                mkUsers = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("candidatenoticecr"), List.class);
                mkUsers.forEach(userId -> {
                    DynamicObject candidateNoticeCrObj = letter.getDynamicObjectCollection("candidatenoticecr").addNew();
                    candidateNoticeCrObj.set("fbasedataid", userId);
                });
            }
            if (option.containsVariable("candidatenoticesr")) {
                bccUsers = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("candidatenoticesr"), List.class);
                bccUsers.forEach(userId -> {
                    DynamicObject candidateNoticeCrObj = letter.getDynamicObjectCollection("candidatenoticesr").addNew();
                    candidateNoticeCrObj.set("fbasedataid", userId);
                });
            }
        }
        if (noticeObj.getBoolean("rcpersonopen")) {
            if (option.containsVariable("rcpersonopencr")) {
                mkUsers = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("rcpersonopencr"), List.class);
                mkUsers.forEach(userId -> {
                    DynamicObject candidateNoticeCrObj = letter.getDynamicObjectCollection("rcpersonopencr").addNew();
                    candidateNoticeCrObj.set("fbasedataid", userId);
                });
            }
            if (option.containsVariable("rcpersonopensr")) {
                bccUsers = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("rcpersonopensr"), List.class);
                bccUsers.forEach(userId -> {
                    DynamicObject candidateNoticeCrObj = letter.getDynamicObjectCollection("rcpersonopensr").addNew();
                    candidateNoticeCrObj.set("fbasedataid", userId);
                });
            }
        }
    }

    private static void updateOfferLetter(DynamicObject letter, DynamicObject dynamicObject, String letterContent) {
        DynamicObject reportAddress;
        Date nowDateTime = DateUtils.nowDateTime();
        letter.set("verifycode", dynamicObject.get("verifycode"));
        letter.set("letterstatus", (Object)OfferLetterStatus.ALR_SEND.getCode());
        letter.set("replystatus", (Object)OfferLetterReplyStatus.PRE_REPLY.getCode());
        letter.set("datastatus", (Object)OfferLetterDataStatus.TAKE_EFFECT.getCode());
        if (Objects.isNull(letter.get("validtime"))) {
            int validTimeConfig = OfferParamConfigService.getInstance().getValidTimeConfig();
            letter.set("validtime", (Object)DateUtils.afterNowDateTime((int)validTimeConfig));
        }
        letter.set("sendtime", (Object)nowDateTime);
        letter.set("modifytime", (Object)nowDateTime);
        letter.set("modifier", (Object)TSCRequestContext.getUserId());
        letter.set("senduser", (Object)TSCRequestContext.getUserId());
        letter.set("lastreplytime", dynamicObject.get("lastreplytime"));
        letter.set("sendlettercontent_tag", (Object)letterContent);
        letter.set("logintype", dynamicObject.get("logintype"));
        letter.set("isepannex", dynamicObject.get("isepannex"));
        letter.set("isgtannex", dynamicObject.get("isgtannex"));
        DynamicObject template = dynamicObject.getDynamicObject("template");
        if (!HRObjectUtils.isEmpty((Object)template)) {
            letter.set("template", template.get("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(reportAddress = dynamicObject.getDynamicObject("reportaddress")))) {
            letter.set("reportaddress", reportAddress.get("id"));
        }
        OfferLetterServiceHelper.getInstance().updateOne(letter);
    }

    private static void syncStatusToAppFile(DynamicObject offer) {
        OfferChangeModel model = new OfferChangeModel();
        model.setAppFileId(offer.getDynamicObject("appfile").getLong("id"));
        model.setOfferId(offer.getLong("id"));
        model.setOfferStatus(OfferLetterReplyStatus.PRE_REPLY.getCode());
        OfferChangeProducer.sendOfferChangeBatch(Collections.singletonList(model));
    }

    public static Map<String, String> getMsgFieldByScene() {
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgFieldVariableByScene((String)SCENE_NUMBER, (String)TYPE_NUMBER);
        HashMap<String, String> map = new HashMap<String, String>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            map.put(dy.getString("fieldname"), dy.getString("name"));
        }
        return map;
    }

    public static void doInvokMokaSendInterface(DynamicObject adviceObject, OperateOption option) {
        long offerId = adviceObject.getLong("offerid");
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(offerId);
        long appfileId = offer.getDynamicObject("appfile").getLong("id");
        long joblevel = offer.getLong("joblevel.id");
        String[] emailCC = OfferAdviceBizHelper.getEmailCC(option);
        CallbackMkInterfaceService.doSendOffer(appfileId, joblevel, emailCC);
    }

    private static String[] getEmailCC(OperateOption option) {
        List ids = new ArrayList();
        if (option.containsVariable("candidatenoticecr")) {
            ids = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("candidatenoticecr"), List.class);
        }
        log.info("OfferAdviceBizHelper-getEmailCC-ids: {}", ids);
        String[] emailCC = new String[ids.size()];
        List userInfoList = UserServiceHelper.getUserInfoByID(ids);
        for (int i = 0; i < userInfoList.size(); ++i) {
            String email;
            Map userInfoMap = (Map)userInfoList.get(i);
            emailCC[i] = email = (String)userInfoMap.get("email");
        }
        return emailCC;
    }

    public static Map<String, String> getReportPersonMsgFieldByScene() {
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgFieldVariableByScene((String)SCENE_NUMBER, (Long)TYPE_REPORT_PERSON_ID);
        HashMap<String, String> map = new HashMap<String, String>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            map.put(dy.getString("fieldname"), dy.getString("name"));
        }
        return map;
    }
}

