/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;

public class OfferApprovalFormBizHelper {
    private static final Log log = LogFactory.getLog(OfferApprovalFormBizHelper.class);

    public static Map<Long, String> offerIdWithApprove(DynamicObject[] dys) {
        int length = dys.length;
        HashMap billName = Maps.newHashMapWithExpectedSize((int)length);
        Arrays.stream(dys).forEach(dynamicObject -> {
            List userIds = WorkflowServiceHelper.getApproverByBusinessKey((String)dynamicObject.getPkValue().toString());
            log.info("OfferApprovalFormBizHelper.offerIdWithApprove.userIds:[{}]", (Object)userIds);
            List userInfo = UserServiceHelper.getUserInfoByID((List)userIds);
            StringBuilder approveName = new StringBuilder();
            for (Map user : userInfo) {
                if (!StringUtils.isEmpty((String)approveName.toString())) {
                    approveName.append(',');
                }
                Object name = user.get("name");
                approveName.append(name);
            }
            billName.put(dynamicObject.getLong("id"), approveName.toString());
        });
        return billName;
    }

    public static DynamicObject[] getOfferApprovalFormEntry(Long offerId) {
        return OfferBillServiceHelper.getInstance().getBillByOfferId(offerId);
    }

    public static TableValueSetter buildOfferBillEntry(DynamicObject[] offerApproveArray, Map<Long, String> map) {
        log.info("OfferApprovalFormBizHelper.getOfferApprovalFormEntry.approve:[{}]", map);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject dy : offerApproveArray) {
            DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(dy);
            vs.set("name", (Object)offer.getString("name"), index);
            log.info("OfferApprovalFormBizHelper.buildOfferBillEntry.name:[{}]", (Object)offer.getString("name"));
            vs.set("number", (Object)dy.getString("billno"), index);
            log.info("OfferApprovalFormBizHelper.buildOfferBillEntry.number:[{}]", (Object)dy.getString("billno"));
            String status = dy.getString("billstatus");
            vs.set("status", (Object)status, index);
            DynamicObject applicant = dy.getDynamicObject("applicant");
            if (Objects.nonNull(applicant)) {
                vs.set("applicant", (Object)applicant.getLong("id"), index);
            }
            if (dy.getDate("applytime") != null) {
                vs.set("applytime", (Object)HRInteDateTimeUtil.formatDate((String)"tso_somk_offerapproveinfo", (String)"applytime", (Date)dy.getDate("applytime")), index);
            }
            String approve = map.get(dy.getLong("id"));
            vs.set("approve", (Object)approve, index);
            vs.set("billid", (Object)dy.getLong("id"), index);
            ++index;
        }
        return vs;
    }
}

