/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.AesKeyStrength;
import kd.bos.zip.model.enums.EncryptionMethod;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.ZipFileWithPwdHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferAttachmentHelper {
    private static final Log logger = LogFactory.getLog(OfferAttachmentHelper.class);
    private static final Pattern COMPILE = Pattern.compile("\\(\\d+\\)");
    private static final int CAPACITY = 4096;
    private static final String DOWNLOAD_URL = "/attachment/download.do?path=";

    private OfferAttachmentHelper() {
    }

    public static OfferAttachmentHelper getInstance() {
        return Instance.ATTACH_INSTANCE;
    }

    public DynamicObject[] getAttachInfoFromBosAttach(Long pkId, String entityId, String ... selectProperties) {
        HRBaseServiceHelper bosAttachmentHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter qFilterPkId = new QFilter("finterid", "=", (Object)String.valueOf(pkId));
        QFilter qFilterBillType = new QFilter("fbilltype", "=", (Object)entityId);
        if (selectProperties.length == 0) {
            selectProperties[0] = "id";
        }
        List<String> list = Arrays.asList(selectProperties);
        DynamicObject[] attachments = bosAttachmentHelper.query(Joiner.on((char)',').skipNulls().join(list), new QFilter[]{qFilterBillType, qFilterPkId});
        return attachments;
    }

    private void saveAttachmentInfoToBasAttachment(String path, Long offerId, String fileNameWithExt, String fileSize) {
        ORM orm = ORM.create();
        Date today = DateUtils.nowDateTime();
        DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
        long id = orm.genLongId("bos_attachment");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("FNUMBER", (Object)"uid");
        dynamicObject.set("FBillType", (Object)"tso_offerletter");
        dynamicObject.set("FInterID", (Object)offerId);
        dynamicObject.set("FModifyTime", (Object)today);
        dynamicObject.set("fcreatetime", (Object)today);
        dynamicObject.set("FaliasFileName", (Object)fileNameWithExt);
        dynamicObject.set("FAttachmentName", (Object)fileNameWithExt);
        dynamicObject.set("FExtName", (Object)"zip");
        dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
        dynamicObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel_offerletter");
        dynamicObject.set("fdescription", (Object)fileNameWithExt);
        dynamicObject.set("FFileId", (Object)path);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        logger.info("saveToFile success: {}", (Object)save.length);
    }

    private void savePdfAttachmentInfoToBasAttachment(String path, Long offerId, String fileNameWithExt, String fileSize) {
        ORM orm = ORM.create();
        Date today = DateUtils.nowDateTime();
        DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
        long id = orm.genLongId("bos_attachment");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("FNUMBER", (Object)"uid");
        dynamicObject.set("FBillType", (Object)"tso_offerletter");
        dynamicObject.set("FInterID", (Object)offerId);
        dynamicObject.set("FModifyTime", (Object)today);
        dynamicObject.set("fcreatetime", (Object)today);
        dynamicObject.set("FaliasFileName", (Object)fileNameWithExt);
        dynamicObject.set("FAttachmentName", (Object)fileNameWithExt);
        dynamicObject.set("FExtName", (Object)"pdf");
        dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
        dynamicObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel_offerletter");
        dynamicObject.set("fdescription", (Object)fileNameWithExt);
        dynamicObject.set("FFileId", (Object)path);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        logger.info("saveToFile success: {}", (Object)save.length);
    }

    public ByteArrayOutputStream getZipFileStream(DynamicObject dataEntity, DynamicObject[] bosAttachmentObjs, InputStream pdfInputStream) throws IOException {
        boolean isSendPdf = dataEntity.getBoolean("isgtannex");
        String verifyCode = dataEntity.getString("verifycode");
        boolean isEpAnnex = dataEntity.getBoolean("isepannex");
        ZipParameters parameters = this.getZipParameters(isEpAnnex);
        HashMap nameAndStreamMap = Maps.newHashMapWithExpectedSize((int)(bosAttachmentObjs.length + 1));
        if (isSendPdf) {
            nameAndStreamMap.put(ResManager.loadKDString((String)"\u5f55\u7528\u901a\u77e5\u4e66", (String)"OfferAttachmentHelper_0", (String)"tsc-tso-business", (Object[])new Object[0]) + ".pdf", pdfInputStream);
        }
        for (int i = 0; i < bosAttachmentObjs.length; ++i) {
            String url = bosAttachmentObjs[i].getString("ffileid");
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = fileService.getInputStream(url);
            String[] urlArr = url.split("/");
            String fileName = urlArr[urlArr.length - 1];
            fileName = this.getFinalFileName(nameAndStreamMap, fileName);
            nameAndStreamMap.put(fileName, inputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        ZipFileWithPwdHelper.INSTANCE.getZipOutputStream(byteArrayOutputStream, nameAndStreamMap, parameters, String.valueOf(verifyCode).toCharArray(), isEpAnnex);
        return byteArrayOutputStream;
    }

    private String getFinalFileName(Map<String, InputStream> nameAndStreamMap, String fileName) {
        while (true) {
            int dotIndex = fileName.lastIndexOf(46);
            String fileNameWithoutExt = fileName.substring(0, dotIndex);
            String fileExt = fileName.substring(dotIndex);
            if (!nameAndStreamMap.containsKey(fileName)) break;
            if (fileNameWithoutExt.length() < 3) {
                fileName = fileNameWithoutExt + "(" + 1 + ")" + fileExt;
                break;
            }
            String hasRepeatName = fileNameWithoutExt.substring(dotIndex - 3, dotIndex);
            Matcher matcher = COMPILE.matcher(hasRepeatName);
            if (matcher.find()) {
                int repeatTime = Integer.parseInt(hasRepeatName.substring(1, 2));
                fileNameWithoutExt = fileNameWithoutExt.replace(hasRepeatName, "(" + ++repeatTime + ")");
            } else {
                fileNameWithoutExt = fileNameWithoutExt + "(" + 1 + ")";
            }
            fileName = fileNameWithoutExt + fileExt;
        }
        return fileName;
    }

    private String getFileNameWithExt(DynamicObject offerInfo) {
        String candidateName = offerInfo.getString("candidatename");
        return ResManager.loadKDString((String)"Offer Letter", (String)"OfferAttachmentHelper_0", (String)"tsc-tso-business", (Object[])new Object[0]) + "(" + candidateName + ").zip";
    }

    private String getPdfFileNameWithExt(DynamicObject offerInfo) {
        String candidateName = offerInfo.getString("candidatename");
        return ResManager.loadKDString((String)"Offer Letter", (String)"OfferAttachmentHelper_0", (String)"tsc-tso-business", (Object[])new Object[0]) + "(" + candidateName + ").pdf";
    }

    private String getFilePathParam(Long offerId, String zipFileNameWithExt) {
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)"tsc", (String)"tso_offerletter", (Object)offerId, (String)zipFileNameWithExt);
        return pathParam;
    }

    public void pdfUpLoadFile(DynamicObject dataEntity, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        String verifyCode = dataEntity.getString("verifycode");
        boolean isEpAnnex = dataEntity.getBoolean("isepannex");
        if (isEpAnnex) {
            logger.info("pdfUpLoadFile.pdfReader");
            PdfReader reader = new PdfReader(byteArrayOutputStream.toByteArray());
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)byteArrayOutputStream);
            stamper.setEncryption(verifyCode.getBytes(), verifyCode.getBytes(), 0, 2);
            reader.close();
            stamper.close();
        }
        long letterId = dataEntity.getLong("letterid");
        this.deleteOldDataIfExist(letterId);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        long offerId = dataEntity.getLong("offerid");
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne("candidatename", offerId);
        String pdfFileNameWithExt = this.getPdfFileNameWithExt(offerInfo);
        String pathParam = this.getFilePathParam(letterId, pdfFileNameWithExt);
        FileItem fileItem = new FileItem(pdfFileNameWithExt, pathParam, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        fileItem.setCreateNewFileWhenExists(false);
        String path = fileService.upload(fileItem);
        this.savePdfAttachmentInfoToBasAttachment(path, letterId, pdfFileNameWithExt, String.valueOf(byteArrayOutputStream.toByteArray().length));
    }

    public void upLoadFile(DynamicObject dataEntity, ByteArrayOutputStream byteArrayOutputStream) {
        long letterId = dataEntity.getLong("letterid");
        this.deleteOldDataIfExist(letterId);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        long offerId = dataEntity.getLong("offerid");
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne("candidatename", offerId);
        String zipFileNameWithExt = this.getFileNameWithExt(offerInfo);
        String pathParam = this.getFilePathParam(letterId, zipFileNameWithExt);
        FileItem fileItem = new FileItem(zipFileNameWithExt, pathParam, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        fileItem.setCreateNewFileWhenExists(false);
        String path = fileService.upload(fileItem);
        this.saveAttachmentInfoToBasAttachment(path, letterId, zipFileNameWithExt, String.valueOf(byteArrayOutputStream.toByteArray().length));
    }

    public void mokaUpLoadFile(DynamicObject offer, ByteArrayOutputStream byteArrayOutputStream) {
        long letterId = offer.getLong("offerletter.id");
        this.deleteOldDataIfExist(letterId);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        long offerId = offer.getLong("id");
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne("candidatename", offerId);
        String pdfFileNameWithExt = this.getPdfFileNameWithExt(offerInfo);
        String pathParam = this.getFilePathParam(letterId, pdfFileNameWithExt);
        FileItem fileItem = new FileItem(pdfFileNameWithExt, pathParam, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        fileItem.setCreateNewFileWhenExists(false);
        String path = fileService.upload(fileItem);
        this.saveAttachmentInfoToBasAttachment(path, letterId, pdfFileNameWithExt, String.valueOf(byteArrayOutputStream.toByteArray().length));
    }

    public void deleteOldDataIfExist(Long offerId) {
        DynamicObject[] offerLetterAttachObjs = this.getAttachInfoFromBosAttach(offerId, "tso_offerletter", "ffileid");
        if (offerLetterAttachObjs != null && offerLetterAttachObjs.length > 0) {
            ArrayList<Long> offerLetterPkIds = new ArrayList<Long>(offerLetterAttachObjs.length);
            for (int i = 0; i < offerLetterAttachObjs.length; ++i) {
                offerLetterPkIds.add(offerLetterAttachObjs[i].getLong("id"));
            }
            HRBaseServiceHelper bosAttachmentHelper = new HRBaseServiceHelper("bos_attachment");
            bosAttachmentHelper.delete(offerLetterPkIds.toArray());
            AttachmentServiceHelper.remove((String)"tso_offerletter", (Object)offerId, (Object)"uid");
        }
    }

    private ZipParameters getZipParameters(Boolean isEpAnnex) {
        ZipParameters parameters = new ZipParameters();
        if (isEpAnnex.booleanValue()) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.AES);
            parameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        }
        return parameters;
    }

    private static class Instance {
        private static OfferAttachmentHelper ATTACH_INSTANCE = new OfferAttachmentHelper();

        private Instance() {
        }
    }
}

