/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferBillServiceHelper
extends HRBaseServiceHelper {
    public OfferBillServiceHelper(String entityName) {
        super(entityName);
    }

    public static OfferBillServiceHelper getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject generateNewOfferBillDt(DynamicObject offerBaseInfo) {
        DynamicObject dynamicObject = this.generateEmptyDynamicObject();
        HashSet ignoreKeys = Sets.newHashSet((Object[])new String[]{"number"});
        HRDynamicObjectUtils.copy((DynamicObject)offerBaseInfo, (DynamicObject)dynamicObject, (Set)ignoreKeys);
        OfferUtils.updateOperateInfo((DynamicObject)dynamicObject);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
        DynamicObject dt = new DynamicObject(dynamicObjectType);
        dt.set("offer", (Object)offerBaseInfo);
        dynamicObjectCollection.add((Object)dt);
        dynamicObject.set("billstatus", (Object)OfferAuditStatus.ALR_SUBMIT.getCode());
        dynamicObject.set("applicant", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("applytime", (Object)DateUtils.nowDateTime());
        dynamicObject.set("busunit", offerBaseInfo.get("busunit"));
        String offerBillNo = CodeRuleServiceHelper.getNumber((String)"tso_somk_offerbill", (DynamicObject)dynamicObject, null);
        dynamicObject.set("billno", (Object)offerBillNo);
        return dynamicObject;
    }

    public void saveOfferBill(DynamicObject offerBillDt) {
        this.saveOne(offerBillDt);
    }

    public void updateOfferBill(DynamicObject offerBillDt) {
        this.updateOne(offerBillDt);
    }

    public DynamicObject queryByOfferId(Long offerId) {
        QFilter qFilter = new QFilter("entryentity.offer", "=", (Object)offerId).and(new QFilter("deletestatus", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"billstatus", "applycontent", "applytime", "applicant", "busunit", "entryentity.offer", "modifytime", "modifier", "billno"});
        return this.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject[] queryByOfferIdList(List<Long> offerIdList) {
        QFilter qFilter = new QFilter("entryentity.offer", "in", offerIdList);
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"billstatus", "appfile", "applycontent", "applytime", "applicant", "busunit", "modifytime", "modifier", "billno"});
        return this.query(selectProperties, qFilter.toArray());
    }

    public DynamicObject getOfferByBillDt(DynamicObject offerBillDt) {
        DynamicObjectCollection entryEntity = offerBillDt.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            throw new KDBizException("OfferBill's entryEntity cannot be null");
        }
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        DynamicObject offer = dynamicObject.getDynamicObject("offer");
        if (HRObjectUtils.isEmpty((Object)offer)) {
            String billNo = offerBillDt.getString("billno");
            QFilter qFilter = new QFilter("offerauditno", "=", (Object)billNo);
            DynamicObject dy = OfferServiceHelper.getInstance().loadDynamicObject(new QFilter[]{qFilter});
            if (HRObjectUtils.isEmpty((Object)dy)) {
                throw new KDBizException("Offer cannot be null");
            }
            return dy;
        }
        return OfferServiceHelper.getInstance().queryOne(offer.getLong("id"));
    }

    public DynamicObject[] getBillByOfferId(Long offerId) {
        QFilter qFilter = new QFilter("entryentity.offer", "=", (Object)offerId).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("deletestatus", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"offer", "billstatus", "appfile", "applycontent", "applytime", "applicant", "busunit", "modifytime", "modifier", "billno"});
        return this.query(selectProperties, qFilter.toArray(), "createtime desc");
    }

    public DynamicObject queryOneByAuditNo(String auditNo, String selectProperties) {
        QFilter filter = new QFilter("billno", "=", (Object)auditNo);
        return this.queryOne(selectProperties, filter);
    }

    private static class Instance {
        private static final OfferBillServiceHelper INSTANCE = new OfferBillServiceHelper("tso_somk_offerapproveinfo");

        private Instance() {
        }
    }
}

