/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferEditMutexHelper {
    private static final String ENTITY_ID = "tso_somk_offerbase";
    private static final String OPERATE_KEY = "edit";
    private static final String MUTEX_OPERATE_KEY = "operationkey";
    private static final String MUTEX_ENTITY_ID = "entitykey";
    private static final String MUTEX_PK_ID = "objectid";
    private static final String MUTEX_DATA_LOCK_USER = "user";

    public static boolean requireMutex(Long offerId, StringBuilder stringBuilder) {
        boolean requireMutex = TscMutexHelper.requireMutex((String)ENTITY_ID, (Object)offerId, (String)OPERATE_KEY, (StringBuilder)stringBuilder);
        return requireMutex;
    }

    public static boolean requireMutex(IFormView formView, Long offerId, StringBuilder stringBuilder) {
        return TscMutexHelper.requireMutex((IFormView)formView, (String)formView.getEntityId(), (Object)offerId, (String)OPERATE_KEY, (StringBuilder)stringBuilder);
    }

    public static void releaseMutex(Long offerId) {
        TscMutexHelper.releaseMutex((String)ENTITY_ID, (Long)offerId, (String)OPERATE_KEY);
    }

    public static void releaseMutex(IFormView formView, Long pkId) {
        TscMutexHelper.releaseMutex((String)formView.getEntityId(), (Long)pkId, (String)OPERATE_KEY);
    }

    public static void releaseMutex(IFormView formView) {
        TscMutexHelper.releaseMutex((IFormView)formView);
    }

    public static void releaseMutexIfIsCurrentUser(Long offerId) {
        if (OfferEditMutexHelper.currentUserHasMutex(offerId)) {
            OfferEditMutexHelper.releaseMutex(offerId);
        }
    }

    public static void releaseMutexIfIsCurrentUser(IFormView formView, Long pkId) {
        if (OfferEditMutexHelper.currentUserHasMutex(formView, pkId)) {
            OfferEditMutexHelper.releaseMutex(formView);
        }
    }

    public static DynamicObject[] checkOfferIsEditing(List<Long> offerIdList) {
        DynamicObject[] dynamicObjects = TscMutexHelper.checkHasMutex((String)ENTITY_ID, offerIdList, (String)OPERATE_KEY);
        return dynamicObjects;
    }

    public static boolean currentUserHasMutex(Long offerId) {
        QFilter operateKeyFilter = new QFilter(MUTEX_OPERATE_KEY, "=", (Object)OPERATE_KEY);
        QFilter entityKeyFilter = new QFilter(MUTEX_ENTITY_ID, "=", (Object)ENTITY_ID);
        QFilter objectIdFilter = new QFilter(MUTEX_PK_ID, "=", (Object)String.valueOf(offerId));
        QFilter userFilter = new QFilter(MUTEX_DATA_LOCK_USER, "=", (Object)TSCRequestContext.getUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public static boolean currentUserHasMutex(IFormView formView, Long pkId) {
        QFilter operateKeyFilter = new QFilter(MUTEX_OPERATE_KEY, "=", (Object)OPERATE_KEY);
        QFilter entityKeyFilter = new QFilter(MUTEX_ENTITY_ID, "=", (Object)formView.getEntityId());
        QFilter objectIdFilter = new QFilter(MUTEX_PK_ID, "=", (Object)String.valueOf(pkId));
        QFilter userFilter = new QFilter(MUTEX_DATA_LOCK_USER, "=", (Object)TSCRequestContext.getUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }
}

