/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;

public class OfferFieldEditSwitchHelper {
    private static final String FIELDENABLE_FIELDID = "displaycontrol";
    private static final Log log = LogFactory.getLog(OfferFieldEditSwitchHelper.class);
    public static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tso_offerfieswit");

    public JSONObject queryFieldEnableJsonByOfferId(Long offerId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tso_offerfieswit");
        QFilter qFilter = new QFilter("offer", "=", (Object)offerId);
        DynamicObject fieldEnableObj = helper.queryOne(FIELDENABLE_FIELDID, qFilter.toArray());
        if (Objects.isNull(fieldEnableObj)) {
            return null;
        }
        String fieldSrcJson = fieldEnableObj.getString(FIELDENABLE_FIELDID);
        JSONObject fieldSrcJsonObj = JSONObject.parseObject((String)fieldSrcJson);
        return fieldSrcJsonObj;
    }

    public OfferFieldEnableEnum getInfoFormCache(IFormView formView, String key) {
        String str = formView.getPageCache().get("fieldSwitchCacheKey");
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        if (jsonObject == null) {
            return null;
        }
        String string = jsonObject.getString(key);
        if (string.equals("1")) {
            return OfferFieldEnableEnum.NOT_ENABLE;
        }
        if (string.equals("0")) {
            return OfferFieldEnableEnum.ENABLE;
        }
        return null;
    }

    public void updateFieldSwitch(IFormView offerBaseView, Long offerId) {
        String fieldSwitchInfo = offerBaseView.getPageCache().get("fieldSwitchCacheKey");
        log.info("OfferFieldEditSwitchHelper.updateFieldSwitch-offerId\uff1a{}\uff0cfieldSwitchInfo\uff1a{}", (Object)offerId, (Object)fieldSwitchInfo);
        if (HRStringUtils.isEmpty((String)fieldSwitchInfo)) {
            return;
        }
        if (offerBaseView.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            DynamicObject fieldEditObj = HELPER.generateEmptyDynamicObject();
            fieldEditObj.set("pagekey", (Object)"tso_somk_offerbase");
            fieldEditObj.set(FIELDENABLE_FIELDID, (Object)fieldSwitchInfo);
            fieldEditObj.set("offer", (Object)offerId);
            HELPER.saveOne(fieldEditObj);
            return;
        }
        this.updateOfferFieldSrcByOfferId("tso_somk_offerbase", offerId, fieldSwitchInfo);
    }

    public void updateOfferFieldSrcByOfferId(String entityId, Long offerId, String fieldEnableJson) {
        String updateSql = "update T_TSO_OFFERFIESWIT set FDISPLAYCONT = ? where FOFFERID = ? and FPAGEKEY = ?";
        HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])new Object[]{fieldEnableJson, offerId, entityId});
    }

    public void insert(long offerId, String fieldSwitchInfo) {
        DynamicObject fieldSwitch = HELPER.generateEmptyDynamicObject();
        fieldSwitch.set(FIELDENABLE_FIELDID, (Object)fieldSwitchInfo);
        fieldSwitch.set("offer", (Object)offerId);
        fieldSwitch.set("pagekey", (Object)"tso_somk_offerbase");
        HELPER.saveOne(fieldSwitch);
    }

    public void updateFieldSrcToPageCache(OfferFieldEnableEnum enableEnum, IFormView formView, String ... controlIds) {
        this.updateFieldSrc(enableEnum, formView, controlIds);
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        if (formShowParameter.getStatus() == OperationStatus.VIEW) {
            return;
        }
        IPageCache pageCache = formView.getPageCache();
        String fieldSrcObjStr = pageCache.get("fieldSwitchCacheKey");
        if (HRStringUtils.isEmpty((String)fieldSrcObjStr)) {
            return;
        }
        JSONObject fieldSrcObj = JSONObject.parseObject((String)fieldSrcObjStr);
        for (String controlId : controlIds) {
            fieldSrcObj.put(controlId, (Object)enableEnum.ordinal());
        }
        pageCache.put("fieldSwitchCacheKey", fieldSrcObj.toJSONString());
    }

    private void updateFieldSrc(OfferFieldEnableEnum enableEnum, IFormView formView, String ... controlIds) {
        if (OfferFieldEnableEnum.ENABLE == enableEnum) {
            formView.setEnable(Boolean.TRUE, controlIds);
        } else {
            formView.setEnable(Boolean.FALSE, controlIds);
        }
    }

    public static OfferFieldEditSwitchHelper getInstance() {
        return Instance.FIELDENABLEHELPER_INSTANCE;
    }

    private OfferFieldEditSwitchHelper() {
    }

    private static class Instance {
        private static OfferFieldEditSwitchHelper FIELDENABLEHELPER_INSTANCE = new OfferFieldEditSwitchHelper();

        private Instance() {
        }
    }
}

