/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferLetterRecordHelper
extends HRBaseServiceHelper {
    private static final Log logger = LogFactory.getLog(OfferLetterRecordHelper.class);

    public OfferLetterRecordHelper(String entityName) {
        super(entityName);
    }

    public static OfferLetterRecordHelper getInstance() {
        return OfferLetterRecordHelperHolder.OFFERLETTERRECORDHELPER;
    }

    public void setLetterRecordByOfferLetter(DynamicObject offerLetterRecord) {
        long userId = TSCRequestContext.getUserId();
        if (offerLetterRecord == null) {
            logger.error("param offerLetterRecord is null");
            return;
        }
        offerLetterRecord.set("senduser", (Object)userId);
        long offerLetterId = offerLetterRecord.getLong("offerletter_id");
        if (offerLetterId != 0L) {
            logger.error("there is not available offerLetterId");
            return;
        }
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne(offerLetterId);
        offerLetterRecord.set("validtime", (Object)offerLetter.getDate("validtime"));
        DynamicObject appfile = offerLetter.getDynamicObject("appfile");
        offerLetterRecord.set("appfile", (Object)appfile);
        offerLetterRecord.set("sendemail", (Object)Optional.of(appfile.getString("email")).orElse(""));
        offerLetterRecord.set("offerletter", (Object)offerLetter);
        offerLetterRecord.set("template", offerLetter.get("template"));
        offerLetterRecord.set("lettercontent_tag", offerLetter.get("lettercontent_tag"));
    }

    private static class OfferLetterRecordHelperHolder {
        private static final OfferLetterRecordHelper OFFERLETTERRECORDHELPER = new OfferLetterRecordHelper("tso_offerletterrecord");

        private OfferLetterRecordHelperHolder() {
        }
    }
}

