/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.web.util.DateUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferLetterServiceHelper
extends HRBaseServiceHelper {
    public OfferLetterServiceHelper(String entityName) {
        super(entityName);
    }

    public static OfferLetterServiceHelper getInstance() {
        return Instance.LETTER_INSTANCE;
    }

    public String getLetterAttachName(Long offerLetterId) {
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne(offerLetterId);
        DynamicObject offer = offerLetter.getDynamicObject("offer");
        String name = offer.getString("candidatename");
        return ResManager.loadKDString((String)"Offer Letter", (String)"OfferAttachmentHelper_0", (String)"tsc-tso-business", (Object[])new Object[0]) + "(" + name + ")";
    }

    public String getLetterAttachNameWithExt(Long letterId) {
        String ext = ".zip";
        return this.getLetterAttachName(letterId) + ext;
    }

    public DynamicObject generateNewOfferLetter(DynamicObject offerInfo) {
        DynamicObject letter = this.generateEmptyDynamicObject();
        letter.set("id", (Object)ID.genLongId());
        letter.set("offer", (Object)offerInfo.getLong("id"));
        letter.set("appfile", (Object)offerInfo.getDynamicObject("appfile").getLong("id"));
        letter.set("name", (Object)(offerInfo.getString("candidatename") + OfferMultilingualConstants.getOfferLetterNameSuffix()));
        String letterNo = CodeRuleServiceHelper.getNumber((String)"tso_offerletter", (DynamicObject)letter, null);
        letter.set("billno", (Object)letterNo);
        letter.set("letterstatus", (Object)OfferLetterStatus.PRE_SEND.getCode());
        DynamicObject templateDy = offerInfo.getDynamicObject("template");
        if (!HRObjectUtils.isEmpty((Object)templateDy)) {
            letter.set("datastatus", (Object)OfferLetterDataStatus.DEFAULT.getCode());
        }
        int lastSendTimeConfig = OfferParamConfigService.getInstance().getLastSendTimeConfig();
        letter.set("lastsendtime", (Object)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getNowDateTime(), (long)lastSendTimeConfig));
        if (!HRObjectUtils.isEmpty((Object)offerInfo.getDynamicObject("template"))) {
            letter.set("template", (Object)offerInfo.getDynamicObject("template").getLong("id"));
        }
        String letterContent = OfferAttachmentService.getInstance().generateLetterContent(Boolean.TRUE, offerInfo);
        letter.set("lettercontent_tag", (Object)letterContent);
        letter.set("isgtannex", (Object)"1");
        letter.set("isepannex", (Object)"1");
        OfferUtils.updateOperateInfo((DynamicObject)letter);
        return letter;
    }

    public String getLetterSelectProperties() {
        return OfferUtils.getSelectProperties((String[])new String[]{"letterstatus", "offer", "datastatus", "replystatus", "delaydesc", "lastreplytime", "lastsendtime", "validtime", "delaydesc", "changevaliddesc", "abandondesc", "rejectdesc", "modifytime", "modifier", "abandonreason", "abandontime", "rejectreason", "sendtime", "senduser", "appfile", "lettercontent_tag", "lastreasonsign", "replytime"});
    }

    public void updateOfferLetterWhenSuccess(Long offerLetterId, boolean isAudit) {
        DynamicObject offerLetter = this.queryOne("id,lastsendtime,letterstatus.id,datastatus.id", offerLetterId);
        offerLetter.set("lastsendtime", (Object)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getNowDateTime(), (long)OfferParamConfigService.getInstance().getLastSendTimeConfig()));
        if (isAudit) {
            offerLetter.set("letterstatus", (Object)OfferLetterStatus.PRE_SEND.getCode());
            offerLetter.set("datastatus", (Object)OfferLetterDataStatus.DEFAULT.getCode());
        }
        this.updateDataOne(offerLetter);
    }

    public long checkValidDay(Date validtime) {
        if (validtime == null) {
            return -1L;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        validtime = DateUtil.str2Date((String)dateFormat.format(validtime), (String)"yyyy-MM-dd");
        Date nowDate = Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        return (validtime.getTime() - nowDate.getTime()) / 86400000L;
    }

    private static class Instance {
        private static final OfferLetterServiceHelper LETTER_INSTANCE = new OfferLetterServiceHelper("tso_offerletter");

        private Instance() {
        }
    }
}

