/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.service.OfferBtnShowService;

public class OfferOnlyViewHelper {
    private static final String PARAM_IS_ONLY_VIEW_KEY = "isOnlyView";
    private static final String PARAM_IS_ONLY_VIEW_VALUE = "1";

    public static boolean checkIsOnlyView(FormShowParameter formShowParameter) {
        Object isOnlyViewObj = formShowParameter.getCustomParam(PARAM_IS_ONLY_VIEW_KEY);
        if (Objects.isNull(isOnlyViewObj)) {
            return false;
        }
        return HRStringUtils.equals((String)PARAM_IS_ONLY_VIEW_VALUE, (String)isOnlyViewObj.toString());
    }

    public static void onlyViewForHeadInfo(IFormView headInfoView) {
        IFormView parentView = headInfoView.getParentView();
        if (parentView == null) {
            return;
        }
        if (OfferOnlyViewHelper.checkIsOnlyView(parentView.getFormShowParameter())) {
            HashMap<String, Object> ctrl = new HashMap<String, Object>();
            ctrl.put("fc", "");
            ctrl.put("clickable", Boolean.FALSE);
            headInfoView.updateControlMetadata("name", ctrl);
        }
    }

    public static void onlyViewForApprovalTab(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return;
        }
        if (OfferOnlyViewHelper.checkIsOnlyView(parentView.getFormShowParameter())) {
            HashMap<String, Boolean> panelCtrl = new HashMap<String, Boolean>();
            panelCtrl.put("clickable", Boolean.FALSE);
            formView.updateControlMetadata("numpanel", panelCtrl);
            HashMap<String, String> numberCtrl = new HashMap<String, String>();
            numberCtrl.put("bc", "");
            formView.updateControlMetadata("number", numberCtrl);
        }
    }

    public static void initButtonVisible(IFormView formView) {
        String entityId = formView.getEntityId();
        List<Object> allButtons = new ArrayList(0);
        if (entityId.equals("tso_offerbase_info")) {
            allButtons = OfferBtnShowService.allButtonForBase();
        }
        if (entityId.equals("tso_offerbillinfo")) {
            allButtons = OfferBtnShowService.allButtonForBill();
        }
        formView.setVisible(Boolean.TRUE, new String[]{"bar_close"});
        allButtons.removeIf("bar_close"::equals);
        formView.setVisible(Boolean.FALSE, allButtons.toArray(new String[0]));
    }
}

