/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.ControlledDataCommonHelper;

public class OfferQFilterHelper {
    private static final Log logger = LogFactory.getLog(OfferQFilterHelper.class);

    private OfferQFilterHelper() {
    }

    public static QFilter getValidAndAuditFilter() {
        return new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"));
    }

    public static QFilter getPePositionFilter() {
        QFilter validAndAuditFilter = OfferQFilterHelper.getValidAndAuditFilter();
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tso", (String)"tso_somk_offerbase", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"adminorg");
        if (userAdminOrgFilter != null) {
            validAndAuditFilter.and(userAdminOrgFilter);
            logger.info("OfferQFilterHelper.getPePositionFilter.userAdminOrgFilter: {}", (Object)userAdminOrgFilter.toString());
        }
        return validAndAuditFilter;
    }

    public static QFilter getPeAdminorgFilter() {
        QFilter validAndAuditFilter = OfferQFilterHelper.getValidAndAuditFilter();
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tso", (String)"tso_somk_offerbase", (String)"47150e89000000ac", (String)"peadminorg", Collections.emptyMap(), (String)"id");
        if (userAdminOrgFilter != null) {
            validAndAuditFilter.and(userAdminOrgFilter);
            logger.info("OfferQFilterHelper.getPeAdminorgFilter.userAdminOrgFilter: {}", (Object)userAdminOrgFilter.toString());
        }
        return validAndAuditFilter;
    }

    public static QFilter getPeCompanyFilter() {
        QFilter validAndAuditFilter = OfferQFilterHelper.getValidAndAuditFilter();
        validAndAuditFilter.and(new QFilter("adminorgtype.id", "in", (Object)"1020,1010"));
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tso", (String)"tso_somk_offerbase", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"id");
        if (userAdminOrgFilter != null) {
            validAndAuditFilter.and(userAdminOrgFilter);
            logger.info("OfferQFilterHelper.getPeCompanyFilter.userAdminOrgFilter: {}", (Object)userAdminOrgFilter.toString());
        }
        return validAndAuditFilter;
    }

    public static QFilter getPositionTypeFilter() {
        QFilter qFilter = new QFilter("issyspreset", "=", (Object)"1");
        qFilter.and(OfferQFilterHelper.getValidAndAuditFilter());
        return qFilter;
    }

    public static List<QFilter> getJobScmFilter(Long orgId) {
        List qFilters = ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"hbpm", (String)"hbjm_jobscmhr", (Long)orgId);
        return qFilters;
    }

    public static List<QFilter> getPeJobFilter(Long orgId) {
        List qFilters = ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"hbpm", (String)"hbjm_jobscmhr", (Long)orgId);
        return qFilters;
    }

    public static QFilter getEmpRelationTypeFilter(List<Long> ids) {
        return new QFilter("id", "in", ids);
    }

    public static QFilter getOfferReplyStatusFilter() {
        QFilter replyStatusFilter = new QFilter("group.number", "=", (Object)"1040_S");
        return replyStatusFilter;
    }

    public static QFilter getOfferLetterDataStatusFilter() {
        QFilter dataStatusFilter = new QFilter("group.id", "=", (Object)1030L);
        return dataStatusFilter;
    }

    public static QFilter getOfferLetterStatusFilter() {
        QFilter replyStatusFilter = new QFilter("group.number", "=", (Object)"1020_S");
        return replyStatusFilter;
    }

    public static List<QFilter> getTssrmFirstPageFilter(String timeRangeType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        ArrayList<String> auditStatusList = new ArrayList<String>(3);
        auditStatusList.add(OfferAuditStatus.ALR_SUBMIT.getCode());
        auditStatusList.add(OfferAuditStatus.WAIT_RESUBMIT.getCode());
        auditStatusList.add(OfferAuditStatus.AUDITING.getCode());
        QFilter auditStatusFilter = new QFilter("tso_offerbill.auditstatus", "in", auditStatusList);
        qFilters.add(auditStatusFilter);
        QFilter applicantFilter = new QFilter("applicant", "=", (Object)TSCRequestContext.getUserId());
        qFilters.add(applicantFilter);
        return qFilters;
    }

    public static QFilter mineCreateOfferFilter() {
        return new QFilter("applicant", "=", (Object)TSCRequestContext.getUserId());
    }
}

