/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.AbstractOfferBaseServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferServiceHelper
extends AbstractOfferBaseServiceHelper {
    private static final Log logger = LogFactory.getLog(OfferServiceHelper.class);

    public OfferServiceHelper(String entityName) {
        super(entityName);
    }

    public static OfferServiceHelper getInstance() {
        return Instance.OFFER_INSTANCE;
    }

    public DynamicObject[] getMappingEmpRelationType(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborreltype");
        QFilter qFilter = new QFilter("laborreltypecls.id", "=", (Object)id);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] queryOfferByIdList(List<Long> offerIdList, String selectProperties) {
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        DynamicObject[] offerInfos = this.query(selectProperties, qFilter.toArray());
        return offerInfos;
    }

    public DynamicObject queryOfferInfoById(String selectProperties, Long offerId) {
        DynamicObject offerInfo = this.queryOne(selectProperties, offerId);
        return offerInfo;
    }

    public DynamicObject queryAppFileByOfferId(Long offerId) {
        QFilter qFilter = new QFilter("id", "=", (Object)offerId);
        DynamicObject offerInfo = this.queryOne("id,appfile", qFilter);
        if (HRObjectUtils.isEmpty((Object)offerInfo)) {
            return null;
        }
        return offerInfo.getDynamicObject("appfile");
    }

    public Map<Long, List<DynamicObject>> queryAbandonOfferByAppFileIds(String fields, List<Long> appFileIdList) {
        if (CollectionUtils.isEmpty(appFileIdList)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        if (HRStringUtils.isEmpty((String)fields)) {
            fields = "id";
        }
        QFilter appFileFilter = new QFilter("appfile", "in", appFileIdList);
        QFilter statusFilter = new QFilter("offerletter.datastatus", "=", (Object)OfferLetterDataStatus.INVALID.getCode());
        QFilter isNotDeleteFilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        DynamicObject[] offerInfos = this.query(fields, new QFilter[]{appFileFilter, statusFilter, isNotDeleteFilter}, "modifytime DESC", 1);
        return Arrays.stream(offerInfos).collect(Collectors.groupingBy(offerInfo -> offerInfo.getDynamicObject("appfile").getLong("id")));
    }

    public void updateOffer(DynamicObject[] offerInfos) {
        this.update(offerInfos);
    }

    public Map<Long, List<DynamicObject>> checkHasOldOfferWhenDelete(DynamicObject[] offerInfos) {
        if (offerInfos == null || offerInfos.length <= 0) {
            throw new IllegalStateException("checkHasOldOfferWhenDelete.offerInfos have not value");
        }
        ArrayList<Long> appFileIdList = new ArrayList<Long>(offerInfos.length);
        for (DynamicObject offerInfo : offerInfos) {
            appFileIdList.add(offerInfo.getDynamicObject("appfile").getLong("id"));
        }
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"appfile", "status", "offerletter"});
        return this.queryAbandonOfferByAppFileIds(selectProperties, appFileIdList);
    }

    public void setControlToNull(IDataModel dataModel, String ... controlIds) {
        if (controlIds.length == 0) {
            return;
        }
        for (int i = 0; i < controlIds.length; ++i) {
            if (dataModel.getValue(controlIds[i]) == null) continue;
            dataModel.setValue(controlIds[i], null);
        }
    }

    public DynamicObject getOfferById(Long offerId) {
        return this.loadSingle(offerId);
    }

    public DynamicObject getOfferLetterById(Long offerId) {
        String selectFields = "appfile.filestatus,offerletter.letterstatus,offerletter";
        return this.queryOriginalOne(selectFields, offerId);
    }

    public DynamicObject getLastOfferTemplate(DynamicObject offerInfo) {
        DynamicObject recruitTyp = offerInfo.getDynamicObject("recrutyp");
        DynamicObject recruScene = offerInfo.getDynamicObject("recruscene");
        Long userId = TSCRequestContext.getUserId();
        QFilter modFilter = new QFilter("applicant", "=", (Object)userId);
        QFilter recruitTypFilter = new QFilter("recrutyp", "=", (Object)recruitTyp.getLong("id"));
        QFilter recruSceneFilter = null;
        if (!Objects.nonNull(recruScene)) {
            return null;
        }
        recruSceneFilter = new QFilter("recruscene", "=", (Object)recruScene.getLong("id"));
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"template", "content_tag"});
        String orderBy = "applytime desc";
        QFilter[] filters = new QFilter[]{modFilter, recruitTypFilter, recruSceneFilter};
        DynamicObject[] query = this.query(selectProperties, filters, orderBy, 1);
        if (query == null || query.length <= 0) {
            return null;
        }
        DynamicObject templateTemp = query[0].getDynamicObject("template");
        if (templateTemp == null) {
            return null;
        }
        long busUnitId = offerInfo.getDynamicObject("busunit").getLong("id");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_offertemplate", (Long)busUnitId);
        QFilter templateIdFilter = new QFilter("id", "=", (Object)templateTemp.getLong("id"));
        templateIdFilter.and(new QFilter("recrutyp", "=", (Object)recruitTyp.getLong("id")));
        if (Objects.nonNull(recruScene)) {
            templateIdFilter.and(new QFilter("mulrecruscene.fbasedataid", "=", (Object)recruScene.getLong("id")));
        }
        templateIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper templateHelper = new HRBaseServiceHelper("tsrbd_offertemplate");
        QFilter[] qFilters = new QFilter[]{baseDataFilter, templateIdFilter};
        DynamicObject[] template = templateHelper.query("content_tag", qFilters);
        if (template == null || template.length <= 0) {
            return null;
        }
        return template[0];
    }

    public DynamicObject[] getValidDynamicObjectByAppIdList(List<Long> appFileList) {
        if (CollectionUtils.isEmpty(appFileList)) {
            return new DynamicObject[0];
        }
        ArrayList appfileIdStrList = new ArrayList(appFileList.size());
        appFileList.forEach(appfile -> appfileIdStrList.add(appfile + ""));
        QFilter qFilter = new QFilter("pindexes", "in", appfileIdStrList);
        return this.loadDynamicObjectArray(qFilter.toArray());
    }

    public void updateSalaryStatus(DynamicObject offerInfo) {
        offerInfo.set("salaryStatus", (Object)"C");
    }

    public DynamicObject queryOfferInfoByAuditNo(String selectProperties, String offerAuditNo) {
        QFilter offerFilter = new QFilter("offerauditno", "=", (Object)offerAuditNo);
        return this.queryOne(selectProperties, offerFilter.toArray());
    }

    private static class Instance {
        private static OfferServiceHelper OFFER_INSTANCE = new OfferServiceHelper("tso_somk_offerbase");

        private Instance() {
        }
    }
}

