/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;

public class OfferStatusHelper {
    private static final Map<String, String> FORE_COLOR_MAP = Maps.newHashMapWithExpectedSize((int)7);
    private static final Map<String, String> BACKGROUND_COLOR_MAP = Maps.newHashMapWithExpectedSize((int)7);
    private static final Map<String, String> BORDER_COLOR_MAP = Maps.newHashMapWithExpectedSize((int)7);

    private OfferStatusHelper() {
    }

    public static List<CellStyle> getCellStyleListOfStatus(IListView view, DynamicObject[] offerInfoList) {
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(offerInfoList.length);
        ListSelectedRowCollection currentListAllRowCollection = view.getCurrentListAllRowCollection();
        Arrays.stream(offerInfoList).forEach(offerInfo -> currentListAllRowCollection.stream().filter(cRow -> cRow.getPrimaryKeyValue().equals(offerInfo.get("id"))).findFirst().ifPresent(cRow -> {
            OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
            String statusColor = FORE_COLOR_MAP.get(Long.toString(offerStatus.getCode()));
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("status_name");
            cellStyle.setRow(cRow.getRowKey());
            cellStyle.setForeColor(statusColor);
            cellStyleList.add(cellStyle);
        }));
        return cellStyleList;
    }

    public static Map<String, Object> getStatusMetaDataMap(IOfferStatus status) {
        String statusCode = "";
        if (status instanceof OfferAuditStatus) {
            statusCode = ((OfferAuditStatus)status).getCode();
        }
        if (status instanceof OfferStatus) {
            statusCode = Long.toString(((OfferStatus)status).getCode());
        }
        if (status instanceof OfferLetterStatus) {
            statusCode = Long.toString(((OfferLetterStatus)status).getCode());
        }
        if (status instanceof OfferLetterReplyStatus) {
            statusCode = Long.toString(((OfferLetterReplyStatus)status).getCode());
        }
        if (status instanceof OfferLetterDataStatus) {
            statusCode = Long.toString(((OfferLetterDataStatus)status).getCode());
        }
        if (status instanceof InductionStatus) {
            statusCode = ((InductionStatus)status).getCode();
        }
        if (HRStringUtils.isEmpty((String)statusCode)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return OfferStatusHelper.generateMap(FORE_COLOR_MAP.get(statusCode), BACKGROUND_COLOR_MAP.get(statusCode), BORDER_COLOR_MAP.get(statusCode));
    }

    private static Map<String, Object> generateMap(String colorByStatus, String backgroundStatus, String borderStatus) {
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)1);
        ctrl.put("fc", colorByStatus);
        ctrl.put("bc", backgroundStatus);
        HashMap borderMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("t", borderStatus);
        map.put("r", borderStatus);
        map.put("l", borderStatus);
        map.put("b", borderStatus);
        borderMap.put("b", map);
        ctrl.put("s", borderMap);
        return ctrl;
    }

    static {
        FORE_COLOR_MAP.put(Long.toString(OfferStatus.PRE_APPLY.getCode()), "#276FF5");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferStatus.PRE_APPLY.getCode()), "#F2F9FF");
        BORDER_COLOR_MAP.put(Long.toString(OfferStatus.PRE_APPLY.getCode()), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(Long.toString(OfferStatus.APPLYING.getCode()), "#276FF5");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferStatus.APPLYING.getCode()), "#F2F9FF");
        BORDER_COLOR_MAP.put(Long.toString(OfferStatus.APPLYING.getCode()), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_PASS.getCode()), "#1BA854");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_PASS.getCode()), "#F2FFF5");
        BORDER_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_PASS.getCode()), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_TERM.getCode()), "#FB2323");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_TERM.getCode()), "#FFF2F4");
        BORDER_COLOR_MAP.put(Long.toString(OfferStatus.APPLY_TERM.getCode()), "1px_solid_#FF8088");
        FORE_COLOR_MAP.put(Long.toString(OfferStatus.ALR_DISCARD.getCode()), "#666666");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferStatus.ALR_DISCARD.getCode()), "#F5F5F5");
        BORDER_COLOR_MAP.put(Long.toString(OfferStatus.ALR_DISCARD.getCode()), "1px_solid_#CCCCCC");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_GENERATE.getCode()), "#276FF5");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_GENERATE.getCode()), "#F2F9FF");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_GENERATE.getCode()), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_SEND.getCode()), "#276FF5");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_SEND.getCode()), "#F2F9FF");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterStatus.PRE_SEND.getCode()), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterStatus.NOSEND_OUTTIME.getCode()), "#FF991C");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterStatus.NOSEND_OUTTIME.getCode()), "#FFFBF2");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterStatus.NOSEND_OUTTIME.getCode()), "1px_solid_#FFCB78");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_SEND.getCode()), "#1BA854");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_SEND.getCode()), "#F2FFF5");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_SEND.getCode()), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_DISCARD.getCode()), "#666666");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_DISCARD.getCode()), "#F5F5F5");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterStatus.ALR_DISCARD.getCode()), "1px_solid_#CCCCCC");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.PRE_REPLY.getCode()), "#276FF5");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.PRE_REPLY.getCode()), "#F2F9FF");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.PRE_REPLY.getCode()), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_OUTTIME.getCode()), "#FF991C");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_OUTTIME.getCode()), "#FFFBF2");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_OUTTIME.getCode()), "1px_solid_#FFCB78");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_ACCEPT.getCode()), "#1BA854");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_ACCEPT.getCode()), "#F2FFF5");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_ACCEPT.getCode()), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_REFUSE.getCode()), "#FB2323");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_REFUSE.getCode()), "#FFF2F4");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterReplyStatus.ALR_REFUSE.getCode()), "1px_solid_#FF8088");
        FORE_COLOR_MAP.put(Long.toString(OfferLetterDataStatus.INVALID.getCode()), "#999999");
        BACKGROUND_COLOR_MAP.put(Long.toString(OfferLetterDataStatus.INVALID.getCode()), "#FAFAFA");
        BORDER_COLOR_MAP.put(Long.toString(OfferLetterDataStatus.INVALID.getCode()), "#D9D9D9");
        FORE_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "#276FF5");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "#F2F9FF");
        BORDER_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(OfferAuditStatus.TEMPORARY.getCode(), "#666666");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.TEMPORARY.getCode(), "#F5F5F5");
        BORDER_COLOR_MAP.put(OfferAuditStatus.TEMPORARY.getCode(), "1px_solid_#CCCCCC");
        FORE_COLOR_MAP.put(OfferAuditStatus.WAIT_RESUBMIT.getCode(), "#FF991C");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.WAIT_RESUBMIT.getCode(), "#FFFBF2");
        BORDER_COLOR_MAP.put(OfferAuditStatus.WAIT_RESUBMIT.getCode(), "1px_solid_#FFCB78");
        FORE_COLOR_MAP.put(OfferAuditStatus.AUDITING.getCode(), "#276FF5");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.AUDITING.getCode(), "#F2F9FF");
        BORDER_COLOR_MAP.put(OfferAuditStatus.AUDITING.getCode(), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(OfferAuditStatus.AUDIT_PASS.getCode(), "#1BA854");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.AUDIT_PASS.getCode(), "#F2FFF5");
        BORDER_COLOR_MAP.put(OfferAuditStatus.AUDIT_PASS.getCode(), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(OfferAuditStatus.AUDIT_NOTPASS.getCode(), "#FB2323");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.AUDIT_NOTPASS.getCode(), "#FFF2F4");
        BORDER_COLOR_MAP.put(OfferAuditStatus.AUDIT_NOTPASS.getCode(), "1px_solid_#FF8088");
        FORE_COLOR_MAP.put(OfferAuditStatus.ALR_ABANDON.getCode(), "#666666");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.ALR_ABANDON.getCode(), "#F5F5F5");
        BORDER_COLOR_MAP.put(OfferAuditStatus.ALR_ABANDON.getCode(), "1px_solid_#CCCCCC");
        FORE_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "#276FF5");
        BACKGROUND_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "#F2F9FF");
        BORDER_COLOR_MAP.put(OfferAuditStatus.ALR_SUBMIT.getCode(), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(InductionStatus.PRE_INDUCTION.getCode(), "#276FF5");
        BACKGROUND_COLOR_MAP.put(InductionStatus.PRE_INDUCTION.getCode(), "#F2F9FF");
        BORDER_COLOR_MAP.put(InductionStatus.PRE_INDUCTION.getCode(), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(InductionStatus.ALR_INDUCTION.getCode(), "#1BA854");
        BACKGROUND_COLOR_MAP.put(InductionStatus.ALR_INDUCTION.getCode(), "#F2FFF5");
        BORDER_COLOR_MAP.put(InductionStatus.ALR_INDUCTION.getCode(), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(InductionStatus.POS_INDUCTION.getCode(), "#1BA854");
        BACKGROUND_COLOR_MAP.put(InductionStatus.POS_INDUCTION.getCode(), "#F2FFF5");
        BORDER_COLOR_MAP.put(InductionStatus.POS_INDUCTION.getCode(), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(InductionStatus.DEP_INDUCTION.getCode(), "#1BA854");
        BACKGROUND_COLOR_MAP.put(InductionStatus.DEP_INDUCTION.getCode(), "#F2FFF5");
        BORDER_COLOR_MAP.put(InductionStatus.DEP_INDUCTION.getCode(), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(InductionStatus.TERM_INDUCTION.getCode(), "#666666");
        BACKGROUND_COLOR_MAP.put(InductionStatus.TERM_INDUCTION.getCode(), "#F5F5F5");
        BORDER_COLOR_MAP.put(InductionStatus.TERM_INDUCTION.getCode(), "1px_solid_#CCCCCC");
        FORE_COLOR_MAP.put(InductionStatus.INDUCTION_PROCESS.getCode(), "#276FF5");
        BACKGROUND_COLOR_MAP.put(InductionStatus.INDUCTION_PROCESS.getCode(), "#F2F9FF");
        BORDER_COLOR_MAP.put(InductionStatus.INDUCTION_PROCESS.getCode(), "1px_solid_#85B8FF");
        FORE_COLOR_MAP.put(InductionStatus.INDUCTION_SUCCESS.getCode(), "#1BA854");
        BACKGROUND_COLOR_MAP.put(InductionStatus.INDUCTION_SUCCESS.getCode(), "#F2FFF5");
        BORDER_COLOR_MAP.put(InductionStatus.INDUCTION_SUCCESS.getCode(), "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put(InductionStatus.INDUCTION_ERROR.getCode(), "#FB2323");
        BACKGROUND_COLOR_MAP.put(InductionStatus.INDUCTION_ERROR.getCode(), "#FFF2F4");
        BORDER_COLOR_MAP.put(InductionStatus.INDUCTION_ERROR.getCode(), "1px_solid_#FF8088");
    }
}

