/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class OfferSubmitHelper {
    public void showBosOperateResultForm(List<VerifyOfferFailedInfo> verifyOfferFailedInfos, IFormView formView) {
        int allOfferNum = this.getSelectedOfferIdList(formView).size();
        int failOfferNum = verifyOfferFailedInfos.size();
        int succOfferNum = allOfferNum - failOfferNum;
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u6761\u6570\u636e\uff0c\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761\u3002", (String)"OfferAbstractButtonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), allOfferNum, succOfferNum, failOfferNum);
        ArrayList errorMsgs = new ArrayList(verifyOfferFailedInfos.size());
        verifyOfferFailedInfos.parallelStream().forEach(verifyOfferFailedInfo -> errorMsgs.add(verifyOfferFailedInfo.getBillNo() + ":" + verifyOfferFailedInfo.getFailedMsg()));
        FormShowParameter bosOperationResultParam = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, errorMsgs, (boolean)true);
        formView.showForm(bosOperationResultParam);
    }

    protected List<Long> getSelectedOfferIdList(IFormView formView) {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        FormShowParameter formShowParameter = formView.getParentView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter offerParameter = (BillShowParameter)formShowParameter;
            Object pkId = offerParameter.getPkId();
            if (Objects.nonNull(pkId)) {
                offerIds.add(Long.valueOf(pkId.toString()));
            }
        } else if (formShowParameter instanceof ListShowParameter) {
            IListView view = (IListView)formView.getParentView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            selectedRows.forEach(row -> offerIds.add((Long)row.getPrimaryKeyValue()));
        } else {
            Optional.ofNullable(formView.getParentView().getModel().getValue("offerid")).ifPresent(offerId -> offerIds.add(Long.parseLong(offerId.toString())));
        }
        return offerIds;
    }
}

