/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kd.bos.zip.io.outputstream.ZipOutputStream;
import kd.bos.zip.model.ZipParameters;

public class ZipFileWithPwdHelper {
    public static final ZipFileWithPwdHelper INSTANCE = new ZipFileWithPwdHelper();

    private ZipFileWithPwdHelper() {
    }

    public void getZipOutputStream(ByteArrayOutputStream byteArrayOutputStream, Map<String, InputStream> nameAndStreamMap, ZipParameters zipParameters, char[] eppwd, boolean isEncrypt) throws IOException {
        byte[] buff = new byte[4096];
        try (ZipOutputStream zos = this.initializeZipOutputStream(byteArrayOutputStream, isEncrypt, eppwd);){
            for (Map.Entry<String, InputStream> entry : nameAndStreamMap.entrySet()) {
                int readLen;
                this.updateZipParameters(zipParameters, entry.getKey());
                zos.putNextEntry(zipParameters);
                while ((readLen = entry.getValue().read(buff)) != -1) {
                    zos.write(buff, 0, readLen);
                }
                zos.closeEntry();
            }
        }
    }

    private void updateZipParameters(ZipParameters zipParameters, String fileName) {
        zipParameters.setFileNameInZip(fileName);
    }

    private ZipOutputStream initializeZipOutputStream(ByteArrayOutputStream byteArrayOutputStream, boolean encrypt, char[] password) throws IOException {
        if (encrypt) {
            return new ZipOutputStream((OutputStream)byteArrayOutputStream, password);
        }
        return new ZipOutputStream((OutputStream)byteArrayOutputStream);
    }
}

