/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransparencyGroup;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.attachment.AttachmentService;
import kd.tsc.tso.business.domain.offer.helper.OfferAttachmentHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.offerLetter.DefaultOfferLetterTemplateBizService;
import kd.tsc.tspr.business.domain.rpc.impl.HsbsRpcServiceImpl;
import kd.tsc.tspr.common.dto.request.hsbs.QuerySalaryAmountReqDTO;
import kd.tsc.tspr.common.dto.response.CommonRespDTO;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.fieldscm.CfgMsgFieldSchemeService;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;
import kd.tsc.tsrbd.business.domain.offer.service.modal.AbstractOfferLetterTemplateBizService;
import kd.tsc.tsrbd.business.domain.offer.service.modal.impl.IOfferLetterTemplateService;
import kd.tsc.tsrbd.business.utils.BizAttachmentUtil;
import kd.tsc.tsrbs.business.domain.export.service.TscFontPath;
import org.apache.commons.collections.MapUtils;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class OfferAttachmentService {
    private static final Log logger = LogFactory.getLog(OfferAttachmentService.class);
    private static String FONT_PATH = TscFontPath.getFontPath((String)"MSYH.TTC");
    private static final AttachmentService attachmentService = AttachmentService.Singleton.INSTANCE.getInstance();
    private static final OfferTemplateHelper OFFER_TEMPLATE_HELPER = new OfferTemplateHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void generateLetterAttachment(DynamicObject dataEntity) throws Exception {
        block15: {
            block13: {
                block14: {
                    attachmentHelper = OfferAttachmentHelper.getInstance();
                    letterId = dataEntity.getLong("letterid");
                    path = FileSystems.getDefault().getPath("letter" + letterId + ".pdf", new String[0]);
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException exception) {
                        OfferAttachmentService.logger.error("\u3010deleteIfExists\u3011 error: ", (Throwable)exception);
                    }
                    bosAttachmentObjs = attachmentHelper.getAttachInfoFromBosAttach(letterId, "tsrbd_cfgmsgintegrate", new String[]{"ffileid"});
                    OfferAttachmentService.logger.info("OfferAttachmentService.generateLetterAttachment.bosAttachmentObjs -> {}", (Object)JSONObject.toJSONString((Object)bosAttachmentObjs));
                    isSendPdf = dataEntity.getBoolean("isgtannex");
                    if (!(isSendPdf || bosAttachmentObjs != null && bosAttachmentObjs.length >= 1)) {
                        return;
                    }
                    pdfInputStream = null;
                    bos = null;
                    pdfInputStream = this.generatePdfFile(dataEntity);
                    if (!isSendPdf) ** GOTO lbl30
                    if (pdfInputStream != null) break block13;
                    if (pdfInputStream == null) break block14;
                    OfferAttachmentService.safeCloseInputStream(pdfInputStream);
                }
                if (bos != null) {
                    OfferAttachmentService.safeCloseOutputStream(bos);
                }
                return;
            }
            try {
                OfferAttachmentService.logger.info("generatePdf success");
lbl30:
                // 2 sources

                bos = attachmentHelper.getZipFileStream(dataEntity, bosAttachmentObjs, pdfInputStream);
                OfferAttachmentService.logger.info("generateZip success");
                attachmentHelper.upLoadFile(dataEntity, bos);
                OfferAttachmentService.logger.info("upload success");
                if (pdfInputStream == null) break block15;
            }
            catch (Exception exception) {
                block16: {
                    try {
                        OfferAttachmentService.logger.error("\u3010generateLetterAttachment\u3011 error: ", (Throwable)exception);
                        if (pdfInputStream == null) break block16;
                    }
                    catch (Throwable var11_11) {
                        if (pdfInputStream != null) {
                            OfferAttachmentService.safeCloseInputStream(pdfInputStream);
                        }
                        if (bos != null) {
                            OfferAttachmentService.safeCloseOutputStream(bos);
                        }
                        throw var11_11;
                    }
                    OfferAttachmentService.safeCloseInputStream(pdfInputStream);
                }
                if (bos != null) {
                    OfferAttachmentService.safeCloseOutputStream(bos);
                } else {
                    ** GOTO lbl55
                }
            }
            OfferAttachmentService.safeCloseInputStream(pdfInputStream);
        }
        if (bos != null) {
            OfferAttachmentService.safeCloseOutputStream(bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mokaGenerateLetterAttachment(DynamicObject dataEntity) {
        OfferAttachmentHelper attachmentHelper = OfferAttachmentHelper.getInstance();
        long letterId = dataEntity.getLong("letterid");
        Path path = FileSystems.getDefault().getPath("letter" + letterId + ".pdf", new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException exception) {
            logger.error("\u3010deleteIfExists\u3011 error: ", (Throwable)exception);
        }
        InputStream pdfInputStream = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try {
            pdfInputStream = this.generatePdfFile(dataEntity);
            logger.info("pdfInputStream success");
            if (pdfInputStream != null) {
                int len;
                byte[] bytes = new byte[1024];
                while ((len = pdfInputStream.read(bytes)) != -1) {
                    bos.write(bytes, 0, len);
                }
                logger.info("generateZip success");
                attachmentHelper.pdfUpLoadFile(dataEntity, bos);
                logger.info("upload success");
            }
        }
        catch (Exception exception) {
            logger.error("\u3010generateLetterAttachment\u3011 error: ", (Throwable)exception);
        }
        finally {
            if (pdfInputStream != null) {
                OfferAttachmentService.safeCloseInputStream(pdfInputStream);
            }
            if (bos != null) {
                OfferAttachmentService.safeCloseOutputStream(bos);
            }
        }
    }

    public Map<String, String> getSalaryMap(DynamicObject offer) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        HsbsRpcServiceImpl service = new HsbsRpcServiceImpl();
        QuerySalaryAmountReqDTO dto = new QuerySalaryAmountReqDTO();
        dto.setOfferCode(offer.getString("number"));
        dto.setOfferId(Long.valueOf(offer.getLong("id")));
        dto.setFormId("tso_somk_offerbaseinfo");
        dto.setSalaryIdList(CfgMsgFieldSchemeService.getInstance().getMsgTempFields("salary"));
        CommonRespDTO respDTO = service.querySalaryAmount(dto);
        logger.info("OfferBasicInfoEdit.showLetter.result -> {}", (Object)JSONObject.toJSONString((Object)respDTO));
        List resultValList = (List)respDTO.getResult();
        resultValList.forEach(val -> valueMap.put(String.valueOf(val.getSalaryStdItemId()), val.getCurrency()));
        logger.info("OfferBasicInfoEdit.showLetter.map");
        return valueMap;
    }

    public Map<String, String> getNoCheckPermissionSalaryMap(DynamicObject offer) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        HsbsRpcServiceImpl service = new HsbsRpcServiceImpl();
        QuerySalaryAmountReqDTO dto = new QuerySalaryAmountReqDTO();
        dto.setOfferCode(offer.getString("number"));
        dto.setOfferId(Long.valueOf(offer.getLong("id")));
        dto.setFormId("tso_somk_offerbaseinfo");
        dto.setSalaryIdList(CfgMsgFieldSchemeService.getInstance().getMsgTempFields("salary"));
        CommonRespDTO respDTO = service.querySalaryAmountByNoCheckPermission(dto);
        logger.info("OfferBasicInfoEdit.showLetter.result -> {}", (Object)JSONObject.toJSONString((Object)respDTO));
        List resultValList = (List)respDTO.getResult();
        resultValList.forEach(val -> valueMap.put(String.valueOf(val.getSalaryStdItemId()), val.getCurrency()));
        logger.info("OfferBasicInfoEdit.showLetter.map");
        return valueMap;
    }

    public String getOfferLetterContentByOffer(DynamicObject offer) {
        String letterContent;
        String salaryType = offer.getString("salarytype");
        if ("2".equals(salaryType)) {
            Map<String, String> salaryMap = this.getSalaryMap(offer);
            letterContent = this.generateLetterContent(salaryMap, offer);
        } else {
            letterContent = this.generateLetterContent(Boolean.FALSE, offer);
        }
        return letterContent;
    }

    public String getOfferLetterContentByOfferLetter(DynamicObject offerLetter) {
        String letterContent;
        logger.info("getOfferLetterContentByOfferLetter.offerLetterId -> {}", (Object)offerLetter.getLong("id"));
        long offerId = offerLetter.getDynamicObject("offer").getLong("id");
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
        String content = this.getQueryContent(offerLetter, offerId);
        String salaryType = offer.getString("salarytype");
        DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
        IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
        if ("2".equals(salaryType)) {
            Map<String, String> salaryMap = this.getSalaryMap(offer);
            letterContent = templateService.previewOfferLetterTemplate(content, salaryMap, new DynamicObject[]{offer});
        } else {
            letterContent = templateService.previewOfferLetterTemplate(content, Boolean.FALSE, new DynamicObject[]{offer});
        }
        logger.info("getOfferLetterContentByOfferLetter.letterContent -> {}", (Object)letterContent);
        return letterContent;
    }

    private String getQueryContent(DynamicObject offerLetter, long offerId) {
        String content = this.getContent(offerLetter);
        if (HRStringUtils.isNotEmpty((String)content)) {
            return content;
        }
        QFilter qFilter = new QFilter("offer", "=", (Object)offerId);
        offerLetter = OfferLetterServiceHelper.getInstance().queryOne("lettercontent_tag,sendlettercontent_tag", new QFilter[]{qFilter}, "createtime asc");
        return this.getContent(offerLetter);
    }

    private String getContent(DynamicObject offerLetter) {
        String content = offerLetter.getString("sendlettercontent_tag");
        if (!HRStringUtils.isEmpty((String)content)) {
            return content;
        }
        content = offerLetter.getString("lettercontent_tag");
        if (!HRStringUtils.isEmpty((String)content)) {
            return content;
        }
        return "";
    }

    public String getSendLetterContentByOfferLetter(DynamicObject offerLetter) {
        logger.info("OfferAttachmentService.getSendLetterContentByOfferLetter letterId {}", (Object)offerLetter.getLong("id"));
        DynamicObject offer = offerLetter.getDynamicObject("offer");
        long offerId = offer.getLong("id");
        DynamicObject offerById = OfferServiceHelper.getInstance().getOfferById(offerId);
        String content = offerLetter.getString("sendlettercontent_tag");
        logger.info("OfferAttachmentService.getSendLetterContentByOfferLetter content {}", (Object)content);
        String salaryType = offerById.getString("salarytype");
        DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
        IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
        String letterContent = "";
        if ("2".equals(salaryType)) {
            Map<String, String> salaryMap = this.getNoCheckPermissionSalaryMap(offerById);
            logger.info("OfferAttachmentService.getSendLetterContentByOfferLetter salaryMap {}", salaryMap);
            letterContent = templateService.previewOfferLetterTemplate(content, salaryMap, new DynamicObject[]{offerById});
        } else {
            letterContent = templateService.previewOfferLetterTemplate(content, Boolean.FALSE, new DynamicObject[]{offerById});
        }
        logger.info("OfferAttachmentService.getSendLetterContentByOfferLetter letterContent {}", (Object)letterContent);
        return letterContent;
    }

    public String generateLetterContent(Boolean isShowEmptyFields, DynamicObject ... dynamicObjects) {
        String templateContent = null;
        for (DynamicObject dy : dynamicObjects) {
            if (dy == null) continue;
            if (dy.getDynamicObjectType().getName().equals("tso_somk_offerbase") || dy.getDynamicObjectType().getName().equals("tso_offerbase_info") || dy.getDynamicObjectType().getName().equals("tso_somk_offerbaseinfo") || dy.getDynamicObjectType().getName().equals("tso_somk_waitofferbase")) {
                templateContent = dy.getString("templatecontent_tag");
            }
            if (!dy.getDynamicObjectType().getName().equals("tso_somk_offernotice")) continue;
            DynamicObject template = dy.getDynamicObject("template");
            DynamicObject offerTemplate = OFFER_TEMPLATE_HELPER.getOfferTemplate((Object)template.getLong("id"));
            templateContent = offerTemplate.getString("content_tag");
        }
        if (HRStringUtils.isEmpty(templateContent)) {
            return null;
        }
        DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
        IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
        return templateService.previewOfferLetterTemplate(templateContent, isShowEmptyFields, dynamicObjects);
    }

    public String generateLetterContent(DynamicObject ... dynamicObjects) {
        String templateContent = null;
        Map<String, String> salaryMap = null;
        for (DynamicObject dy : dynamicObjects) {
            if (dy == null) continue;
            if (dy.getDynamicObjectType().getName().equals("tso_somk_offerbase") || dy.getDynamicObjectType().getName().equals("tso_offerbase_info") || dy.getDynamicObjectType().getName().equals("tso_somk_offerbaseinfo") || dy.getDynamicObjectType().getName().equals("tso_somk_waitofferbase")) {
                templateContent = dy.getString("templatecontent_tag");
                salaryMap = OfferAttachmentService.getInstance().getSalaryMap(dy);
            }
            if (!dy.getDynamicObjectType().getName().equals("tso_somk_offernotice")) continue;
            DynamicObject template = dy.getDynamicObject("template");
            DynamicObject offerTemplate = OFFER_TEMPLATE_HELPER.getOfferTemplate((Object)template.getLong("id"));
            templateContent = offerTemplate.getString("content_tag");
        }
        if (HRStringUtils.isEmpty(templateContent)) {
            return null;
        }
        DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
        IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
        return templateService.previewOfferLetterTemplate(templateContent, salaryMap, dynamicObjects);
    }

    public String generateLetterContent(Map<String, String> valueMap, DynamicObject ... dynamicObjects) {
        String templateContent = null;
        for (DynamicObject dy : dynamicObjects) {
            if (dy == null) continue;
            if (dy.getDynamicObjectType().getName().equals("tso_somk_offerbase") || dy.getDynamicObjectType().getName().equals("tso_offerbase_info") || dy.getDynamicObjectType().getName().equals("tso_somk_offerbaseinfo") || dy.getDynamicObjectType().getName().equals("tso_somk_waitofferbase")) {
                templateContent = dy.getString("templatecontent_tag");
            }
            if (!dy.getDynamicObjectType().getName().equals("tso_somk_offernotice")) continue;
            DynamicObject template = dy.getDynamicObject("template");
            DynamicObject offerTemplate = OFFER_TEMPLATE_HELPER.getOfferTemplate((Object)template.getLong("id"));
            templateContent = offerTemplate.getString("content_tag");
        }
        if (HRStringUtils.isEmpty(templateContent)) {
            return "";
        }
        DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
        IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
        return MapUtils.isEmpty(valueMap) ? templateService.previewOfferLetterTemplate(templateContent, dynamicObjects) : templateService.previewOfferLetterTemplate(templateContent, valueMap, dynamicObjects);
    }

    private InputStream generatePdfFile(DynamicObject adviceObj) {
        String offerLetterContent;
        if (!adviceObj.getBoolean("isgtannex")) {
            return null;
        }
        long offerId = adviceObj.getLong("offerid");
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(offerId);
        long letterId = adviceObj.getLong("letterid");
        DynamicObject letter = OfferLetterServiceHelper.getInstance().queryOne(letterId);
        String salaryType = offer.getString("salarytype");
        if ("2".equals(salaryType)) {
            Map<String, String> salaryMap = this.getSalaryMap(offer);
            offerLetterContent = this.generateLetterContent(salaryMap, offer, letter, adviceObj);
        } else {
            offerLetterContent = this.generateLetterContent(Boolean.FALSE, offer, letter, adviceObj);
        }
        String replaceOfferLetterContent = offerLetterContent.replaceAll("(font-family:.+?;)", "font-family: Microsoft YaHei;");
        String letterStringBuilder = "<!DOCTYPE html><html lang=\"en\"><body style=\"font-family:Microsoft YaHei\"><div style=\"background-color: rgb(219, 240, 255); border-radius: 5px;height: 40px; margin:auto;\"><div style=\"color: rgb(0, 0, 0); font-size: 22px; margin-left:5px; padding-top:5px;\"><span class=\"\" >Offer Letter</span></div></div>" + replaceOfferLetterContent + "</body></html>";
        return this.generateOfferLetterPdfByContent(adviceObj, letterStringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream generateOfferLetterPdfByContent(DynamicObject dataEntity, String offerLetterContent) {
        FileInputStream fileInputStream;
        block6: {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream("letter" + dataEntity.getLong("letterid") + ".pdf");
                ITextRenderer renderer = new ITextRenderer();
                ITextFontResolver fontResolver = renderer.getFontResolver();
                fontResolver.addFont(FONT_PATH, "Identity-H", false);
                renderer.setDocumentFromString(offerLetterContent);
                renderer.layout();
                renderer.createPDF((OutputStream)fileOutputStream);
                fileInputStream = new FileInputStream("letter" + dataEntity.getLong("letterid") + ".pdf");
                if (fileOutputStream == null) break block6;
            }
            catch (Exception exception) {
                logger.error("generatePdf error: ", (Throwable)exception);
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (fileOutputStream != null) {
                    OfferAttachmentService.safeCloseOutputStream(fileOutputStream);
                }
            }
            OfferAttachmentService.safeCloseOutputStream(fileOutputStream);
        }
        return fileInputStream;
    }

    private void fillDocument(Document document, PdfWriter pdfWriter, List<String> contents) throws DocumentException, IOException {
        BaseFont baseFont = BaseFont.createFont((String)(FONT_PATH + ",1"), (String)"Identity-H", (boolean)false);
        PdfContentByte directContent = pdfWriter.getDirectContent();
        PdfTemplate template = directContent.createTemplate(PageSize.A4.getWidth(), 48.0f);
        PdfTransparencyGroup group = new PdfTransparencyGroup();
        group.put(PdfName.AS, (PdfObject)PdfName.DEVICEGRAY);
        group.setIsolated(false);
        group.setKnockout(false);
        template.setGroup(group);
        Color baseColor = new Color(118, 189, 239);
        Color baseColor1 = new Color(219, 240, 255);
        PdfShading radial = PdfShading.simpleAxial((PdfWriter)pdfWriter, (float)PageSize.A4.getWidth(), (float)PageSize.A4.getHeight(), (float)0.0f, (float)PageSize.A4.getHeight(), (Color)baseColor, (Color)baseColor1);
        template.paintShading(radial);
        PdfDictionary mask = new PdfDictionary();
        mask.put(PdfName.TYPE, (PdfObject)PdfName.MASK);
        mask.put(PdfName.S, (PdfObject)new PdfName("Luminosity"));
        mask.put(new PdfName("G"), (PdfObject)template.getIndirectReference());
        directContent.saveState();
        PdfShadingPattern shading = new PdfShadingPattern(radial);
        directContent.setShadingFill(shading);
        PdfGState state = new PdfGState();
        directContent.setGState(state);
        directContent.moveTo(0.0f, PageSize.A4.getHeight());
        directContent.lineTo(PageSize.A4.getWidth(), PageSize.A4.getHeight());
        directContent.lineTo(PageSize.A4.getWidth(), PageSize.A4.getHeight() - 48.0f);
        directContent.lineTo(0.0f, PageSize.A4.getHeight() - 48.0f);
        directContent.closePath();
        directContent.fill();
        directContent.restoreState();
        Font titleFont = new Font(baseFont, 16.0f, 1, new Color(51, 51, 51));
        Paragraph paragraphTitle = new Paragraph("Offer Letter", titleFont);
        paragraphTitle.setAlignment(0);
        paragraphTitle.setAlignment(6);
        ColumnText.showTextAligned((PdfContentByte)directContent, (int)0, (Phrase)paragraphTitle, (float)(document.left() - 16.0f), (float)(document.top() + 6.0f), (float)0.0f);
        ColumnText.showTextAligned((PdfContentByte)directContent, (int)6, (Phrase)paragraphTitle, (float)(document.left() - 16.0f), (float)(document.top() + 6.0f), (float)0.0f);
        Font witheFont = new Font(baseFont, 12.0f, 0, Color.WHITE);
        Paragraph blankParagraph = new Paragraph("  ", witheFont);
        document.add((Element)blankParagraph);
        Font contentFont = new Font(baseFont, 12.0f, 0, Color.BLACK);
        for (String content : contents) {
            Paragraph contentParagraph = new Paragraph(content, contentFont);
            document.add((Element)contentParagraph);
        }
    }

    public List<Map<String, Object>> getOfferAttachment(Object offerId) {
        if (offerId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return attachmentService.getAttachmentList("tso_social_offerbase", offerId, "attachmentpanelap");
    }

    public void saveAttachment(IFormView view, IDataModel model, Long id) {
        String attachmentPageId = view.getPageCache().get("offerAttachPageId");
        if (HRStringUtils.isEmpty((String)attachmentPageId)) {
            return;
        }
        IFormView attachmentView = view.getView(attachmentPageId);
        AttachmentPanel panel = (AttachmentPanel)attachmentView.getControl("attachmentpanelap");
        if (panel == null) {
            return;
        }
        id = model.getDataEntity(true).getLong("id") == 0L ? id.longValue() : model.getDataEntity(true).getLong("id");
        if (id == 0L) {
            logger.error("OfferAttachmentService.saveAttachment execute error : id == 0L");
            return;
        }
        List attachmentData = panel.getAttachmentData();
        String panelStr = attachmentView.getPageCache().get("attachmentpanelap");
        if (HRStringUtils.isNotEmpty((String)panelStr)) {
            List list = (List)SerializationUtils.deSerializeFromBase64((String)panelStr);
            if (0 == attachmentData.size() && null != list) {
                attachmentData = list;
            }
        }
        BizAttachmentUtil.uploadAndSaveAttachments((String)"tso_social_offerbase", (Object)id, (String)"attachmentpanelap", (List)attachmentData);
    }

    private static void safeCloseInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static void safeCloseOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static OfferAttachmentService getInstance() {
        return Instance.OFFER_ATTACH_INSTANCE;
    }

    private static class Instance {
        private static OfferAttachmentService OFFER_ATTACH_INSTANCE = new OfferAttachmentService();

        private Instance() {
        }
    }
}

