/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.tsc.tso.business.domain.induction.service.endIdc.InductionEndService;
import kd.tsc.tso.business.domain.induction.service.startIdc.InductionStartService;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBaseAbandonService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBillAbandonService;
import kd.tsc.tso.business.domain.offer.service.btnservice.chgvalidtime.OfferChgValidTimeService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delayreply.OfferDelayReplyService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delaysend.OfferDelaySendService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.OfferBillDeleteService;
import kd.tsc.tso.business.domain.offer.service.btnservice.edit.OfferEditBaseInfoService;
import kd.tsc.tso.business.domain.offer.service.btnservice.edit.OfferEditBillInfoService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBaseSaveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBillSaveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.send.OfferBaseSendService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBillSubmitService;
import kd.tsc.tso.business.domain.offer.service.btnservice.unsubmit.OfferBillUnSubmitService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBtnShowService {
    private static String[] ALL_BUTTONARR = new String[]{"bar_submit", "bar_modify", "bar_delaysend", "bar_abandon", "bar_cancel", "bar_chgvalidtime", "bar_send", "bar_close", "bar_save", "bar_delayedreply", "btn_startinduction", "btn_endinduction"};
    private static String[] BILL_ALL_BUTTONARR = new String[]{"bar_submit", "bar_modify", "bar_save", "bar_unsubmit", "bar_close", "bar_cancel", "bar_delete", "bar_abandon"};

    public static Pair<List<String>, List<String>> getBaseShowButtons(IFormView offerInfoView) {
        ArrayList showButtons = new ArrayList(16);
        ArrayList notShowButtons = new ArrayList(16);
        DynamicObject offerInfo = offerInfoView.getModel().getDataEntity(true);
        List<String> allButtons = OfferBtnShowService.allButtonForBase();
        allButtons.forEach(button -> {
            boolean isShow = false;
            OperationStatus pageStatus = offerInfoView.getFormShowParameter().getStatus();
            switch (button) {
                case "bar_modify": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferEditBaseInfoService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_save": {
                    isShow = pageStatus == OperationStatus.EDIT && OfferBaseSaveService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_submit": {
                    isShow = OfferBaseSubmitService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_delaysend": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferDelaySendService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_chgvalidtime": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferChgValidTimeService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_send": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferBaseSendService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_abandon": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferBaseAbandonService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "bar_close": {
                    isShow = pageStatus != OperationStatus.EDIT;
                    break;
                }
                case "bar_cancel": {
                    isShow = pageStatus == OperationStatus.EDIT;
                    break;
                }
                case "bar_delayedreply": {
                    isShow = OfferDelayReplyService.getInstance().isVisible(offerInfo);
                    break;
                }
                case "btn_startinduction": {
                    isShow = InductionStartService.getInstance().isVisible(offerInfo, offerInfoView);
                    break;
                }
                case "btn_endinduction": {
                    isShow = InductionEndService.getInstance().isVisible(offerInfo, offerInfoView);
                    break;
                }
            }
            if (isShow) {
                showButtons.add(button);
            } else {
                notShowButtons.add(button);
            }
        });
        return Pair.of(showButtons, notShowButtons);
    }

    public static Pair<List<String>, List<String>> getBillShowButtons(IFormView offerApproveView) {
        ArrayList showButtons = new ArrayList(16);
        ArrayList notShowButtons = new ArrayList(16);
        DynamicObject offerBillInfo = OfferBillServiceHelper.getInstance().queryOne(offerApproveView.getModel().getDataEntity().getPkValue());
        List<String> allButtons = OfferBtnShowService.allButtonForBill();
        allButtons.forEach(button -> {
            boolean isShow = false;
            OperationStatus pageStatus = offerApproveView.getFormShowParameter().getStatus();
            switch (button) {
                case "bar_save": {
                    isShow = pageStatus == OperationStatus.EDIT && OfferBillSaveService.getInstance().isVisible(offerBillInfo);
                    break;
                }
                case "bar_submit": {
                    isShow = OfferBillSubmitService.getInstance().isVisible(offerBillInfo);
                    break;
                }
                case "bar_cancel": {
                    isShow = pageStatus == OperationStatus.EDIT;
                    break;
                }
                case "bar_modify": {
                    isShow = pageStatus == OperationStatus.VIEW && OfferEditBillInfoService.getInstance().isVisible(offerBillInfo);
                    break;
                }
                case "bar_unsubmit": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferBillUnSubmitService.getInstance().isVisible(offerBillInfo);
                    break;
                }
                case "bar_delete": {
                    isShow = pageStatus != OperationStatus.EDIT && OfferBillDeleteService.getInstance().isVisible(offerBillInfo);
                    break;
                }
                case "bar_close": {
                    isShow = pageStatus != OperationStatus.EDIT;
                    break;
                }
                case "bar_abandon": {
                    isShow = pageStatus == OperationStatus.VIEW && OfferPermService.getInstance().verifyHasPerm("bar_abandon", "tso_somk_offerbill", (Long)TSCRequestContext.getOrgId()) && OfferBillAbandonService.getInstance().isWaitResubmit(offerBillInfo);
                    break;
                }
            }
            if (isShow) {
                showButtons.add(button);
            } else {
                notShowButtons.add(button);
            }
        });
        return Pair.of(showButtons, notShowButtons);
    }

    public static List<String> allButtonForBase() {
        ArrayList<String> allButtons = new ArrayList<String>(16);
        allButtons.addAll(Arrays.asList(ALL_BUTTONARR));
        return allButtons;
    }

    public static List<String> allButtonForBill() {
        ArrayList<String> allButtons = new ArrayList<String>(16);
        allButtons.addAll(Arrays.asList(BILL_ALL_BUTTONARR));
        return allButtons;
    }
}

