/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.tso.extpoint.IOfferCustomFieldValidate;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferFieldMultiLangConstants;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.util.ValidateUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OfferIntegrateService {
    private static final Log LOG = LogFactory.getLog(OfferIntegrateService.class);

    public static Boolean verifyPhoneAndEmail(DynamicObject offerInfo, IFormView formView) {
        String phone = offerInfo.getString("candidatephone");
        String email = offerInfo.getString("candidateemail");
        if (StringUtils.isEmpty((CharSequence)phone) || StringUtils.isEmpty((CharSequence)email)) {
            String message = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5019\u9009\u4eba\u624b\u673a\u53f7\u7801\u6216\u90ae\u7bb1\u3002", (String)"OfferIntegrateService_2", (String)"tsc-tso-business", (Object[])new Object[0]);
            formView.showTipNotification(message);
            return Boolean.FALSE;
        }
        Pair pair = ValidateUtils.validatePhone((String)phone);
        if (Objects.nonNull(pair) && !((Boolean)pair.getLeft()).booleanValue()) {
            formView.showTipNotification((String)pair.getRight());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean verifySalaryStatus(DynamicObject offerInfo, IFormView view) {
        String salaryType = offerInfo.getString("salarytype");
        String salaryStatus = offerInfo.getString("salarystatus");
        if ("2".equals(salaryType) && !"C".equals(salaryStatus)) {
            String message = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5b8c\u6210\u85aa\u916c\u5b9a\u85aa\u7684Offer\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"OfferIntegrateService_3", (String)"tsc-tso-business", (Object[])new Object[0]);
            view.showTipNotification(message);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean verifyDate(DynamicObject offerInfo, IFormView view) {
        Date pemploymentTime = offerInfo.getDate("pemploymenttime");
        if (Boolean.TRUE.equals(DateUtils.isBefore((Date)pemploymentTime))) {
            String message = ResManager.loadKDString((String)"\u9884\u8ba1\u5165\u804c\u65e5\u671f\u5e94\u5927\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"OfferIntegrateService_4", (String)"tsc-tso-business", (Object[])new Object[0]);
            view.showTipNotification(message);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean verifyHasSalaryPerm(DynamicObject offerInfo, IFormView view, String formId) {
        if ("2".equals(offerInfo.getString("salarytype"))) {
            String message = new OfferSalaryService().verifyHasPerm(offerInfo.getLong("id"), formId);
            if (!HRStringUtils.isEmpty((String)message)) {
                view.showErrorNotification(message);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public static boolean verifyIntegrate(DynamicObject offerInfo, IFormView formView) {
        ThreeTuple<Boolean, List<String>, List<FieldTip>> tuple3 = OfferIntegrateService.verifyIntegrate(offerInfo);
        Boolean success = (Boolean)tuple3.item1;
        List nullFields = (List)tuple3.item2;
        List fieldTips = (List)tuple3.item3;
        if (success.booleanValue()) {
            return true;
        }
        StringBuilder message = new StringBuilder(3);
        int tipNum = nullFields.size();
        for (int i = 0; i < tipNum; ++i) {
            message.append((String)nullFields.get(i));
            if (i == tipNum - 1) continue;
            message.append('\u3001');
        }
        message.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OfferIntegrateService_1", (String)"tsc-tso-business", (Object[])new Object[0]));
        formView.showTipNotification(message.toString());
        if (formView.getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            String offerBillPageId = formView.getPageCache().get("offerInfoPageId");
            if (StringUtils.isNotBlank((CharSequence)offerBillPageId)) {
                IFormView offerInfoView = formView.getView(offerBillPageId);
                offerInfoView.showFieldTips(fieldTips);
                formView.sendFormAction(offerInfoView);
            } else {
                formView.showFieldTips(fieldTips);
            }
        }
        return false;
    }

    public static ThreeTuple<Boolean, List<String>, List<FieldTip>> verifyIntegrate(DynamicObject offerInfo) {
        ArrayList<String> valueNotNullFields = new ArrayList<String>(16);
        ArrayList<FieldTip> fieldTips = new ArrayList<FieldTip>(16);
        if (offerInfo == null) {
            LOG.error("offerInfo is empty");
            return new ThreeTuple((Object)false, valueNotNullFields, fieldTips);
        }
        OfferIntegrateService.verifyJobInfo(offerInfo, valueNotNullFields, fieldTips);
        String salaryType = offerInfo.getString("salarytype");
        if ("1".equals(salaryType)) {
            OfferIntegrateService.verifyRegSalaryInfo(offerInfo, valueNotNullFields, fieldTips);
            OfferIntegrateService.verifyPrpeSalaryInfo(offerInfo, valueNotNullFields, fieldTips);
        }
        LOG.info("OfferIntegrateService.verifyIntegrate before invoke interface valueNotNullFields:{} fieldTips:{}", valueNotNullFields, (Object)fieldTips.size());
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IOfferCustomFieldValidate.class, (String)"kd.sdk.tsc.tso.extpoint.IOfferCustomFieldValidate#doValidateField", null);
        proxy.callReplace(service -> {
            if (service != null) {
                service.doValidateField(offerInfo, fieldTips, valueNotNullFields);
            }
            return null;
        });
        LOG.info("OfferIntegrateService.verifyIntegrate after invoke interface valueNotNullFields:{} fieldTips:{}", valueNotNullFields, (Object)fieldTips.size());
        boolean isSuccess = valueNotNullFields.isEmpty();
        return new ThreeTuple((Object)isSuccess, valueNotNullFields, fieldTips);
    }

    private static void verifyJobInfo(DynamicObject jobInfoObj, List<String> valueNotNullFields, List<FieldTip> fieldTips) {
        String postassignmode = jobInfoObj.getString("postassignmode");
        if (Objects.isNull(postassignmode)) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.assignMode());
            fieldTips.add(OfferIntegrateService.fieldTip("postassignmode"));
        }
        if (!Objects.isNull(postassignmode) && postassignmode.equals("2") && Objects.isNull(jobInfoObj.get("peposition"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.post());
            fieldTips.add(OfferIntegrateService.fieldTip("peposition"));
        }
        if (!Objects.isNull(postassignmode) && postassignmode.equals("3") && Objects.isNull(jobInfoObj.get("pestdposition"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.standardPost());
            fieldTips.add(OfferIntegrateService.fieldTip("pestdposition"));
        }
        if (!Objects.isNull(postassignmode) && postassignmode.equals("1") && Objects.isNull(jobInfoObj.get("pejob"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.position());
            fieldTips.add(OfferIntegrateService.fieldTip("pejob"));
        }
        if (Objects.isNull(jobInfoObj.get("peadminorg"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.peAdminOrg());
            fieldTips.add(OfferIntegrateService.fieldTip("peadminorg"));
        }
        if (Objects.isNull(jobInfoObj.get("positiontype"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.positionType());
            fieldTips.add(OfferIntegrateService.fieldTip("positiontype"));
        }
        if (Objects.isNull(jobInfoObj.get("laborreltypecls"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.laborRelTypeCls());
            fieldTips.add(OfferIntegrateService.fieldTip("laborreltypecls"));
        }
        if (Objects.isNull(jobInfoObj.get("ishaveperiodterm"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.isHavePeriodTerm());
            fieldTips.add(OfferIntegrateService.fieldTip("ishaveperiodterm"));
        }
        if (Objects.isNull(jobInfoObj.get("pemploymenttime"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.peEmploymentTime());
            fieldTips.add(OfferIntegrateService.fieldTip("pemploymenttime"));
        }
        if (Objects.isNull(jobInfoObj.get("depcytype"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.depcyType());
            fieldTips.add(OfferIntegrateService.fieldTip("depcytype"));
        }
        if (OfferUtils.hasPeriodTerm((DynamicObject)jobInfoObj) && jobInfoObj.getInt("pperiodterm") == 0) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.periodTerm());
            FieldTip fieldTip = OfferIntegrateService.fieldTip("pperiodterm");
            fieldTips.add(fieldTip);
        }
        if (Objects.isNull(jobInfoObj.get("emprelationtype"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.laborRelType());
            fieldTips.add(OfferIntegrateService.fieldTip("emprelationtype"));
        }
    }

    private static void verifyRegSalaryInfo(DynamicObject regSalaryInfo, List<String> valueNotNullFields, List<FieldTip> fieldTips) {
        BigDecimal bwages;
        if (Objects.isNull(regSalaryInfo.get("regpaycu"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.regPaycu());
            fieldTips.add(OfferIntegrateService.fieldTip("regpaycu"));
        }
        LOG.info("bwages is null ? :{}", (Object)((bwages = regSalaryInfo.getBigDecimal("regbwages")).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0));
        if (Objects.isNull(bwages) || bwages.compareTo(BigDecimal.ZERO) == 0) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.regBwages());
            fieldTips.add(OfferIntegrateService.fieldTip("regbwages"));
        }
    }

    private static void verifyPrpeSalaryInfo(DynamicObject dataEntity, List<String> valueNotNullFields, List<FieldTip> fieldTips) {
        if (!OfferUtils.hasPeriodTerm((DynamicObject)dataEntity)) {
            return;
        }
        if (Objects.isNull(dataEntity.get("prpepaycu"))) {
            fieldTips.add(OfferIntegrateService.fieldTip("prpepaycu"));
            valueNotNullFields.add(OfferFieldMultiLangConstants.prpePayCu());
        }
        if (HRStringUtils.isEmpty((String)dataEntity.getString("prpesacaltype"))) {
            valueNotNullFields.add(OfferFieldMultiLangConstants.prpeSalType());
        } else {
            String salaryType = dataEntity.getString("prpesacaltype");
            BigDecimal saratio = dataEntity.getBigDecimal("prpesaratio");
            if (HRStringUtils.equals((String)salaryType, (String)"P") && (Objects.isNull(saratio) || saratio.compareTo(BigDecimal.ZERO) == 0)) {
                fieldTips.add(OfferIntegrateService.fieldTip("prpesaratio"));
                valueNotNullFields.add(OfferFieldMultiLangConstants.prpeSalRadio());
            }
            BigDecimal bwages = dataEntity.getBigDecimal("prpebwages");
            if (HRStringUtils.equals((String)salaryType, (String)"F") && (Objects.isNull(bwages) || bwages.compareTo(BigDecimal.ZERO) == 0)) {
                fieldTips.add(OfferIntegrateService.fieldTip("prpebwages"));
                valueNotNullFields.add(OfferFieldMultiLangConstants.prpeBwages());
            }
        }
    }

    private static FieldTip fieldTip(String fieldKey) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, fieldKey, OfferFieldMultiLangConstants.valueNotNull());
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList(fieldKey));
        fieldTip.setDeleteRule(deleteRule);
        return fieldTip;
    }
}

