/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.hr.service.HBJMServiceImpl;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferQFilterHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.enums.offer.OfferPPeriodTermEnum;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.position.service.HbssJobAdapter;
import org.apache.commons.lang3.tuple.Pair;

public class OfferJobInfoService {
    private static final OfferFieldEditSwitchHelper FIELD_EDIT_SWITCH_HELPER = OfferFieldEditSwitchHelper.getInstance();
    private static final OfferServiceHelper OFFER_SERVICE_HELPER = OfferServiceHelper.getInstance();
    private static final Log LOG = LogFactory.getLog(OfferJobInfoService.class);

    public void handlePePositionBeforeF7SelectEvt(IFormView jobInfoView, BeforeF7SelectEvent beforeF7SelectEvent) {
        String postAssignMode = (String)jobInfoView.getModel().getValue("postassignmode");
        if (HRStringUtils.equals((String)postAssignMode, (String)"2")) {
            DynamicObject peAdminorgDy = (DynamicObject)jobInfoView.getModel().getValue("peadminorg");
            QFilter validAndAuditFilter = OfferQFilterHelper.getValidAndAuditFilter();
            validAndAuditFilter.and(new QFilter("adminorg.id", "in", peAdminorgDy.get("id")));
            beforeF7SelectEvent.addCustomQFilter(validAndAuditFilter);
        } else {
            QFilter pePositionFilter = OfferQFilterHelper.getPePositionFilter();
            beforeF7SelectEvent.addCustomQFilter(pePositionFilter);
        }
    }

    public void handlePeAdminOrgBeforeF7SelectEvt(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter pePositionFilter = OfferQFilterHelper.getPeAdminorgFilter();
        beforeF7SelectEvent.addCustomQFilter(pePositionFilter);
    }

    public QFilter handleJobLevelF7SelectEvt(IFormView jobInfoView, BeforeF7SelectEvent beforeF7SelectEvent, boolean getLevelFilter) {
        List<Long> levelRangeIdList = null;
        Pair<Boolean, DynamicObject> pair = this.verifyPePositionIsFromRecruitPosition(jobInfoView);
        if (((Boolean)pair.getLeft()).booleanValue()) {
            DynamicObject dynamicObject = (DynamicObject)pair.getRight();
            DynamicObject lowLevel = dynamicObject.getDynamicObject("lowjoblevel");
            DynamicObject highLevel = dynamicObject.getDynamicObject("highjoblevel");
            levelRangeIdList = lowLevel == null || highLevel == null ? this.handleJobLevelByPeJob(jobInfoView) : HbssJobAdapter.getJobLevelRangeByLevelId((Long)dynamicObject.getLong("id"));
        } else {
            levelRangeIdList = this.handleJobLevelByPeJob(jobInfoView);
        }
        LOG.info("OfferJobInfoService#handleJobLevelF7SelectEvt_levelRangeIdList\uff1a{}", levelRangeIdList);
        DynamicObject peJob = jobInfoView.getModel().getDataEntity(true).getDynamicObject("pejob");
        QFilter levelFilter = new QFilter("id", "in", levelRangeIdList);
        if (peJob != null && (levelRangeIdList == null || levelRangeIdList.isEmpty())) {
            long jobscmId = peJob.getLong("jobscm.id");
            long jobfamilyId = peJob.getLong("jobfamily.id");
            LOG.info("OfferJobInfoService#handleJobLevelF7SelectEvt_jobscmId\uff1a{}", (Object)jobscmId);
            LOG.info("OfferJobInfoService#handleJobLevelF7SelectEvt_jobfamilyId\uff1a{}", (Object)jobfamilyId);
            QFilter jobLevelFilter = HBJMServiceImpl.getJobLevelFilterByJobScmIdsAndJobFamilyIds(Collections.singletonList(jobscmId), Collections.singletonList(jobfamilyId));
            if (jobLevelFilter != null) {
                levelFilter = jobLevelFilter;
            }
        }
        if (!getLevelFilter) {
            beforeF7SelectEvent.addCustomQFilter(levelFilter);
        }
        LOG.info("OfferJobInfoService#handleJobLevelF7SelectEvt_levelFilter\uff1a{}", (Object)levelFilter);
        return levelFilter;
    }

    public QFilter handleJobGradeF7SelectEvt(IFormView jobInfoView, BeforeF7SelectEvent beforeF7SelectEvent, boolean getGradeFilter) {
        List<Long> gradeRangeIdList;
        Pair<Boolean, DynamicObject> pair = this.verifyPePositionIsFromRecruitPosition(jobInfoView);
        if (((Boolean)pair.getLeft()).booleanValue()) {
            DynamicObject dynamicObject = (DynamicObject)pair.getRight();
            DynamicObject lowGrade = dynamicObject.getDynamicObject("lowjobgrade");
            DynamicObject highGrade = dynamicObject.getDynamicObject("highjobgrade");
            gradeRangeIdList = lowGrade == null || highGrade == null ? this.handleJobGradeByPeJob(jobInfoView) : HbssJobAdapter.getJobGradeRangeByGradeId((Long)dynamicObject.getLong("id"));
        } else {
            gradeRangeIdList = this.handleJobGradeByPeJob(jobInfoView);
        }
        DynamicObject peJob = jobInfoView.getModel().getDataEntity(true).getDynamicObject("pejob");
        QFilter gradeFilter = new QFilter("id", "in", gradeRangeIdList);
        if (peJob != null && (gradeRangeIdList == null || gradeRangeIdList.isEmpty())) {
            long jobscmId = peJob.getLong("jobscm.id");
            long jobfamilyId = peJob.getLong("jobfamily.id");
            QFilter jobGradeFilter = HBJMServiceImpl.getJobGradeFilterByJobScmIdsAndJobFamilyIds(Collections.singletonList(jobscmId), Collections.singletonList(jobfamilyId));
            if (jobGradeFilter != null) {
                gradeFilter = jobGradeFilter;
            }
        }
        if (!getGradeFilter) {
            beforeF7SelectEvent.addCustomQFilter(gradeFilter);
        }
        return gradeFilter;
    }

    private Pair<Boolean, DynamicObject> verifyPePositionIsFromRecruitPosition(IFormView formView) {
        Boolean flag = Boolean.FALSE;
        DynamicObject offerBaseInfoDt = formView.getModel().getDataEntity(true);
        DynamicObject peJob = offerBaseInfoDt.getDynamicObject("pejob");
        DynamicObject recruitPosition = offerBaseInfoDt.getDynamicObject("recruposi");
        DynamicObject peJobFromRecruitPosition = recruitPosition.getDynamicObject("entryjob");
        if (peJobFromRecruitPosition == null) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        if (!HRObjectUtils.isEmpty((Object)peJob) && peJobFromRecruitPosition.getLong("id") == peJob.getLong("id")) {
            flag = Boolean.TRUE;
        }
        return Pair.of((Object)flag, (Object)recruitPosition);
    }

    private List<Long> handleJobLevelByPeJob(IFormView jobInfoView) {
        DynamicObject peJob = (DynamicObject)jobInfoView.getModel().getValue("pejob");
        List<Long> rangeIdList = new ArrayList<Long>(8);
        if (Objects.isNull(peJob)) {
            return rangeIdList;
        }
        String jobLevelRange = jobInfoView.getPageCache().get("joblevelrange");
        if (jobLevelRange != null) {
            rangeIdList = SerializationUtils.fromJsonStringToList((String)jobLevelRange, Long.class);
            return rangeIdList;
        }
        Long lowId = OfferUtils.getDynamicObjectFieldId((DynamicObject)peJob, (String)"lowjoblevel");
        Long highId = OfferUtils.getDynamicObjectFieldId((DynamicObject)peJob, (String)"highjoblevel");
        if (lowId.equals(0L) || highId.equals(0L)) {
            return rangeIdList;
        }
        if (lowId.equals(highId)) {
            rangeIdList.add(lowId);
        } else {
            rangeIdList = HbssJobAdapter.getJobLevelRangeByLevelId((Long)peJob.getLong("id"));
        }
        jobInfoView.getPageCache().put("joblevelrange", SerializationUtils.toJsonString(rangeIdList));
        return rangeIdList;
    }

    private List<Long> handleJobGradeByPeJob(IFormView jobInfoView) {
        DynamicObject peJob = (DynamicObject)jobInfoView.getModel().getValue("pejob");
        List<Long> rangeIdList = new ArrayList<Long>(8);
        if (Objects.isNull(peJob)) {
            return rangeIdList;
        }
        String jobLevelRange = jobInfoView.getPageCache().get("jobgraderange");
        if (jobLevelRange != null) {
            rangeIdList = SerializationUtils.fromJsonStringToList((String)jobLevelRange, Long.class);
            return rangeIdList;
        }
        Long lowId = OfferUtils.getDynamicObjectFieldId((DynamicObject)peJob, (String)"lowjobgrade");
        Long highId = OfferUtils.getDynamicObjectFieldId((DynamicObject)peJob, (String)"highjobgrade");
        if (lowId.equals(0L) || highId.equals(0L)) {
            return rangeIdList;
        }
        if (lowId.equals(highId)) {
            rangeIdList.add(lowId);
            return rangeIdList;
        }
        rangeIdList = HbssJobAdapter.getJobGradeRangeByGradeId((Long)peJob.getLong("id"));
        jobInfoView.getPageCache().put("jobgraderange", SerializationUtils.toJsonString(rangeIdList));
        return rangeIdList;
    }

    public void handlePositionTypeF7SelectEvt(IFormView formView, BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter positionTypeFilter = OfferQFilterHelper.getPositionTypeFilter();
        DynamicObject recruitType = (DynamicObject)formView.getModel().getValue("recrutyp");
        if (Objects.isNull(recruitType)) {
            return;
        }
        long recruitTypeId = recruitType.getLong("id");
        if (recruitTypeId == TSOPreDataEnum.RECRUIT_TYPE_NORMAL.getId() || recruitTypeId == TSOPreDataEnum.RECRUIT_TYPE_ELITE.getId()) {
            positionTypeFilter.and(new QFilter("id", "in", Arrays.asList(TSOPreDataEnum.HOLD_OFFICE_TYPE_PART_TIME.getId(), TSOPreDataEnum.HOLD_OFFICE_TYPE_FULL_TIME.getId(), TSOPreDataEnum.HOLD_OFFICE_TYPE_OTHER_TIME.getId())));
        }
        beforeF7SelectEvent.addCustomQFilter(positionTypeFilter);
    }

    public void handleJobScmBeforeF7SelectEvt(BeforeF7SelectEvent beforeF7SelectEvent, IFormView formView) {
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        DynamicObject busunit = dataEntity.getDynamicObject("busunit");
        beforeF7SelectEvent.setCustomQFilters(OfferQFilterHelper.getJobScmFilter(busunit.getLong("id")));
    }

    public void handlePeJobBeforeF7SelectEvt(BeforeF7SelectEvent beforeF7SelectEvent, IFormView jobInfoView) {
        DynamicObject jobInfo = jobInfoView.getModel().getDataEntity(true);
        DynamicObject jobScm = jobInfo.getDynamicObject("jobscm");
        if (Objects.isNull(jobScm)) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCustomParam("selectedRowIds", (Object)String.valueOf(jobScm.getLong("id")));
        DynamicObject busunit = jobInfoView.getModel().getDataEntity(true).getDynamicObject("busunit");
        beforeF7SelectEvent.setCustomQFilters(OfferQFilterHelper.getPeJobFilter(busunit.getLong("id")));
    }

    public void handleEmpRelationTypeBeforeF7SelectEvt(BeforeF7SelectEvent beforeF7SelectEvent, IFormView jobInfoView) {
        DynamicObject value = (DynamicObject)jobInfoView.getModel().getValue("laborreltypecls");
        if (null == value) {
            return;
        }
        DynamicObject[] mappingEmpRelationType = OFFER_SERVICE_HELPER.getMappingEmpRelationType(value.getLong("id"));
        List<Long> results = Arrays.stream(mappingEmpRelationType).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        beforeF7SelectEvent.setCustomQFilters(Arrays.asList(OfferQFilterHelper.getEmpRelationTypeFilter(results).toArray()));
    }

    public void handlePeStdPositionPropertyChangedEvt(IFormView jobInfoView) {
        Object newValue = jobInfoView.getModel().getValue("pestdposition");
        if (newValue == null) {
            this.handlePeStdPositionPropertyChangeEvtWhenPeStdPositionIsNull(jobInfoView);
        } else {
            this.handlePeStdPositionPropertyChangedWhenIsNotNull(jobInfoView, (DynamicObject)newValue);
        }
    }

    private void handlePeStdPositionPropertyChangeEvtWhenPeStdPositionIsNull(IFormView jobInfoView) {
        OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "pestdposition");
        OfferFieldEnableEnum jobScmEnable = FIELD_EDIT_SWITCH_HELPER.getInfoFormCache(jobInfoView, "jobscm");
        if (jobScmEnable == OfferFieldEnableEnum.NOT_ENABLE) {
            OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobscm");
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "jobscm");
        }
    }

    private void handlePeStdPositionPropertyChangedWhenIsNotNull(IFormView jobInfoView, DynamicObject PeStdPosition) {
        Object value = jobInfoView.getModel().getValue("postassignmode");
        if (!"1".equals(value)) {
            DynamicObject peJobFromPosition = PeStdPosition.getDynamicObject("job");
            if (peJobFromPosition != null) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
                DynamicObject jobDyn = serviceHelper.queryOne("jobscm", (Object)peJobFromPosition.getLong("id"));
                long jobScmId = jobDyn.getDynamicObject("jobscm") == null ? 0L : jobDyn.getDynamicObject("jobscm").getLong("id");
                jobInfoView.getModel().setValue("jobscm", (Object)jobScmId);
                jobInfoView.getModel().setValue("pejob", (Object)peJobFromPosition.getLong("id"));
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "pejob", "jobscm");
            } else {
                OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobscm");
                if ("tso_somk_offerapproveinfo".equals(jobInfoView.getFormShowParameter().getFormId())) {
                    OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "pejob");
                    this.handlePeJobPropertyChangedEvt(jobInfoView);
                }
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "jobscm", "pejob");
            }
        } else {
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "jobscm", "pejob");
        }
    }

    public void handlePepositionPropertyChangedEvt(PropertyChangedArgs propertyChangedArgs, IFormView jobInfoView) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            this.handlePepositionPropertyChangeEvtWhenPepositionIsNull(jobInfoView);
        } else {
            this.handlePepositionPropertyChangedWhenIsNotNull(jobInfoView, (DynamicObject)newValue);
        }
    }

    private void handlePepositionPropertyChangedWhenIsNotNull(IFormView jobInfoView, DynamicObject pePosition) {
        Object value = jobInfoView.getModel().getValue("postassignmode");
        if (!"1".equals(value)) {
            DynamicObject peJobFromPosition = pePosition.getDynamicObject("job");
            if (!HRObjectUtils.isEmpty((Object)peJobFromPosition)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
                DynamicObject jobDyn = serviceHelper.queryOne("jobscm", (Object)peJobFromPosition.getLong("id"));
                long jobScmId = jobDyn.getDynamicObject("jobscm") == null ? 0L : jobDyn.getDynamicObject("jobscm").getLong("id");
                jobInfoView.getModel().setValue("jobscm", (Object)jobScmId);
                jobInfoView.getModel().setValue("pejob", (Object)peJobFromPosition.getLong("id"));
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "pejob", "jobscm");
            } else {
                OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobscm");
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "jobscm", "pejob");
            }
        } else {
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "jobscm", "pejob");
        }
    }

    private void handlePepositionPropertyChangeEvtWhenPepositionIsNull(IFormView jobInfoView) {
        OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "peposition");
        OfferFieldEnableEnum jobScmEnable = FIELD_EDIT_SWITCH_HELPER.getInfoFormCache(jobInfoView, "jobscm");
        if (jobScmEnable == OfferFieldEnableEnum.NOT_ENABLE) {
            OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobscm");
        }
    }

    public void handlePeAdminOrgPropertyChangedEvt(IFormView jobInfoView) {
        Object newValue = jobInfoView.getModel().getValue("peadminorg");
        jobInfoView.getModel().setValue("supervisor", null);
        if (newValue == null) {
            OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "pecompany", "peposition");
            jobInfoView.setEnable(Boolean.valueOf(false), new String[]{"peposition"});
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "peposition");
        } else {
            DynamicObject peAdminOrg = (DynamicObject)newValue;
            DynamicObject peCompany = peAdminOrg.getDynamicObject("company");
            jobInfoView.getModel().setValue("pecompany", (Object)peCompany);
            String postAssignMode = (String)jobInfoView.getModel().getValue("postassignmode");
            if (HRStringUtils.equals((String)postAssignMode, (String)"2")) {
                OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "peposition");
                jobInfoView.setEnable(Boolean.valueOf(true), new String[]{"peposition"});
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "peposition");
            }
        }
    }

    public void handleJobScmPropertyChangedEvt(IFormView jobInfoView) {
        OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "pejob");
    }

    public void handlePeJobPropertyChangedEvt(IFormView jobInfoView) {
        QFilter jobGradeQFilter;
        ArrayList jobGradeList;
        Object newValue = jobInfoView.getModel().getValue("pejob");
        OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobgrade", "joblevel");
        jobInfoView.getPageCache().put("jobgraderange", null);
        jobInfoView.getPageCache().put("joblevelrange", null);
        OfferFieldEnableEnum enableEnum = newValue == null ? OfferFieldEnableEnum.NOT_ENABLE : OfferFieldEnableEnum.ENABLE;
        FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(enableEnum, jobInfoView, "joblevel", "jobgrade");
        QFilter jobLevelQFilter = this.handleJobLevelF7SelectEvt(jobInfoView, null, true);
        ArrayList jobLevelList = (ArrayList)jobLevelQFilter.getValue();
        if (1 == jobLevelList.size()) {
            jobInfoView.getModel().setValue("joblevel", jobLevelList.get(0));
            this.handleJobLevelByPeJob(jobInfoView);
        }
        if (1 == (jobGradeList = (ArrayList)(jobGradeQFilter = this.handleJobGradeF7SelectEvt(jobInfoView, null, true)).getValue()).size()) {
            jobInfoView.getModel().setValue("jobgrade", jobGradeList.get(0));
            this.handleJobGradeByPeJob(jobInfoView);
        }
    }

    public void handleLaborrelTypeClsPropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView formView) {
        DynamicObject newValue = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (newValue != null) {
            formView.getModel().setValue("emprelationtype", null);
            long newId = newValue.getLong("id");
            DecimalEdit prpeBwagesEdit = (DecimalEdit)formView.getControl("prpebwages");
            DecimalEdit prpeSaratioEdit = (DecimalEdit)formView.getControl("prpesaratio");
            if (newId == TSOPreDataEnum.LABORRELRELTYPECLS_LABOR.getId() || newId == TSOPreDataEnum.LABORRELRELTYPECLS_EMPLOY.getId() || newId == TSOPreDataEnum.LABORRELRELTYPECLS_OUT.getId()) {
                formView.getModel().setValue("ishaveperiodterm", (Object)"1");
                prpeBwagesEdit.setMustInput(true);
                prpeSaratioEdit.setMustInput(true);
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, formView, "flex_haveperiodterm");
            } else if (newId == TSOPreDataEnum.LABORRELRELTYPECLS_REHIRE.getId() || newId == TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId()) {
                prpeBwagesEdit.setMustInput(false);
                prpeSaratioEdit.setMustInput(false);
                OFFER_SERVICE_HELPER.setControlToNull(formView.getModel(), "prpebwages", "prpesaratio");
                formView.getModel().setValue("ishaveperiodterm", (Object)"0");
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, formView, "flex_haveperiodterm");
            }
            DynamicObject[] mappingEmpRelationType = OFFER_SERVICE_HELPER.getMappingEmpRelationType(newId);
            if (mappingEmpRelationType.length == 1) {
                formView.getModel().setValue("emprelationtype", (Object)mappingEmpRelationType[0]);
            }
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, formView, "emprelationtype");
        } else {
            formView.getModel().setValue("ishaveperiodterm", (Object)"0");
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, formView, "flex_haveperiodterm", "emprelationtype");
            formView.getModel().setValue("ishaveperiodterm", (Object)"");
            formView.getModel().setValue("emprelationtype", null);
        }
    }

    public void handleHavePeriodTermPropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView formView) {
        String newValue = (String)propertyChangedArgs.getChangeSet()[0].getNewValue();
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        DecimalEdit pPeriodTermEdit = (DecimalEdit)formView.getControl("pperiodterm");
        DecimalEdit prpeBwagesEdit = (DecimalEdit)formView.getControl("prpebwages");
        DecimalEdit prpeSaratioEdit = (DecimalEdit)formView.getControl("prpesaratio");
        if ("1".equals(newValue)) {
            pPeriodTermEdit.setMustInput(true);
            prpeBwagesEdit.setMustInput(true);
            prpeSaratioEdit.setMustInput(true);
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, formView, "pperiodterm", "pperiodtermunit");
            if ("1".equals(dataEntity.getString("salarytype"))) {
                formView.setVisible(Boolean.TRUE, new String[]{"prpesalaryinfo"});
            } else {
                formView.setVisible(Boolean.FALSE, new String[]{"prpesalaryinfo"});
            }
            formView.setVisible(Boolean.TRUE, new String[]{"pperiodtermunit", "pperiodterm", "flexpanelap2"});
            dataEntity.set("labrelstatuscls", (Object)TSOPreDataEnum.LABRESTATULCLS_PROBATION.getId());
        } else {
            pPeriodTermEdit.setMustInput(false);
            prpeBwagesEdit.setMustInput(false);
            prpeSaratioEdit.setMustInput(false);
            OFFER_SERVICE_HELPER.setControlToNull(formView.getModel(), "prpebwages", "prpesaratio", "pperiodterm");
            dataEntity.set("labrelstatuscls", (Object)TSOPreDataEnum.LABRESTATULCLS_ONBOARDING.getId());
            this.handlePrpeInfoWhenNotHaveProbation(formView, pPeriodTermEdit);
        }
    }

    private void handlePrpeInfoWhenNotHaveProbation(IFormView formView, DecimalEdit pPeriodTermEdit) {
        OFFER_SERVICE_HELPER.setControlToNull(formView.getModel(), "pperiodterm");
        OFFER_SERVICE_HELPER.setControlToNull(formView.getModel(), "prpebwages", "prpemonthly", "prpeprp", "prpepossub", "prperemark", "prpesacaltype", "prpesaratio");
        pPeriodTermEdit.setMustInput(false);
        formView.setVisible(Boolean.FALSE, new String[]{"pperiodtermunit", "pperiodterm", "prpesalaryinfo"});
    }

    public void handlePeriodTermUnitPropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView jobInfoView) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String pPeriodTermUnitNewValue = String.valueOf(changeData.getNewValue());
        if (HRStringUtils.isEmpty((String)pPeriodTermUnitNewValue)) {
            return;
        }
        Object pPeriodTermObj = jobInfoView.getModel().getValue("pperiodterm");
        if (pPeriodTermObj == null) {
            return;
        }
        int pPeriodTerm = (Integer)pPeriodTermObj;
        Pair<Boolean, Integer> pair = this.getPeriodTermInDataRange(pPeriodTermUnitNewValue, pPeriodTerm);
        if (!((Boolean)pair.getLeft()).booleanValue()) {
            jobInfoView.getModel().setValue("pperiodterm", pair.getRight());
        }
    }

    public void handlePeriodTermPropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView jobInfoView) {
        String pPeriodTermUnit = (String)jobInfoView.getModel().getValue("pperiodtermunit");
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        if (changeData.getNewValue() == null) {
            return;
        }
        int pPeriodTerm = (Integer)changeData.getNewValue();
        Pair<Boolean, Integer> pair = this.getPeriodTermInDataRange(pPeriodTermUnit, pPeriodTerm);
        if (!((Boolean)pair.getLeft()).booleanValue()) {
            jobInfoView.getModel().setValue("pperiodterm", pair.getRight());
        }
    }

    public void handlePostAssignModePropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView jobInfoView) {
        BasedataEdit peStdPosition;
        BasedataEdit pejob;
        IDataModel model = jobInfoView.getModel();
        model.setValue("peposition", null);
        model.setValue("pestdposition", null);
        model.setValue("jobscm", null);
        model.setValue("pejob", null);
        model.setValue("joblevel", null);
        model.setValue("jobgrade", null);
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (null == newValue) {
            return;
        }
        String postMode = newValue.toString();
        if ("2".equals(postMode)) {
            BasedataEdit pePosition = (BasedataEdit)jobInfoView.getControl("peposition");
            pePosition.setMustInput(true);
            pejob = (BasedataEdit)jobInfoView.getControl("pejob");
            pejob.setMustInput(false);
            jobInfoView.setVisible(Boolean.TRUE, new String[]{"peposition", "jobscm"});
            jobInfoView.setVisible(Boolean.FALSE, new String[]{"pestdposition"});
            DynamicObject peAdminOrgValue = (DynamicObject)jobInfoView.getModel().getValue("peadminorg");
            if (HRObjectUtils.isEmpty((Object)peAdminOrgValue)) {
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "peposition");
            } else {
                FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "peposition");
                DynamicObject peCompany = peAdminOrgValue.getDynamicObject("company");
                jobInfoView.getModel().setValue("pecompany", (Object)peCompany);
            }
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "pejob", "jobscm", "pecompany");
            jobInfoView.setEnable(Boolean.valueOf(false), new String[]{"pejob", "jobscm", "pecompany"});
        }
        if ("3".equals(postMode)) {
            peStdPosition = (BasedataEdit)jobInfoView.getControl("pestdposition");
            peStdPosition.setMustInput(true);
            pejob = (BasedataEdit)jobInfoView.getControl("pejob");
            pejob.setMustInput(false);
            jobInfoView.setVisible(Boolean.FALSE, new String[]{"peposition"});
            jobInfoView.setVisible(Boolean.TRUE, new String[]{"pestdposition", "jobscm"});
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "peadminorg");
            jobInfoView.setEnable(Boolean.valueOf(true), new String[]{"peadminorg"});
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "pejob", "jobscm", "pecompany");
            jobInfoView.setEnable(Boolean.FALSE, new String[]{"pejob", "jobscm", "pecompany"});
        }
        if ("1".equals(postMode)) {
            OFFER_SERVICE_HELPER.setControlToNull(jobInfoView.getModel(), "jobscm");
            peStdPosition = (BasedataEdit)jobInfoView.getControl("pejob");
            peStdPosition.setMustInput(true);
            jobInfoView.setEnable(Boolean.valueOf(true), new String[]{"pejob", "peadminorg"});
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.ENABLE, jobInfoView, "pejob", "peadminorg");
            jobInfoView.setVisible(Boolean.FALSE, new String[]{"peposition", "pestdposition", "jobscm"});
            FIELD_EDIT_SWITCH_HELPER.updateFieldSrcToPageCache(OfferFieldEnableEnum.NOT_ENABLE, jobInfoView, "pecompany");
            jobInfoView.setEnable(Boolean.valueOf(false), new String[]{"pecompany"});
        }
    }

    private Pair<Boolean, Integer> getPeriodTermInDataRange(String pPeriodTermUnit, int pPeriodTerm) {
        if (pPeriodTerm == 0) {
            return Pair.of((Object)Boolean.TRUE, (Object)pPeriodTerm);
        }
        Pair<Boolean, Integer> pair = HRStringUtils.equals((String)pPeriodTermUnit, (String)OfferPPeriodTermEnum.MONTH.getCode()) ? this.verifyPeriodTermRange(OfferPPeriodTermEnum.MONTH, pPeriodTerm) : (HRStringUtils.equals((String)pPeriodTermUnit, (String)OfferPPeriodTermEnum.DAY.getCode()) ? this.verifyPeriodTermRange(OfferPPeriodTermEnum.DAY, pPeriodTerm) : (HRStringUtils.equals((String)pPeriodTermUnit, (String)OfferPPeriodTermEnum.WEEK.getCode()) ? this.verifyPeriodTermRange(OfferPPeriodTermEnum.WEEK, pPeriodTerm) : this.verifyPeriodTermRange(OfferPPeriodTermEnum.MONTH, pPeriodTerm)));
        return pair;
    }

    private Pair<Boolean, Integer> verifyPeriodTermRange(OfferPPeriodTermEnum offerPeriodTermEnum, int pPeriodTerm) {
        int pPeriodTermFinal = pPeriodTerm;
        boolean flag = true;
        if (pPeriodTerm < 1) {
            pPeriodTermFinal = 1;
            flag = false;
        }
        switch (offerPeriodTermEnum) {
            case DAY: {
                if (pPeriodTerm <= 180) break;
                pPeriodTermFinal = 180;
                flag = false;
                break;
            }
            case WEEK: {
                if (pPeriodTerm <= 24) break;
                pPeriodTermFinal = 24;
                flag = false;
                break;
            }
            case MONTH: {
                if (pPeriodTerm <= 6) break;
                pPeriodTermFinal = 6;
                flag = false;
                break;
            }
        }
        return Pair.of((Object)flag, (Object)pPeriodTermFinal);
    }

    public static OfferJobInfoService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferJobInfoService() {
    }

    private static class Instance {
        private static final OfferJobInfoService INSTANCE = new OfferJobInfoService();

        private Instance() {
        }
    }
}

