/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.constants.offer.base.OfferConstants;

public class OfferKeyWordsChangeService
implements OfferConstants {
    private static final Log LOGGER = LogFactory.getLog(OfferKeyWordsChangeService.class);
    private static final Set<String> KEY_WORD_SET = Sets.newHashSetWithExpectedSize((int)32);
    private static final String CACHE_KEY = "keyWordSetCache";

    public static void cacheKeyWordChangeRecord(IFormView formView, String word) {
        if (formView == null) {
            LOGGER.error("formView cannot be null");
            return;
        }
        if (!KEY_WORD_SET.contains(word)) {
            return;
        }
        Set<String> keyWordList = OfferKeyWordsChangeService.getKeyWordList(formView);
        keyWordList.add(word);
        OfferKeyWordsChangeService.putToPageCache(formView, keyWordList);
    }

    public static Set<String> getKeyWordList(IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String keyWordListStr = pageCache.get(CACHE_KEY);
        Set keyWordList = HRStringUtils.isEmpty((String)keyWordListStr) ? Sets.newHashSetWithExpectedSize((int)1) : (Set)JSON.parseObject((String)keyWordListStr, Set.class);
        return keyWordList;
    }

    public static List<String> getKeyWordNameList(IFormView formView) {
        Set<String> keyWordList = OfferKeyWordsChangeService.getKeyWordList(formView);
        ArrayList<String> keyWordNameList = new ArrayList<String>(keyWordList.size());
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        keyWordList.forEach(keyWord -> keyWordNameList.add(OfferKeyWordsChangeService.getNickName(dataEntity, keyWord)));
        return keyWordNameList;
    }

    private static String getNickName(DynamicObject dynamicObject, String keyWord) {
        String keyWordName = dynamicObject.getDynamicObjectType().getProperty(keyWord).getDisplayName().getLocaleValue();
        if (HRStringUtils.equals((String)keyWord, (String)"regpaycu")) {
            keyWordName = ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b\uff08\u85aa\u8d44\u4fe1\u606f\uff09", (String)"OfferKeyWordsChangeService_0", (String)"tsc-tso-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)keyWord, (String)"prpepaycu")) {
            keyWordName = ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b\uff08\u8bd5\u7528\u671f\uff09", (String)"OfferKeyWordsChangeService_1", (String)"tsc-tso-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)keyWord, (String)"welpaycu")) {
            keyWordName = ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b\uff08\u798f\u5229\u4fe1\u606f\uff09", (String)"OfferKeyWordsChangeService_2", (String)"tsc-tso-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)keyWord, (String)"rsyearvalue") || HRStringUtils.equals((String)keyWord, (String)"rsyearcu")) {
            keyWordName = dynamicObject.getDynamicObjectType().getProperty("rsyearvalue").getDisplayName().getLocaleValue();
        }
        if (HRStringUtils.equals((String)keyWord, (String)"optionnum") || HRStringUtils.equals((String)keyWord, (String)"optioncu")) {
            keyWordName = dynamicObject.getDynamicObjectType().getProperty("optionnum").getDisplayName().getLocaleValue();
        }
        return keyWordName;
    }

    private static void putToPageCache(IFormView formView, Set<String> keyWordList) {
        IPageCache pageCache = formView.getPageCache();
        pageCache.put(CACHE_KEY, JSON.toJSONString(keyWordList));
    }

    static {
        KEY_WORD_SET.add("peposition");
        KEY_WORD_SET.add("peadminorg");
        KEY_WORD_SET.add("supervisor");
        KEY_WORD_SET.add("jobscm");
        KEY_WORD_SET.add("pejob");
        KEY_WORD_SET.add("joblevel");
        KEY_WORD_SET.add("jobgrade");
        KEY_WORD_SET.add("placework");
        KEY_WORD_SET.add("positiontype");
        KEY_WORD_SET.add("laborreltypecls");
        KEY_WORD_SET.add("pemploymenttime");
        KEY_WORD_SET.add("regpaycu");
        KEY_WORD_SET.add("regbwages");
        KEY_WORD_SET.add("regpossub");
        KEY_WORD_SET.add("regprp");
        KEY_WORD_SET.add("regyearbonus");
        KEY_WORD_SET.add("welpaycu");
        KEY_WORD_SET.add("trafaow");
        KEY_WORD_SET.add("tietaryaow");
        KEY_WORD_SET.add("municataow");
        KEY_WORD_SET.add("rentalaow");
        KEY_WORD_SET.add("housaow");
        KEY_WORD_SET.add("rsnum");
        KEY_WORD_SET.add("rsyearvalue");
        KEY_WORD_SET.add("rsyearcu");
        KEY_WORD_SET.add("optionnum");
        KEY_WORD_SET.add("optioncu");
        KEY_WORD_SET.add("optionyearvalue");
        KEY_WORD_SET.add("template");
        KEY_WORD_SET.add("pperiodterm");
        KEY_WORD_SET.add("prpepaycu");
        KEY_WORD_SET.add("prpemonthly");
    }
}

