/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;

public class OfferPermService {
    private static final Log logger = LogFactory.getLog(OfferPermService.class);
    private static final Map<String, String> PERM_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final String KEY_NEW_OFFER = "btn_new_offer";
    public static final String EDIT_PERM = "4715a0df000000ac";
    public static final String ABANDON_PERM = "0=KX5+R7YTRT";
    public static final String RESEND_PERM = "1IR6ID9X8/GP";
    public static final String SEND_PERM = "1IR6ID9X8/GP";
    public static final String DELAY_SEND_PERM = "2209ZWI4D5RL";
    public static final String VIEW_PERM = "47150e89000000ac";
    public static final String NEW_OFFER_PERM = "1IR6LQ/8AA+B";
    public static final String SAVE_PERM = "0=KX5+QVF5+R";
    public static final String DELETE_PERM = "4715e1f1000000ac";
    public static final String EXPORTLIST_PERM = "4730fc9f000004ae";
    public static final String SUBMIT_PERM = "804f6478000000ac";
    public static final String UNSUBMIT_PERM = "80513207000000ac";
    public static final String CHANGE_VALID_TIME_PERM = "220=3A=3P719";
    public static final String END_INDUCTION = "2NPTLZ+CG1+/";
    public static final String START_INDUCTION = "2NPTJV=VDLVR";
    public static final String GET_OFFER = "2OI4=1O5+Y7U";
    public static final String COPY_PERM = "4730fc9f000020ae";
    public static final String DELAY_REPLY = "2FTUW+B4TJZ2";

    public boolean verifyHasAppFilePerm(DynamicObject offerInfo) {
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        if (HRObjectUtils.isEmpty((Object)appFile)) {
            logger.error("appFile is empty");
            return false;
        }
        DynamicObject recruitType = offerInfo.getDynamicObject("recrutyp");
        if (HRObjectUtils.isEmpty((Object)recruitType)) {
            logger.error("recruitType is empty");
            return false;
        }
        String openAppFileEntity = RsmCommonService.getOpenAppFileEntityId((Object)appFile.getLong("id"));
        return !"".equals(openAppFileEntity);
    }

    public boolean verifyHasPerm(String operateCode, String entityId, Long useOrgId) {
        String appId = AppMetadataCache.getAppInfo((String)"tsrsc").getId();
        int hasPerm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)useOrgId, (String)appId, (String)entityId, (String)PERM_MAP.get(operateCode));
        logger.info("verifyHasFunctionPerm,userName:{},appId:{},entity:{},operateCode:{},userOrgId:{};perm:{}", new Object[]{TSCRequestContext.getUserName(), appId, entityId, operateCode, useOrgId, hasPerm});
        return hasPerm == 1;
    }

    public List<String> verifyHasPerm(List<String> operateCodeList, String entityId, long userOrgId) {
        ArrayList hasPermItems = new ArrayList(operateCodeList.size());
        return operateCodeList.stream().filter(operateCode -> {
            String operatePermItem = PERM_MAP.get(operateCode);
            if (hasPermItems.contains(operatePermItem)) {
                return true;
            }
            boolean hasPerm = this.verifyHasPerm((String)operateCode, entityId, (Long)userOrgId);
            if (hasPerm) {
                hasPermItems.add(operatePermItem);
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static boolean verifyHasPerm(String operateCode, String entityId, Long useOrgId, String appId) {
        if (HRStringUtils.isEmpty((String)operateCode)) {
            return false;
        }
        if (HRStringUtils.isEmpty((String)entityId)) {
            return false;
        }
        if (useOrgId == null) {
            return false;
        }
        if (HRStringUtils.isEmpty((String)appId)) {
            return false;
        }
        int hasPerm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)useOrgId, (String)appId, (String)entityId, (String)PERM_MAP.get(operateCode));
        logger.info("OfferPermService.verifyHasPerm userOrgId:{}, perm:{}", (Object)useOrgId, (Object)hasPerm);
        return hasPerm == 1;
    }

    public static OfferPermService getInstance() {
        return Instance.OFFER_PERM_INSTANCE;
    }

    private OfferPermService() {
    }

    static {
        PERM_MAP.put("bar_modify", EDIT_PERM);
        PERM_MAP.put("bar_save", SAVE_PERM);
        PERM_MAP.put("bar_abandon", ABANDON_PERM);
        PERM_MAP.put("bar_resend", "1IR6ID9X8/GP");
        PERM_MAP.put("bar_send", "1IR6ID9X8/GP");
        PERM_MAP.put("bar_delete", DELETE_PERM);
        PERM_MAP.put("btn_view", VIEW_PERM);
        PERM_MAP.put(KEY_NEW_OFFER, NEW_OFFER_PERM);
        PERM_MAP.put("exportlist", EXPORTLIST_PERM);
        PERM_MAP.put("bar_submit", SUBMIT_PERM);
        PERM_MAP.put("bar_unsubmit", UNSUBMIT_PERM);
        PERM_MAP.put("bar_chgvalidtime", CHANGE_VALID_TIME_PERM);
        PERM_MAP.put("bar_delaysend", DELAY_SEND_PERM);
        PERM_MAP.put("bar_copy", COPY_PERM);
        PERM_MAP.put("bar_delayedreply", DELAY_REPLY);
        PERM_MAP.put("btn_startinduction", START_INDUCTION);
        PERM_MAP.put("btn_endinduction", END_INDUCTION);
        PERM_MAP.put("btn_getoffer", GET_OFFER);
    }

    private static class Instance {
        private static OfferPermService OFFER_PERM_INSTANCE = new OfferPermService();

        private Instance() {
        }
    }
}

