/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tspr.business.domain.rpc.impl.HsbsRpcServiceImpl;
import kd.tsc.tspr.common.dto.response.CommonRespDTO;

public class OfferSalaryService {
    private static final Log log = LogFactory.getLog(OfferSalaryService.class);

    public DynamicObject[] getJobHrData(List<Long> jobId) {
        QFilter hisVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter jobIdFilter = new QFilter("id", "in", jobId);
        HRBaseServiceHelper jobHelper = new HRBaseServiceHelper("hbjm_jobhr");
        return jobHelper.queryOriginalArray("id,name,number,jobclass,jobfamily,jobseq,jobscm,createorg", new QFilter[]{hisVersionFilter, statusFilter, enableFilter, jobIdFilter});
    }

    public Map<String, Object> buildSalaryParam(IFormView view) {
        Long highestEducation;
        Date pemployMentTime;
        String isHavePeriodTerm;
        DynamicObject placeWork;
        DynamicObject empRelationType;
        DynamicObject jobLevel;
        DynamicObject jobGrade;
        DynamicObject pestdPosition;
        DynamicObject pePosition;
        DynamicObject jobScmDyn;
        DynamicObject peJob;
        DynamicObject peadminOrg;
        DynamicObject peCompany;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DynamicObject recruTyp = view.getModel().getDataEntity(true).getDynamicObject("recrutyp");
        if (!HRObjectUtils.isEmpty((Object)recruTyp)) {
            paramMap.put("recrutyp", recruTyp.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(peCompany = (DynamicObject)view.getModel().getValue("pecompany")))) {
            paramMap.put("pecompany", peCompany.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(peadminOrg = (DynamicObject)view.getModel().getValue("peadminorg")))) {
            paramMap.put("peadminorg", peadminOrg.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(peJob = (DynamicObject)view.getModel().getValue("pejob")))) {
            paramMap.put("pejob", peJob.getLong("id"));
            DynamicObject[] jobHrData = this.getJobHrData(Lists.newArrayList((Object[])new Long[]{peJob.getLong("id")}));
            if (0 < jobHrData.length) {
                DynamicObject jobHrDatum = jobHrData[0];
                Long jobseq = jobHrDatum.getLong("jobseq");
                paramMap.put("jobseq", jobseq);
                Long jobFamily = jobHrDatum.getLong("jobfamily");
                paramMap.put("jobfamily", jobFamily);
                Long jobClass = jobHrDatum.getLong("jobclass");
                paramMap.put("jobclass", jobClass);
                Long jobScm = jobHrDatum.getLong("jobscm");
                paramMap.put("jobscm", jobScm);
            }
        }
        if (!HRObjectUtils.isEmpty((Object)(jobScmDyn = (DynamicObject)view.getModel().getValue("jobscm")))) {
            paramMap.put("jobscm", jobScmDyn.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(pePosition = (DynamicObject)view.getModel().getValue("peposition")))) {
            paramMap.put("peposition", pePosition.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(pestdPosition = (DynamicObject)view.getModel().getValue("pestdposition")))) {
            paramMap.put("pestdposition", pestdPosition.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(jobGrade = (DynamicObject)view.getModel().getValue("jobgrade")))) {
            paramMap.put("jobgrade", jobGrade.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(jobLevel = (DynamicObject)view.getModel().getValue("joblevel")))) {
            paramMap.put("joblevel", jobLevel.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(empRelationType = (DynamicObject)view.getModel().getValue("emprelationtype")))) {
            paramMap.put("emprelationtype", empRelationType.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(placeWork = (DynamicObject)view.getModel().getValue("placework")))) {
            paramMap.put("placework", placeWork.getLong("id"));
        }
        if (HRStringUtils.isNotEmpty((String)(isHavePeriodTerm = view.getModel().getDataEntity().getString("ishaveperiodterm")))) {
            paramMap.put("ishaveperiodterm", isHavePeriodTerm);
        }
        if ("1".equals(isHavePeriodTerm)) {
            String pperiodTerm;
            String pperiodTermUnit = view.getModel().getDataEntity().getString("pperiodtermunit");
            if (HRStringUtils.isNotEmpty((String)pperiodTermUnit)) {
                paramMap.put("pperiodtermunit", pperiodTermUnit);
            }
            if (HRStringUtils.isNotEmpty((String)(pperiodTerm = view.getModel().getDataEntity().getString("pperiodterm")))) {
                paramMap.put("pperiodterm", pperiodTerm);
            }
        }
        if (null != (pemployMentTime = view.getModel().getDataEntity().getDate("pemploymenttime"))) {
            paramMap.put("pemploymenttime", pemployMentTime);
        }
        if (!HRObjectUtils.isEmpty((Object)(highestEducation = Long.valueOf(view.getModel().getDataEntity().getLong("highesteducation.id"))))) {
            paramMap.put("highesteducation", highestEducation);
        }
        return paramMap;
    }

    public Map<String, Object> saveSalary(IFormView view, String operation) {
        DynamicObject dataEntity = null;
        if ("tso_somk_offerapproveinfo".equals(view.getFormShowParameter().getFormId())) {
            long offerId = ((DynamicObject)view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0)).getLong("offer.id");
            dataEntity = OfferServiceHelper.getInstance().queryOne(offerId);
        } else {
            dataEntity = view.getModel().getDataEntity(true);
        }
        String salaryType = dataEntity.getString("salarytype");
        Map<String, Object> resultMap = new HashMap<String, Object>(2);
        if ("2".equals(salaryType)) {
            DynamicObject salaryDataEntity = null;
            try {
                String salaryPageId = view.getPageCache().get("salary" + dataEntity.getString("id"));
                if (HRStringUtils.isEmpty((String)salaryPageId)) {
                    String offerBasePageId = view.getPageCache().get("offerInfoPageId");
                    IFormView offerBaseView = view.getView(offerBasePageId);
                    salaryPageId = offerBaseView.getPageCache().get("salary" + dataEntity.getString("id"));
                    salaryDataEntity = offerBaseView.getViewNoPlugin(salaryPageId).getModel().getDataEntity(true);
                } else {
                    salaryDataEntity = view.getViewNoPlugin(salaryPageId).getModel().getDataEntity(true);
                }
            }
            catch (Exception e) {
                log.info("saveSalary.getDataEntity.error", (Object)e);
            }
            if (null == salaryDataEntity) {
                dataEntity.set("salarystatus", (Object)"C");
                resultMap.put("success", Boolean.TRUE);
            } else {
                Map<String, Object> data = this.buildSaveSalaryParam(salaryDataEntity, dataEntity);
                data.put("operation", operation);
                resultMap = new HsbsRpcServiceImpl().saveCandidateSalary(data);
                if (((Boolean)resultMap.get("success")).booleanValue()) {
                    dataEntity.set("salarystatus", (Object)"C");
                }
            }
        } else {
            dataEntity.set("salarystatus", (Object)"C");
            resultMap.put("success", Boolean.TRUE);
        }
        return resultMap;
    }

    private Map<String, Object> buildSaveSalaryParam(DynamicObject salaryDataEntity, DynamicObject dataEntity) {
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("offerId", dataEntity.getLong("id"));
        data.put("offerCode", dataEntity.getString("number"));
        data.put("recruitId", dataEntity.getDynamicObject("appfile").getLong("id"));
        data.put("recruitmentType", dataEntity.getDynamicObject("recrutyp").getString("id"));
        if (!HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salaryadjorg"))) {
            data.put("salaryAdjOrg", salaryDataEntity.getDynamicObject("salaryadjorg").getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salarystructure"))) {
            data.put("salaryStructureId", salaryDataEntity.getDynamicObject("salarystructure").getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("currency"))) {
            data.put("currencyId", salaryDataEntity.getDynamicObject("currency").getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salarytypenew"))) {
            data.put("salaryType", salaryDataEntity.getDynamicObject("salarytypenew").getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("stdscm"))) {
            data.put("stdscm", salaryDataEntity.getDynamicObject("stdscm").getLong("id"));
        }
        ArrayList entryEntity = new ArrayList(1);
        DynamicObjectCollection collection = salaryDataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : collection) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("standarditem"))) {
                map.put("salarystditemId", dynamicObject.getDynamicObject("standarditem").getLong("id"));
            }
            if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("currencyent"))) {
                map.put("currencyentId", dynamicObject.getDynamicObject("currencyent").getLong("id"));
            }
            if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("frequency"))) {
                map.put("frequencyId", dynamicObject.getDynamicObject("frequency").getLong("id"));
            }
            if (null != dynamicObject.get("isSend")) {
                map.put("isSend", dynamicObject.get("isSend"));
            }
            if (null != dynamicObject.get("remark")) {
                map.put("remark", dynamicObject.get("remark"));
            }
            if (null != dynamicObject.get("confirmedamount")) {
                map.put("confirmedamount", dynamicObject.get("confirmedamount"));
            }
            entryEntity.add(map);
        }
        data.put("entryEntity", entryEntity);
        ArrayList entryEntityOffer = new ArrayList(1);
        DynamicObjectCollection collection2 = salaryDataEntity.getDynamicObjectCollection("entryentityoffer");
        for (DynamicObject dynamicObject : collection2) {
            HashMap<String, Number> map = new HashMap<String, Number>(8);
            if (!HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("standarditemoffer"))) {
                map.put("salaryStdItemOfferId", dynamicObject.getDynamicObject("standarditemoffer").getLong("id"));
            }
            if (null != dynamicObject.get("confirmedAmountOffer")) {
                map.put("confirmedAmountOffer", dynamicObject.getBigDecimal("confirmedAmountOffer"));
            }
            entryEntityOffer.add(map);
        }
        data.put("entryEntityOffer", entryEntityOffer);
        return data;
    }

    public void showSalaryForm(DynamicObject offerInfo, IFormView view) {
        String appId;
        String changePeadminOrg;
        if (null == offerInfo) {
            log.info("showSalaryForm.offerInfo is null");
            return;
        }
        FormShowParameter salaryForm = new FormShowParameter();
        Object peadminOrg = view.getModel().getDataEntity().get("peadminorg");
        if (HRObjectUtils.isEmpty((Object)peadminOrg)) {
            salaryForm.setStatus(OperationStatus.VIEW);
        } else {
            OperationStatus status = view.getFormShowParameter().getStatus();
            salaryForm.setStatus(OperationStatus.EDIT.equals((Object)status) || OperationStatus.ADDNEW.equals((Object)status) ? OperationStatus.EDIT : OperationStatus.VIEW);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        salaryForm.setFormId("hcdm_candecidedpage");
        if (!HRObjectUtils.isEmpty((Object)offerInfo.getDynamicObject("appfile"))) {
            paramMap.put("appId", offerInfo.getLong("appfile.id"));
        }
        paramMap.put("offerCode", offerInfo.getString("number"));
        if (0L == offerInfo.getLong("id")) {
            offerInfo.set("id", (Object)ORM.create().genLongId(offerInfo.getDynamicObjectType().getName()));
        }
        if ("1".equals(changePeadminOrg = view.getPageCache().get("changePeadminOrg"))) {
            paramMap.put("offerId", 0L);
        } else {
            paramMap.put("offerId", offerInfo.getString("id"));
        }
        OpenStyle commRecOpenStyle = salaryForm.getOpenStyle();
        Optional.ofNullable(commRecOpenStyle).ifPresent(style -> {
            style.setTargetKey("salaryform_flex");
            style.setShowType(ShowType.InContainer);
        });
        Map<String, Object> buildSalaryParam = this.buildSalaryParam(view);
        view.getPageCache().put("buildSalaryParam", buildSalaryParam.toString());
        paramMap.putAll(buildSalaryParam);
        if (null != view.getParentView() && HRStringUtils.equals((String)"wftask", (String)(appId = view.getParentView().getFormShowParameter().getAppId()))) {
            paramMap.put("hasRight", "1");
            salaryForm.setHasRight(true);
        }
        salaryForm.setCustomParams(paramMap);
        log.info("OfferhsbsSalaryInfoEdit.showSalaryForm.param -> {}}", (Object)JSONObject.toJSONString(paramMap));
        view.getPageCache().put("salary" + offerInfo.getString("id"), salaryForm.getPageId());
        view.showForm(salaryForm);
    }

    public String verifyHasPerm(Long offerId, String formId) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return null;
        }
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsrsc", (String)formId, (String)"2W+L22GU4FRY");
        if (!hasPerm) {
            return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7ba1\u7406\u7684\u201c\u85aa\u916c\u5b9a\u85aa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferSalaryService_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        }
        if (null == offerId) {
            log.info("offerId is null ");
            return null;
        }
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(new QFilter[]{new QFilter("id", "=", (Object)offerId)});
        if (HRObjectUtils.isEmpty((Object)offer)) {
            log.info("offer is null ");
            return null;
        }
        CommonRespDTO commonRespDTO = new HsbsRpcServiceImpl().checkPermissionOfCandidateSalaryByOfferId(offerId);
        if (!commonRespDTO.getSuccess().booleanValue()) {
            return commonRespDTO.getMessage();
        }
        return null;
    }

    public DynamicObject getSalaryOrg(Long peadminorgId, Long businesstypeId) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrbuFromManageEmpStrategy", (Object[])new Object[]{peadminorgId, 0L, businesstypeId, 0L});
        if (null != result && 0 != result.size()) {
            DynamicObject createOrg = (DynamicObject)result.get("hrbu");
            return createOrg;
        }
        return null;
    }
}

