/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;

public class SyncOfferStatusToAppFileService {
    public static void syncOfferStatusToAppFile(DynamicObject[] offerInfos) {
        ArrayList<OfferChangeModel> modelList = new ArrayList<OfferChangeModel>(offerInfos.length);
        Arrays.stream(offerInfos).forEach(offerInfo -> {
            OfferChangeModel model = new OfferChangeModel();
            model.setAppFileId(offerInfo.getDynamicObject("appfile").getLong("id"));
            model.setOfferId(offerInfo.getLong("id"));
            Long statusId = SyncOfferStatusToAppFileService.getOfferStatusId(offerInfo);
            if (OfferStatus.ALR_DISCARD.getCode().longValue() == statusId.longValue()) {
                model.setAppfileInProcess("true");
            }
            model.setOfferStatus(statusId);
            modelList.add(model);
        });
        OfferChangeProducer.sendOfferChangeBatch(modelList);
    }

    private static Long getOfferStatusId(DynamicObject offerInfo) {
        Long statusId = 0L;
        Object offerStatusObj = offerInfo.get("status");
        if (offerStatusObj instanceof DynamicObject) {
            OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
            if (offerStatus == OfferStatus.APPLY_PASS) {
                OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offerInfo);
                if (letterStatus == OfferLetterStatus.ALR_SEND) {
                    OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)offerInfo);
                    statusId = replyStatus.getCode();
                } else {
                    statusId = letterStatus.getCode();
                }
            } else {
                statusId = offerStatus.getCode();
            }
        } else if (offerStatusObj instanceof Long) {
            Long offerStatus = (Long)offerStatusObj;
            if (offerStatus.equals(OfferStatus.APPLY_PASS.getCode())) {
                OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offerInfo);
                if (letterStatus == OfferLetterStatus.ALR_SEND) {
                    OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)offerInfo);
                    statusId = replyStatus.getCode();
                } else {
                    statusId = letterStatus.getCode();
                }
            } else {
                statusId = (Long)offerStatusObj;
            }
        }
        return statusId;
    }
}

