/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.advice.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferAdviceBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferContHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.advice.OfferFieldService;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;

public class DefaultOfferFieldServiceImpl
implements OfferFieldService {
    private static final Log log = LogFactory.getLog(DefaultOfferFieldServiceImpl.class);
    private static final String LETTER_LINK = "offerurl";
    private static final String APPLICANT_PHONE = "applyphone";
    private static final String OFFER_NAME = "offerurlname";
    private static final String PHONE = "phone";

    @Override
    public List<DynamicObject> beforeAssemble(DynamicObject offer) {
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        list.add(offer);
        long letterId = offer.getLong("offerletter.id");
        DynamicObject connect = OfferContHelper.getConnect(letterId);
        if (null != connect) {
            list.add(connect);
        }
        return list;
    }

    @Override
    public Map<String, Object> assembleCustom(List<DynamicObject> dys) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        Map entryField = FieldPoolHelper.getEntryField((String)"1");
        for (DynamicObject dy : dys) {
            String entryNumber = dy.getDynamicObjectType().getName();
            List list = (List)entryField.get(entryNumber);
            if (null == list) continue;
            for (String field : list) {
                Object obj;
                if (HRStringUtils.equals((String)"offercontact", (String)field) || HRStringUtils.equals((String)"offercontactphone", (String)field) || null == (obj = dy.get(field))) continue;
                String value = this.getDynamicObjectValue(obj);
                resultMap.put(field, value);
            }
        }
        Set<String> allFields = OfferAdviceBizHelper.getMsgFieldVariableByScene();
        return OfferAdviceBizHelper.getCustomParam(resultMap, allFields);
    }

    @Override
    public Map<String, Object> afterAssemble(List<DynamicObject> dys, Map<String, Object> params) {
        DynamicObject placeWork;
        DynamicObject offer = dys.stream().filter(dy -> dy.getDynamicObjectType().getName().equals("tso_somk_offerbase")).findFirst().get();
        params.put("msgSceneType", CfgMsgScenes.OFFER_NOTIFY.getBaseDataId());
        params.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
        String candidateEmail = offer.getString("candidateemail");
        params.put("email", candidateEmail);
        params.put("candidateemail", candidateEmail);
        String candidatePhone = offer.getString("candidatephone");
        params.put(PHONE, candidatePhone);
        params.put("candidatephone", candidatePhone);
        params.put("yunzhijia", null);
        QFilter qFilter = new QFilter("offer", "=", (Object)offer.getLong("id"));
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOriginalOne("billno", new QFilter[]{qFilter}, "billno desc");
        String letterNo = "";
        letterNo = null == offerLetter ? offer.getDynamicObject("offerletter").getString("billno") : offerLetter.getString("billno");
        log.info("\u53d1\u9001\u7684offer letter\u7f16\u7801\uff1a{}", (Object)letterNo);
        String offerLetterLink = OfferAdviceBizHelper.getOfferLetterLink(letterNo, candidatePhone);
        params.put(LETTER_LINK, offerLetterLink);
        DynamicObject applicant = offer.getDynamicObject("applicant");
        if (null != applicant) {
            params.put(APPLICANT_PHONE, applicant.getString(PHONE));
            params.put("applicant", applicant.getString("name"));
        }
        if (null != (placeWork = offer.getDynamicObject("placework"))) {
            params.put("placework", placeWork.getString("name"));
        }
        String offerName = ResManager.loadKDString((String)"\u67e5\u770bOffer Letter", (String)"DefaultOfferFieldServiceImpl_0", (String)"tsc-tso-business", (Object[])new Object[0]);
        params.put(OFFER_NAME, offerName);
        DynamicObject recruitType = offer.getDynamicObject("recrutyp");
        params.put("recruitmentType", recruitType.getLong("id"));
        params.put("candidatename", offer.getString("candidatename"));
        DynamicObject peCompany = offer.getDynamicObject("pecompany");
        if (null != peCompany) {
            params.put("pecompany", peCompany.getString("name"));
        }
        return params;
    }

    private String getDynamicObjectValue(Object obj) {
        String value = "";
        if (obj instanceof DynamicObject) {
            DynamicObject temDy = (DynamicObject)obj;
            value = temDy.getString("name");
        } else {
            value = obj.toString();
        }
        return value;
    }
}

