/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.approve;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.common.enums.offer.OfferApproveEnum;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileTabHelper;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.CheckPermFactory;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.OfferApproveCheckPerm;
import org.apache.commons.lang3.tuple.Pair;

public class OfferApproveService {
    private static final Log LOGGER = LogFactory.getLog(OfferApproveService.class);

    public void showTabContant(DynamicObject offerDynamic, Map<String, Boolean> tabBtnMap, AbstractFormPlugin plugin, String appId) {
        String skipCheckPerm;
        LOGGER.info("OfferApproveService-showTabContant-tabBtnMap:{}", tabBtnMap);
        if (HRObjectUtils.isEmpty((Object)offerDynamic)) {
            return;
        }
        DynamicObject appfileDynamic = offerDynamic.getDynamicObject("appfile");
        long appFileId = appfileDynamic.getLong("id");
        Long resumId = appfileDynamic.getLong("appres.id");
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(appfileDynamic.getDynamicObject("appres").getDataEntityType().getName());
        DynamicObject appresDynamic = baseServiceHelper.queryOne("id", (Object)resumId);
        Iterator<Map.Entry<String, Boolean>> entryIterator = tabBtnMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, Boolean> entry = entryIterator.next();
            if (entry.getValue().booleanValue()) continue;
            plugin.getView().setVisible(Boolean.FALSE, new String[]{entry.getKey()});
            entryIterator.remove();
        }
        OfferApproveCheckPerm checkPerm = (OfferApproveCheckPerm)CheckPermFactory.getInstance().getCheckPerm("offerapprove");
        boolean isVisible = checkPerm.isVisible(plugin);
        if (!HRObjectUtils.isEmpty((Object)tabBtnMap.get("taboriginrsmtab"))) {
            if (isVisible) {
                skipCheckPerm = plugin.getPageCache().get("skipCheckPerm");
                AppFileTabHelper.previewOriginalResume((Object)appFileId, (String)"taboriginrsmtab", (DynamicObject)appresDynamic, (String)"taboriginrsm_panel", (IFormView)plugin.getView(), (HRStringUtils.isNotEmpty((String)skipCheckPerm) && Boolean.parseBoolean(skipCheckPerm) ? 1 : 0) != 0);
            } else {
                plugin.getView().setVisible(Boolean.valueOf(false), new String[]{"taboriginrsmtab"});
            }
        }
        if (!HRObjectUtils.isEmpty((Object)tabBtnMap.get("tabapprsmtab"))) {
            if (isVisible) {
                if (HRStringUtils.equals((String)"tsrsc", (String)appId)) {
                    this.ShowResumePage("tabapprsm_panel", plugin, appresDynamic);
                } else {
                    AppFileTabHelper.showAppResPage((String)"tabapprsm_panel", (String)"", (AbstractFormPlugin)plugin, (DynamicObject)appresDynamic, (OperationStatus)OperationStatus.VIEW);
                }
            } else {
                plugin.getView().setVisible(Boolean.valueOf(false), new String[]{"tabapprsmtab", "tabsrscarfmrsm"});
            }
        }
        if (isVisible && tabBtnMap.getOrDefault("tabsrscarfmrsm", Boolean.FALSE).booleanValue()) {
            this.initSrscarfmrsmTab(appfileDynamic, plugin);
        }
        if (HRStringUtils.equals((String)"tsrsc", (String)appId)) {
            if (isVisible && tabBtnMap.getOrDefault("tabevaltab", Boolean.FALSE).booleanValue()) {
                skipCheckPerm = plugin.getPageCache().get("skipCheckPerm");
                AppFileTabHelper.initInterviewAssessTab((String)"evalflex", (long)appFileId, (IFormView)plugin.getView(), (HRStringUtils.isNotEmpty((String)skipCheckPerm) && Boolean.parseBoolean(skipCheckPerm) ? 1 : 0) != 0);
            } else {
                plugin.getView().setVisible(Boolean.valueOf(false), new String[]{"tabevaltab"});
            }
        } else {
            if (!AppFileTabHelper.isShowAssessInfoTab((DynamicObject)appfileDynamic)) {
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"tabevaltab"});
            }
            Optional.ofNullable(tabBtnMap.get("tabevaltab")).ifPresent(key -> {
                AppFileTabHelper.initInterviewAssess((String)"interview_panel", (long)appFileId, (IFormView)plugin.getView(), (OperationStatus)OperationStatus.VIEW);
                AppFileTabHelper.initFilterFeedback((String)"filterfeedback_panel", (long)appFileId, (IFormView)plugin.getView(), (OperationStatus)OperationStatus.VIEW);
            });
        }
        Map customParams = plugin.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("hideOfferLetter")) {
            this.openOfferLetter(plugin, offerDynamic);
        }
    }

    public void ShowResumePage(String targetKey, AbstractFormPlugin plugin, DynamicObject appRes) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId(appRes.getPkValue());
        String skipCheckPerm = plugin.getPageCache().get("skipCheckPerm");
        if (HRStringUtils.isNotEmpty((String)skipCheckPerm) && Boolean.parseBoolean(skipCheckPerm)) {
            appResShowParameter.setHasRight(true);
        } else {
            OfferApproveCheckPerm checkPerm = (OfferApproveCheckPerm)CheckPermFactory.getInstance().getCheckPerm("offerapprove");
            boolean isSkipCheckPerm = checkPerm.skipCheckPerm(plugin.getView(), Long.valueOf(RequestContext.get().getCurrUserId()));
            if (isSkipCheckPerm) {
                appResShowParameter.setHasRight(true);
            }
        }
        appResShowParameter.setFormId("tstpm_scsrrsm");
        appResShowParameter.setStatus(OperationStatus.VIEW);
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.setSendToClient(true);
        appResShowParameter.getOpenStyle().setTargetKey(targetKey);
        appResShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tstpm_srrsm"));
        plugin.getView().showForm((FormShowParameter)appResShowParameter);
    }

    private void initSrscarfmrsmTab(DynamicObject appFile, AbstractFormPlugin plugin) {
        DynamicObject arfDy;
        if (!HRObjectUtils.isEmpty((Object)appFile) && !HRObjectUtils.isEmpty((Object)(arfDy = AppFileHelper.queryOne((long)appFile.getLong("id"), (String)"arfrsm")))) {
            String appId;
            long arfrsmId = arfDy.getLong("arfrsm.id");
            BaseShowParameter appResShowParameter = new BaseShowParameter();
            appResShowParameter.setPkId((Object)arfrsmId);
            appResShowParameter.setFormId("tstpm_srscarfmrsm");
            appResShowParameter.setStatus(OperationStatus.VIEW);
            if (null != plugin.getView().getParentView() && HRStringUtils.equals((String)(appId = plugin.getView().getParentView().getFormShowParameter().getAppId()), (String)"wftask")) {
                appResShowParameter.setHasRight(true);
            }
            appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            appResShowParameter.setSendToClient(true);
            appResShowParameter.getOpenStyle().setTargetKey("tabsrscarfmrsm");
            plugin.getView().showForm((FormShowParameter)appResShowParameter);
        }
    }

    private void openOfferLetter(AbstractFormPlugin plugin, DynamicObject offerObj) {
        String letterContent;
        DynamicObject letter = offerObj.getDynamicObject("offerletter");
        if (HRObjectUtils.isEmpty((Object)letter)) {
            letterContent = OfferAttachmentService.getInstance().generateLetterContent(Boolean.TRUE, offerObj);
        } else {
            DynamicObject letterInfo = OfferLetterServiceHelper.getInstance().queryOne(letter.getLong("id"));
            letterContent = letterInfo.getString("lettercontent_tag");
        }
        if (HRStringUtils.isEmpty((String)letterContent)) {
            return;
        }
        FormShowParameter letterParameter = new FormShowParameter();
        letterParameter.setFormId("tso_offerletter_preview");
        letterParameter.getOpenStyle().setTargetKey("offerlettertab");
        letterParameter.getOpenStyle().setShowType(ShowType.InContainer);
        letterParameter.setCustomParam("content", (Object)letterContent);
        letterParameter.setCustomParam("offerid", offerObj.getPkValue());
        plugin.getView().showForm(letterParameter);
    }

    public boolean isNeedApprove() {
        Object o = new BizConfigParamHelper().get("tsrbd_offerconfig", "audit");
        if (Objects.isNull(o)) {
            return false;
        }
        OfferApproveEnum enumByCode = OfferApproveEnum.getEnumByCode((String)o.toString());
        if (enumByCode == OfferApproveEnum.NEED_APPROVE) {
            return true;
        }
        if (enumByCode == OfferApproveEnum.NOT_NEED_APPROVE) {
            return false;
        }
        return false;
    }

    public Pair<DynamicObject, DynamicObject> copyDynamicObject(AbstractFormPlugin plugin, DynamicObject offerApprove, DynamicObject offer) {
        HashSet ignoreKeys = Sets.newHashSet((Object[])new String[]{"id", "tpsys", "createtime", "busunit", "status", "billstatus"});
        if (plugin.getControl("embedofferflex").isInvisible()) {
            DynamicObject template;
            HRDynamicObjectUtils.copy((DynamicObject)offerApprove, (DynamicObject)offer, (Set)ignoreKeys);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_offertemplate");
            DynamicObject offerLetterTemplate = offerApprove.getDynamicObject("template");
            if (!HRObjectUtils.isEmpty((Object)offerLetterTemplate) && !HRObjectUtils.isEmpty((Object)(template = serviceHelper.queryOne((Object)offerLetterTemplate.getLong("id"))))) {
                offer.set("templatecontent_tag", template.get("content_tag"));
            }
        } else {
            HRDynamicObjectUtils.copy((DynamicObject)offer, (DynamicObject)offerApprove, (Set)ignoreKeys);
        }
        return Pair.of((Object)offerApprove, (Object)offer);
    }

    public static enum Singleton {
        INSTANCE;

        private OfferApproveService instance = new OfferApproveService();

        public OfferApproveService getInstance() {
            return this.instance;
        }
    }
}

