/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.abandon;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.bo.OfferAbandonBO;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.service.SyncOfferStatusToAppFileService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.helper.OfferAbandonHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferAbandonMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import org.apache.commons.collections.CollectionUtils;

public class OfferBaseAbandonService {
    private OfferAbandonHelper abandonHelper = OfferAbandonHelper.getInstance();
    private ChangeLetterBillHelper changeLetterBillHelper = ChangeLetterBillHelper.getInstance();
    private Log logger = LogFactory.getLog(OfferBaseAbandonService.class);

    public boolean isVisible(DynamicObject offerInfo) {
        OfferVerifyResult verifyResult = this.canExecute(Collections.singletonList(offerInfo.getLong("id")));
        return verifyResult.getResultType().equals(OfferVerifyResultEnum.ALL_PASS.getCode());
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        OfferVerifyResult verifyResult = new OfferVerifyResult();
        if (CollectionUtils.isEmpty(offerIdList)) {
            this.logger.error("offerIdList is empty");
            verifyResult.setResultType(0, 0);
            return verifyResult;
        }
        List<DynamicObject> offerByIdList = this.abandonHelper.getOfferByIdList(offerIdList);
        ArrayList<Long> passOffers = new ArrayList<Long>(offerByIdList.size());
        offerByIdList.forEach(offer -> {
            if (!this.abandonHelper.verifyOfferStatus((DynamicObject)offer) && !this.abandonHelper.verifyInductionStatus((DynamicObject)offer)) {
                verifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.ABANDON_ERR_005, OfferAbandonMultiLangConstants.offerStatusError());
                return;
            }
            if (!this.abandonHelper.verifyOfferLetterChangeStatus((DynamicObject)offer)) {
                String auditNo = offer.getString("letterauditno");
                verifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.ABANDON_ERR_007, OfferAbandonMultiLangConstants.hasUnFinishedChangeLetterBillError((String)auditNo));
                return;
            }
            passOffers.add(offer.getLong("id"));
        });
        verifyResult.setResultType(passOffers.size(), offerByIdList.size());
        verifyResult.setPassIds(passOffers);
        return verifyResult;
    }

    public boolean abandonOffer(List<Long> offerIdList, OfferAbandonBO abandonBO, String operateName) {
        if (CollectionUtils.isEmpty(offerIdList)) {
            this.logger.error("offerIdList is empty");
            return false;
        }
        if (abandonBO == null) {
            this.logger.error("abandonBO is null");
            return false;
        }
        List<DynamicObject> offerByIdList = this.abandonHelper.getOfferByIdList(offerIdList);
        List<DynamicObject> letterList = this.abandonHelper.getLetterByOfferIdListForAbandon(offerIdList);
        DynamicObject[] waitResubmitBill = this.abandonHelper.getWaitResubmitBill(offerByIdList);
        DynamicObject[] letterChangeBills = this.changeLetterBillHelper.getWaitResubmitBill(offerByIdList);
        try (TXHandle tx = TX.required();){
            try {
                if (waitResubmitBill != null) {
                    this.abandonHelper.updateBillInfo(waitResubmitBill);
                    OfferGenOpRecordService.getInstance().genAbandonOfferBillOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                }
                this.abandonHelper.updateOfferInfo(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc());
                boolean hasOfferLetter = this.abandonHelper.updateLetterInfo(letterList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc());
                SyncOfferStatusToAppFileService.syncOfferStatusToAppFile(offerByIdList.toArray(new DynamicObject[0]));
                this.abandonHelper.sendAbandonMessageToInduction(offerByIdList);
                OfferGenOpRecordService.getInstance().genAbandonOfferOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                if (hasOfferLetter) {
                    OfferGenOpRecordService.getInstance().genAbandonOfferLetterOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                    if (letterChangeBills != null) {
                        this.changeLetterBillHelper.updateBillInfo(letterChangeBills);
                        OfferGenOpRecordService.getInstance().genAbandonOfferLetterBillOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                this.logger.error("\u3010abandonOffer\u3011error: ", (Throwable)e);
                boolean bl = false;
                if (tx != null) {
                    if (var9_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static OfferBaseAbandonService getInstance() {
        return Instance.BASE_INFO_INSTANCE;
    }

    public boolean abandonOfferAndSendMq(List<Long> offerIdList, OfferAbandonBO abandonBO, String operateName) {
        if (CollectionUtils.isEmpty(offerIdList)) {
            this.logger.error("offerIdList is empty");
            return false;
        }
        if (abandonBO == null) {
            this.logger.error("abandonBO is null");
            return false;
        }
        List<DynamicObject> offerByIdList = this.abandonHelper.getOfferByIdList(offerIdList);
        List<DynamicObject> letterList = this.abandonHelper.getLetterByOfferIdListForAbandon(offerIdList);
        DynamicObject[] waitResubmitBill = this.abandonHelper.getWaitResubmitBill(offerByIdList);
        DynamicObject[] letterChangeBills = this.changeLetterBillHelper.getWaitResubmitBill(offerByIdList);
        try (TXHandle tx = TX.required();){
            try {
                if (waitResubmitBill != null) {
                    this.abandonHelper.updateBillInfo(waitResubmitBill);
                    OfferGenOpRecordService.getInstance().genAbandonOfferBillOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                }
                this.abandonHelper.updateOfferInfo(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc());
                boolean hasOfferLetter = this.abandonHelper.updateLetterInfo(letterList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc());
                SyncOfferStatusToAppFileService.syncOfferStatusToAppFile(offerByIdList.toArray(new DynamicObject[0]));
                this.abandonHelper.sendAbandonMessageToInduction(offerByIdList);
                OfferGenOpRecordService.getInstance().genAbandonOfferOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                if (hasOfferLetter) {
                    OfferGenOpRecordService.getInstance().genAbandonOfferLetterOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                    if (letterChangeBills != null) {
                        this.changeLetterBillHelper.updateBillInfo(letterChangeBills);
                        OfferGenOpRecordService.getInstance().genAbandonOfferLetterBillOpRecord(offerByIdList, abandonBO.getAbandonReason(), abandonBO.getAbandonReasonDesc(), operateName);
                    }
                }
                HashMap contentMap = Maps.newHashMapWithExpectedSize((int)2);
                List offerCodes = offerByIdList.stream().filter(off -> "2".equals(off.getString("salarytype"))).map(ids -> ids.getString("number")).collect(Collectors.toList());
                List offerIds = offerByIdList.stream().filter(off -> "2".equals(off.getString("salarytype"))).map(ids -> ids.getLong("id")).collect(Collectors.toList());
                if (0 != offerCodes.size()) {
                    contentMap.put("offerCode", offerCodes);
                    contentMap.put("offerId", offerIds);
                    contentMap.put("offerStatus", "discard");
                    ProducerExecution.handleExecution((String)"hcdm", (Object)contentMap);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                this.logger.error("\u3010abandonOffer\u3011error: ", (Throwable)e);
                boolean bl = false;
                if (tx != null) {
                    if (var9_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private OfferBaseAbandonService() {
    }

    private static class Instance {
        private static final OfferBaseAbandonService BASE_INFO_INSTANCE = new OfferBaseAbandonService();

        private Instance() {
        }
    }
}

