/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.abandon;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.operation.OperationServiceImpl;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferBillAbandonService {
    public static OfferBillAbandonService getInstance() {
        return Instance.BILL_INFO_INSTANCE;
    }

    private OfferBillAbandonService() {
    }

    public boolean isWaitResubmit(DynamicObject offerBillInfo) {
        return OfferAuditStatus.getStatusByCode((String)offerBillInfo.getString("billstatus")) == OfferAuditStatus.WAIT_RESUBMIT;
    }

    public boolean isAlrAbandon(DynamicObject offerBillInfo) {
        return OfferAuditStatus.getStatusByCode((String)offerBillInfo.getString("billstatus")) == OfferAuditStatus.ALR_ABANDON;
    }

    public FormShowParameter showAbandonForm(String formId, String caption, String confirmTipMultiLang, IFormPlugin plugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, formId));
        formShowParameter.setCustomParam("confirmTipMultiLang", (Object)confirmTipMultiLang);
        return formShowParameter;
    }

    public OperationResult cancelWorkFlow(DynamicObject[] offerBills) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        Object[] ids = Arrays.stream(offerBills).map(bill -> bill.getLong("id")).toArray();
        return opImpl.localInvokeOperation("abandon", "tso_offerbillinfo", ids, OperateOption.create());
    }

    public boolean verifyHasPerm(String formId) {
        return OfferPermService.getInstance().verifyHasPerm("bar_abandon", formId, (Long)TSCRequestContext.getOrgId());
    }

    private static class Instance {
        private static final OfferBillAbandonService BILL_INFO_INSTANCE = new OfferBillAbandonService();

        private Instance() {
        }
    }
}

