/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.abandon.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.mq.model.induction.AbandonInductionInfo;
import kd.tsc.tso.business.domain.mq.model.induction.InductionModel;
import kd.tsc.tso.business.domain.mq.producer.InductionProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferAbandonHelper {
    private Log logger = LogFactory.getLog(OfferAbandonHelper.class);

    public boolean verifyPerm(DynamicObject offerInfo) {
        DynamicObject busUnit = offerInfo.getDynamicObject("busunit");
        return OfferPermService.getInstance().verifyHasPerm("bar_abandon", "tso_somk_offerbase", (Long)busUnit.getLong("id"));
    }

    public boolean verifyOfferStatus(DynamicObject offerInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo);
        return offerStatus == OfferStatus.PRE_APPLY && auditStatus == OfferAuditStatus.WAIT_RESUBMIT;
    }

    public boolean verifyInductionStatus(DynamicObject offerInfo) {
        long appfileId = offerInfo.getLong("appfile.id");
        if (appfileId == 0L) {
            return false;
        }
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)appfileId);
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return false;
        }
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return HRStringUtils.isEmpty((String)inductionStatus) && offerStatus == OfferStatus.APPLY_PASS;
    }

    public boolean verifyOfferLetterChangeStatus(DynamicObject offerInfo) {
        String chgLetterValidTimeAuditStatus = offerInfo.getString("letterauditstatus");
        if (HRStringUtils.isEmpty((String)offerInfo.getString("letterauditno"))) {
            return true;
        }
        return !HRStringUtils.equals((String)chgLetterValidTimeAuditStatus, (String)"B") && !HRStringUtils.equals((String)chgLetterValidTimeAuditStatus, (String)"D") && !HRStringUtils.equals((String)chgLetterValidTimeAuditStatus, (String)"A");
    }

    public List<DynamicObject> getOfferByIdList(List<Long> offerIdList) {
        ArrayList<DynamicObject> offerInfoList = new ArrayList<DynamicObject>(offerIdList.size());
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"number", "status", "offerauditno", "offerletter", "busunit", "modifier", "modifytime", "appfile", "recrutyp", "billstatus", "offerabandonreason", "inductionstatus", "salarytype", "offerabandondesc", "offerabandontime", "recruposi", "candidatename", "pindexes", "letterauditno", "letterauditstatus"});
        DynamicObject[] offerInfos = OfferServiceHelper.getInstance().queryOfferByIdList(offerIdList, selectProperties);
        offerInfoList.addAll(Arrays.asList(offerInfos));
        return offerInfoList;
    }

    public List<DynamicObject> getLetterByOfferIdListForAbandon(List<Long> offerIdList) {
        OfferLetterServiceHelper instance = OfferLetterServiceHelper.getInstance();
        QFilter qFilter = new QFilter("offer", "in", offerIdList);
        String selectProperties = instance.getLetterSelectProperties();
        return Arrays.asList(instance.query(selectProperties, qFilter.toArray()));
    }

    public void updateOfferInfo(List<DynamicObject> offerInfoList, Object abandonReason, Object abandonReasonDesc) {
        Date nowDateTime = DateUtils.nowDateTime();
        offerInfoList.forEach(offerInfo -> {
            OfferAuditStatus chgLtrAuditStatus;
            offerInfo.set("pindexes", (Object)OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)offerInfo, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.ABANDON));
            offerInfo.set("offerabandonreason", abandonReason);
            offerInfo.set("offerabandondesc", abandonReasonDesc);
            offerInfo.set("offerabandontime", (Object)nowDateTime);
            offerInfo.set("status", (Object)OfferStatus.ALR_DISCARD.getCode());
            offerInfo.set("modifier", (Object)TSCRequestContext.getUserId());
            OfferAuditStatus offerAuditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo);
            if (offerAuditStatus == OfferAuditStatus.WAIT_RESUBMIT) {
                offerInfo.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
            }
            if ((chgLtrAuditStatus = OfferAuditStatus.getStatusByCode((String)offerInfo.getString("letterauditstatus"))) == OfferAuditStatus.WAIT_RESUBMIT) {
                offerInfo.set("letterauditstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
            }
            offerInfo.set("modifytime", (Object)nowDateTime);
        });
        OfferServiceHelper.getInstance().update(offerInfoList.toArray(new DynamicObject[0]));
    }

    public void updateBillInfo(DynamicObject[] offerBillArr) {
        Arrays.stream(offerBillArr).forEach(offerBill -> {
            offerBill.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
            OfferUtils.updateModifyInfo((DynamicObject)offerBill);
        });
        OfferBillServiceHelper.getInstance().update(offerBillArr);
        this.cancelWorkFlow(offerBillArr);
    }

    public boolean updateLetterInfo(List<DynamicObject> offerLetterList, Object abandonReason, Object abandonReasonDesc) {
        if (offerLetterList == null || offerLetterList.isEmpty()) {
            return false;
        }
        Date nowDateTime = DateUtils.nowDateTime();
        DynamicObject alrDiscard = BusinessDataServiceHelper.loadSingleFromCache((Object)OfferLetterStatus.ALR_DISCARD.getCode(), (String)"tsrbd_offerstatus");
        DynamicObject inValid = BusinessDataServiceHelper.loadSingleFromCache((Object)OfferLetterDataStatus.INVALID.getCode(), (String)"tsrbd_offerstatus");
        offerLetterList.forEach(letter -> {
            OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatus((DynamicObject)letter);
            if (letterStatus == OfferLetterStatus.PRE_SEND || letterStatus == OfferLetterStatus.PRE_GENERATE) {
                letter.set("datastatus", null);
            } else {
                letter.set("datastatus", (Object)inValid);
            }
            letter.set("letterstatus", (Object)alrDiscard);
            letter.set("abandonreason", abandonReason);
            letter.set("abandondesc", abandonReasonDesc);
            letter.set("lastreasonsign", (Object)"abandondesc");
            letter.set("abandontime", (Object)nowDateTime);
            Date validTime = letter.getDate("validtime");
            if (validTime != null && validTime.after(nowDateTime)) {
                letter.set("validtime", (Object)nowDateTime);
            }
            OfferUtils.updateModifyInfo((DynamicObject)letter);
        });
        Object[] update = OfferLetterServiceHelper.getInstance().update(offerLetterList.toArray(new DynamicObject[0]));
        return update.length > 0;
    }

    public DynamicObject[] getWaitResubmitBill(List<DynamicObject> offerInfoList) {
        List offerWithBillList = offerInfoList.stream().filter(offer -> OfferStatusUtil.getOfferAuditStatus((DynamicObject)offer) == OfferAuditStatus.WAIT_RESUBMIT).collect(Collectors.toList());
        if (offerWithBillList.isEmpty()) {
            return null;
        }
        return OfferBillServiceHelper.getInstance().queryByOfferIdList(OfferUtils.getOfferIdListByDts(offerWithBillList));
    }

    public void cancelWorkFlow(DynamicObject[] offerBillArr) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        Object[] ids = Arrays.stream(offerBillArr).map(bill -> bill.getLong("id")).toArray();
        OperationResult abandon = opImpl.localInvokeOperation("abandon", "tso_offerapproveinfo", ids, OperateOption.create());
        this.logger.info("\u3010OfferAbandonService\u3011abandon flower result \"{}\"", (Object)abandon);
    }

    public void sendAbandonMessageToInduction(List<DynamicObject> offerInfoList) {
        List<Long> offerIdList = offerInfoList.stream().filter(offer -> {
            OfferLetterStatus letterStatusByOffer = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offer);
            return letterStatusByOffer == OfferLetterStatus.ALR_SEND;
        }).map(offer -> offer.getLong("id")).collect(Collectors.toList());
        if (offerIdList.isEmpty()) {
            return;
        }
        InductionModel model = new InductionModel();
        model.setMessageType(InductionModel.MessageType.ABANDON_INDUCTION.getCode());
        AbandonInductionInfo abandonInductionInfo = new AbandonInductionInfo();
        abandonInductionInfo.setOfferIdList(offerIdList);
        model.setAbandonInductionInfo(abandonInductionInfo);
        InductionProducer.sendAbandonInductionMessage(Collections.singletonList(model));
    }

    public static OfferAbandonHelper getInstance() {
        return Instance.HELPER;
    }

    private OfferAbandonHelper() {
    }

    private static class Instance {
        private static final OfferAbandonHelper HELPER = new OfferAbandonHelper();

        private Instance() {
        }
    }
}

